/*
 * Decompiled with CFR 0.152.
 */
package dev.lasm.betterp2p.network.data;

import dev.lasm.betterp2p.client.gui.widget.GuiScale;
import dev.lasm.betterp2p.item.BetterMemoryCardModes;
import dev.lasm.betterp2p.network.data.MemoryInfo;
import dev.lasm.betterp2p.network.data.P2PLocation;
import dev.lasm.betterp2p.network.data.P2PLocationKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\b\"\u0014\u0010\n\u001a\u00020\t8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/minecraft/network/FriendlyByteBuf;", "buf", "Ldev/lasm/betterp2p/network/data/MemoryInfo;", "readMemoryInfo", "(Lnet/minecraft/network/FriendlyByteBuf;)Ldev/lasm/betterp2p/network/data/MemoryInfo;", "info", "", "writeMemoryInfo", "(Lnet/minecraft/network/FriendlyByteBuf;Ldev/lasm/betterp2p/network/data/MemoryInfo;)V", "", "TUNNEL_ANY", "I", "betterp2p"})
public final class MemoryInfoKt {
    public static final int TUNNEL_ANY = -1;

    public static final void writeMemoryInfo(@NotNull FriendlyByteBuf buf, @NotNull MemoryInfo info2) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        boolean hasSelected = info2.getSelectedEntry() != null;
        buf.writeBoolean(hasSelected);
        if (hasSelected) {
            P2PLocation p2PLocation = info2.getSelectedEntry();
            Intrinsics.checkNotNull((Object)p2PLocation);
            P2PLocationKt.writeP2PLocation(buf, p2PLocation);
        }
        buf.writeShort((int)info2.getFrequency());
        buf.writeInt(info2.getMode().ordinal());
        buf.writeByte(info2.getGuiScale().ordinal());
        buf.writeByte(info2.getType());
    }

    @NotNull
    public static final MemoryInfo readMemoryInfo(@NotNull FriendlyByteBuf buf) {
        GuiScale e2;
        BetterMemoryCardModes betterMemoryCardModes;
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        P2PLocation selectedEntry = null;
        if (buf.readBoolean()) {
            selectedEntry = P2PLocationKt.readP2PLocation(buf);
        }
        short frequency = buf.readShort();
        try {
            betterMemoryCardModes = BetterMemoryCardModes.values()[buf.readInt()];
        }
        catch (Exception e2) {
            betterMemoryCardModes = BetterMemoryCardModes.OUTPUT;
        }
        BetterMemoryCardModes mode = betterMemoryCardModes;
        try {
            e2 = GuiScale.values()[buf.readByte()];
        }
        catch (ArrayIndexOutOfBoundsException e3) {
            e2 = GuiScale.DYNAMIC;
        }
        GuiScale gui = e2;
        byte type = buf.readByte();
        return new MemoryInfo(selectedEntry, frequency, mode, gui, type);
    }
}

