/*
 * Decompiled with CFR 0.152.
 */
package dev.lasm.betterp2p.network.data;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.me.service.P2PService;
import appeng.parts.AEBasePart;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.util.Platform;
import dev.lasm.betterp2p.BetterP2P;
import dev.lasm.betterp2p.network.data.P2PInfo;
import dev.lasm.betterp2p.network.data.P2PInfoKt;
import dev.lasm.betterp2p.network.data.P2PLocation;
import dev.lasm.betterp2p.network.data.P2PLocationKt;
import dev.lasm.betterp2p.util.p2p.P2PUtilKt;
import dev.lasm.betterp2p.util.p2p.TunnelInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010-\u001a\u00020,\u0012\u0006\u00103\u001a\u000202\u0012\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b;\u0010<J\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ)\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J3\u0010\u0014\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J!\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00022\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\t\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0013\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u001e\u0010\u0010J\u001b\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020\u0002\u00a2\u0006\u0004\b \u0010!JA\u0010'\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\u0016\u001a\u00020\u00022\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\t2\u0006\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u00062\b\u0010&\u001a\u0004\u0018\u00010%H\u0002\u00a2\u0006\u0004\b'\u0010(R\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0014\u0010-\u001a\u00020,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010.R$\u00100\u001a\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0017\u00103\u001a\u0002028\u0006\u00a2\u0006\f\n\u0004\b3\u00104\u001a\u0004\b5\u00106R\"\u0010\u001b\u001a\u00020\u001a8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u00107\u001a\u0004\b8\u00109\"\u0004\b:\u0010\u001d\u00a8\u0006="}, d2={"Ldev/lasm/betterp2p/network/data/GridServerCache;", "", "Ldev/lasm/betterp2p/network/data/P2PLocation;", "p2p", "Ldev/lasm/betterp2p/util/p2p/TunnelInfo;", "newType", "", "changeAllP2Ps", "(Ldev/lasm/betterp2p/network/data/P2PLocation;Ldev/lasm/betterp2p/util/p2p/TunnelInfo;)Z", "Lappeng/parts/p2p/P2PTunnelPart;", "tunnel", "changeP2PType", "(Lappeng/parts/p2p/P2PTunnelPart;Ldev/lasm/betterp2p/util/p2p/TunnelInfo;)Lappeng/parts/p2p/P2PTunnelPart;", "", "Ldev/lasm/betterp2p/network/data/P2PInfo;", "getP2PUpdates", "()Ljava/util/List;", "inputIndex", "outputIndex", "Lkotlin/Pair;", "linkP2P", "(Ldev/lasm/betterp2p/network/data/P2PLocation;Ldev/lasm/betterp2p/network/data/P2PLocation;)Lkotlin/Pair;", "key", "", "markDirty", "(Ldev/lasm/betterp2p/network/data/P2PLocation;Lappeng/parts/p2p/P2PTunnelPart;)V", "", "type", "rebuildList", "(I)V", "retrieveP2PList", "p2pIndex", "unlinkP2P", "(Ldev/lasm/betterp2p/network/data/P2PLocation;)Lappeng/parts/p2p/P2PTunnelPart;", "", "frequency", "output", "Lnet/minecraft/network/chat/Component;", "name", "updateP2P", "(Ldev/lasm/betterp2p/network/data/P2PLocation;Lappeng/parts/p2p/P2PTunnelPart;SZLnet/minecraft/network/chat/Component;)Lappeng/parts/p2p/P2PTunnelPart;", "", "dirtyP2P", "Ljava/util/Set;", "Lappeng/api/networking/IGrid;", "grid", "Lappeng/api/networking/IGrid;", "", "listP2P", "Ljava/util/Map;", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/entity/player/Player;", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "I", "getType", "()I", "setType", "<init>", "(Lappeng/api/networking/IGrid;Lnet/minecraft/world/entity/player/Player;I)V", "betterp2p"})
@SourceDebugExtension(value={"SMAP\nGridServerCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridServerCache.kt\ndev/lasm/betterp2p/network/data/GridServerCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,279:1\n1855#2:280\n1855#2,2:281\n1856#2:283\n1603#2,9:284\n1855#2:293\n1856#2:295\n1612#2:296\n1603#2,9:297\n1855#2:306\n1856#2:308\n1612#2:309\n1#3:294\n1#3:307\n*S KotlinDebug\n*F\n+ 1 GridServerCache.kt\ndev/lasm/betterp2p/network/data/GridServerCache\n*L\n40#1:280\n46#1:281,2\n40#1:283\n62#1:284,9\n62#1:293\n62#1:295\n62#1:296\n85#1:297,9\n85#1:306\n85#1:308\n85#1:309\n62#1:294\n85#1:307\n*E\n"})
public final class GridServerCache {
    @NotNull
    private final IGrid grid;
    @NotNull
    private final Player player;
    private int type;
    @NotNull
    private final Map<P2PLocation, P2PTunnelPart<?>> listP2P;
    @NotNull
    private final Set<P2PLocation> dirtyP2P;

    public GridServerCache(@NotNull IGrid grid, @NotNull Player player, int type) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.grid = grid;
        this.player = player;
        this.type = type;
        this.listP2P = new LinkedHashMap();
        this.dirtyP2P = new LinkedHashSet();
        this.rebuildList(this.type);
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    public final int getType() {
        return this.type;
    }

    public final void setType(int n) {
        this.type = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void rebuildList(int type) {
        Map<P2PLocation, P2PTunnelPart<?>> map = this.listP2P;
        synchronized (map) {
            boolean bl = false;
            this.listP2P.clear();
            this.dirtyP2P.clear();
            Iterable iterable = this.grid.getMachineClasses();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"grid.machineClasses");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Class it = (Class)element$iv;
                boolean bl2 = false;
                if (!P2PTunnelPart.class.isAssignableFrom(it)) continue;
                if (type != -1) {
                    TunnelInfo tunnelInfo = BetterP2P.INSTANCE.getProxy().getP2PFromIndex(type);
                    if (!Intrinsics.areEqual(tunnelInfo != null ? tunnelInfo.getClazz() : null, (Object)it)) continue;
                }
                Set set = this.grid.getMachines(it);
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"grid.getMachines(it)");
                Iterable $this$forEach$iv2 = set;
                boolean $i$f$forEach2 = false;
                Iterator iterator = $this$forEach$iv2.iterator();
                while (iterator.hasNext()) {
                    Object element$iv2;
                    Object gridNode = element$iv2 = iterator.next();
                    boolean bl3 = false;
                    Intrinsics.checkNotNull(gridNode, (String)"null cannot be cast to non-null type appeng.parts.p2p.P2PTunnelPart<*>");
                    P2PTunnelPart p2p = (P2PTunnelPart)gridNode;
                    this.listP2P.put(P2PLocationKt.toLoc(p2p), p2p);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<P2PInfo> retrieveP2PList() {
        void $this$mapNotNullTo$iv$iv;
        this.rebuildList(this.type);
        Iterable $this$mapNotNull$iv = this.listP2P.values();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            P2PInfo it$iv$iv;
            int index;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            P2PTunnelPart it = (P2PTunnelPart)element$iv$iv;
            boolean bl2 = false;
            TunnelInfo tunnelInfo = BetterP2P.INSTANCE.getProxy().getP2PFromClass(it.getClass());
            int n = index = tunnelInfo != null ? tunnelInfo.getIndex() : -1;
            if ((this.type == -1 || index == this.type ? P2PInfoKt.toInfo(it) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markDirty(@NotNull P2PLocation key, @NotNull P2PTunnelPart<?> p2p) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(p2p, (String)"p2p");
        Map<P2PLocation, P2PTunnelPart<?>> map = this.listP2P;
        synchronized (map) {
            boolean bl = false;
            if (this.type == -1 || P2PUtilKt.getTypeIndex(p2p) == this.type) {
                this.listP2P.put(key, p2p);
                this.dirtyP2P.add(key);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<P2PInfo> getP2PUpdates() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.dirtyP2P;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            P2PInfo it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            P2PLocation it = (P2PLocation)element$iv$iv;
            boolean bl2 = false;
            P2PTunnelPart<?> p2PTunnelPart = this.listP2P.get(it);
            if ((p2PTunnelPart != null ? P2PInfoKt.toInfo(p2PTunnelPart) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List result = (List)destination$iv$iv;
        this.dirtyP2P.clear();
        return result;
    }

    @Nullable
    public final Pair<P2PTunnelPart<?>, P2PTunnelPart<?>> linkP2P(@NotNull P2PLocation inputIndex, @NotNull P2PLocation outputIndex) {
        P2PTunnelPart originalInput;
        Intrinsics.checkNotNullParameter((Object)inputIndex, (String)"inputIndex");
        Intrinsics.checkNotNullParameter((Object)outputIndex, (String)"outputIndex");
        P2PTunnelPart<?> p2PTunnelPart = this.listP2P.get(inputIndex);
        if (p2PTunnelPart == null) {
            return null;
        }
        P2PTunnelPart<?> input = p2PTunnelPart;
        P2PTunnelPart<?> p2PTunnelPart2 = this.listP2P.get(outputIndex);
        if (p2PTunnelPart2 == null) {
            return null;
        }
        P2PTunnelPart<?> output = p2PTunnelPart2;
        if (!Intrinsics.areEqual(input.getClass(), output.getClass())) {
            TunnelInfo tunnelInfo = BetterP2P.INSTANCE.getProxy().getP2PFromClass(input.getClass());
            Intrinsics.checkNotNull((Object)tunnelInfo);
            P2PTunnelPart<?> p2PTunnelPart3 = this.changeP2PType(output, tunnelInfo);
            if (p2PTunnelPart3 == null) {
                return null;
            }
            output = p2PTunnelPart3;
        }
        if (Intrinsics.areEqual(input, output)) {
            return null;
        }
        short frequency = input.getFrequency();
        IGridNode iGridNode = input.getGridNode();
        Intrinsics.checkNotNull((Object)iGridNode);
        P2PService cache = P2PService.get((IGrid)iGridNode.getGrid());
        if (input.getFrequency() == 0 || input.isOutput()) {
            frequency = cache.newFrequency();
        }
        if (cache.getInput(frequency) != null && !Intrinsics.areEqual((Object)(originalInput = cache.getInput(frequency)), input)) {
            Intrinsics.checkNotNullExpressionValue((Object)originalInput, (String)"originalInput");
            this.updateP2P(P2PLocationKt.toLoc(originalInput), originalInput, frequency, true, input.m_7770_());
        }
        P2PTunnelPart<?> inputResult = this.updateP2P(inputIndex, input, frequency, false, input.m_7770_());
        P2PTunnelPart<?> outputResult = this.updateP2P(outputIndex, output, frequency, true, input.m_7770_());
        return TuplesKt.to(inputResult, outputResult);
    }

    @Nullable
    public final P2PTunnelPart<?> unlinkP2P(@NotNull P2PLocation p2pIndex) {
        Intrinsics.checkNotNullParameter((Object)p2pIndex, (String)"p2pIndex");
        P2PTunnelPart<?> p2PTunnelPart = this.listP2P.get(p2pIndex);
        if (p2PTunnelPart == null) {
            return null;
        }
        P2PTunnelPart<?> tunnel = p2PTunnelPart;
        short oldFreq = tunnel.getFrequency();
        if (oldFreq == 0) {
            return tunnel;
        }
        return this.updateP2P(p2pIndex, tunnel, (short)0, false, tunnel.m_7770_());
    }

    private final P2PTunnelPart<?> updateP2P(P2PLocation key, P2PTunnelPart<?> tunnel, short frequency, boolean output, Component name) {
        P2PService service = P2PService.get((IGrid)tunnel.getMainNode().getGrid());
        P2PUtilKt.pleaseSetTheFuckingOutputState(tunnel, output);
        P2PUtilKt.setCustomName((AEBasePart)tunnel, name);
        service.updateFreq(tunnel, frequency);
        Platform.notifyBlocksOfNeighbors((Level)tunnel.getBlockEntity().m_58904_(), (BlockPos)tunnel.getBlockEntity().m_58899_());
        return tunnel;
    }

    private final P2PTunnelPart<?> changeP2PType(P2PTunnelPart<?> tunnel, TunnelInfo newType) {
        Level level;
        if (Intrinsics.areEqual((Object)BetterP2P.INSTANCE.getProxy().getP2PFromClass(tunnel.getClass()), (Object)newType)) {
            this.player.m_5661_((Component)Component.m_237115_((String)"gui.advanced_memory_card.error.same_type"), false);
            return null;
        }
        BlockEntity blockEntity = tunnel.getBlockEntity();
        Object object = level = blockEntity != null ? blockEntity.m_58904_() : null;
        if (level instanceof ServerLevel) {
            Ref.ObjectRef newBus = new Ref.ObjectRef();
            ((ServerLevel)level).m_7654_().m_18709_(() -> GridServerCache.changeP2PType$lambda$6(tunnel, newType, newBus, this));
            return (P2PTunnelPart)newBus.element;
        }
        return tunnel;
    }

    public final boolean changeAllP2Ps(@NotNull P2PLocation p2p, @NotNull TunnelInfo newType) {
        Intrinsics.checkNotNullParameter((Object)p2p, (String)"p2p");
        Intrinsics.checkNotNullParameter((Object)newType, (String)"newType");
        P2PTunnelPart p2PTunnelPart = this.listP2P.get(p2p);
        if (p2PTunnelPart == null) {
            return false;
        }
        P2PTunnelPart tunnel = p2PTunnelPart;
        try {
            if (tunnel.isOutput() && tunnel.getInput() != null) {
                P2PTunnelPart p2PTunnelPart2 = tunnel.getInput();
                Intrinsics.checkNotNull((Object)p2PTunnelPart2);
                tunnel = p2PTunnelPart2;
            }
            List list = tunnel.getOutputs();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"tunnel.outputs");
            List outputs = CollectionsKt.toMutableList((Collection)list);
            this.changeP2PType(tunnel, newType);
            for (P2PTunnelPart o : outputs) {
                Intrinsics.checkNotNullExpressionValue((Object)o, (String)"o");
                this.changeP2PType(o, newType);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static final void changeP2PType$lambda$6(P2PTunnelPart $tunnel, TunnelInfo $newType, Ref.ObjectRef $newBus, GridServerCache this$0) {
        Intrinsics.checkNotNullParameter((Object)$tunnel, (String)"$tunnel");
        Intrinsics.checkNotNullParameter((Object)$newType, (String)"$newType");
        Intrinsics.checkNotNullParameter((Object)$newBus, (String)"$newBus");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        boolean oldOutput = $tunnel.isOutput();
        short freq = $tunnel.getFrequency();
        Objects.requireNonNull($tunnel.getBlockEntity());
        if (!($newType.getStack().m_41720_() instanceof IPartItem)) {
            BetterP2P.INSTANCE.getLogger().error("Attempt to assign a invalid type {} to tunnel {}, this shouldn't happen!", (Object)$newType, (Object)$tunnel.getBlockEntity());
            return;
        }
        Item item = $newType.getStack().m_41720_();
        Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type appeng.api.parts.IPartItem<*>");
        IPartItem partItem = (IPartItem)item;
        if (!P2PTunnelPart.class.isAssignableFrom(partItem.getPartClass())) {
            BetterP2P.INSTANCE.getLogger().error("Attempt to assign a invalid type {} to tunnel {}, this shouldn't happen!", (Object)partItem.getPartClass(), (Object)$tunnel.getBlockEntity());
            return;
        }
        Object object = $newBus.element = $tunnel;
        Intrinsics.checkNotNull((Object)object);
        if (((P2PTunnelPart)object).getPartItem() != partItem) {
            IPart iPart = $tunnel.getHost().replacePart(partItem, $tunnel.getSide(), this$0.player, InteractionHand.MAIN_HAND);
            Intrinsics.checkNotNull((Object)iPart);
            P2PTunnelPart replaced = (P2PTunnelPart)iPart;
            P2PUtilKt.pleaseSetTheFuckingOutputState(replaced, oldOutput);
            replaced.onTunnelNetworkChange();
            replaced.setFrequency(freq);
            $newBus.element = replaced;
        }
        Platform.notifyBlocksOfNeighbors((Level)$tunnel.getLevel(), (BlockPos)$tunnel.getBlockEntity().m_58899_());
    }
}

