/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.compat;

import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.DyenamicsAndFriends;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.RegistryObject;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedcore.crafting.StorageDyeRecipeBase;

public class SophisticatedBackpacksCompat {
    public static final RegistryObject<SimpleCraftingRecipeSerializer<?>> BACKPACK_DYE_RECIPE_SERIALIZER = DyenamicsAndFriends.RECIPE_SERIALIZERS.register("sophisticated_backpackdye", () -> new SimpleCraftingRecipeSerializer(BackpackDyeRecipe::new));
    public static final RegistryObject<RecipeType<BackpackDyeRecipe>> BACKPACK_DYE_RECIPE_TYPE = DyenamicsAndFriends.RECIPE_TYPES.register("sophisticated_backpackdye", () -> new RecipeType<BackpackDyeRecipe>(){});

    public static void postRegister() {
    }

    public static class BackpackDyeRecipe
    extends StorageDyeRecipeBase {
        public BackpackDyeRecipe(ResourceLocation registryName, CraftingBookCategory category) {
            super(registryName, category);
        }

        public RecipeSerializer<?> m_7707_() {
            return (RecipeSerializer)BACKPACK_DYE_RECIPE_SERIALIZER.get();
        }

        public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
            HashMap<Integer, List<DyenamicDyeColor>> columnDyes = new HashMap<Integer, List<DyenamicDyeColor>>();
            Tuple columnStorage = null;
            for (int slot = 0; slot < inv.m_6643_(); ++slot) {
                ItemStack slotStack = inv.m_8020_(slot);
                if (slotStack.m_41619_()) continue;
                int column = slot % inv.m_39347_();
                if (this.isDyeableStorageItem(slotStack)) {
                    if (columnStorage != null) {
                        return ItemStack.f_41583_;
                    }
                    columnStorage = new Tuple((Object)column, (Object)slotStack);
                    continue;
                }
                if (slotStack.m_204117_(Tags.Items.DYES)) {
                    DyenamicDyeColor dyeColor = DyenamicDyeColor.getColor((ItemStack)slotStack);
                    if (dyeColor == null) {
                        return ItemStack.f_41583_;
                    }
                    columnDyes.computeIfAbsent(column, c -> new ArrayList()).add(dyeColor);
                    continue;
                }
                return ItemStack.f_41583_;
            }
            if (columnStorage == null) {
                return ItemStack.f_41583_;
            }
            ItemStack coloredStorage = ((ItemStack)columnStorage.m_14419_()).m_41777_();
            coloredStorage.m_41764_(1);
            int storageColumn = (Integer)columnStorage.m_14418_();
            this.applyTintColors(columnDyes, coloredStorage, storageColumn);
            return coloredStorage;
        }

        private void applyTintColors(Map<Integer, List<DyenamicDyeColor>> columnDyes, ItemStack coloredStorage, int storageColumn) {
            ArrayList<DyenamicDyeColor> mainDyes = new ArrayList<DyenamicDyeColor>();
            ArrayList<DyenamicDyeColor> trimDyes = new ArrayList<DyenamicDyeColor>();
            for (Map.Entry<Integer, List<DyenamicDyeColor>> entry : columnDyes.entrySet()) {
                if (entry.getKey() <= storageColumn) {
                    mainDyes.addAll((Collection<DyenamicDyeColor>)entry.getValue());
                }
                if (entry.getKey() < storageColumn) continue;
                trimDyes.addAll((Collection<DyenamicDyeColor>)entry.getValue());
            }
            this.applyDyenamicsColors(coloredStorage, mainDyes, trimDyes);
        }

        protected boolean isDyeableStorageItem(ItemStack stack) {
            return stack.m_41720_() instanceof BackpackItem;
        }

        protected void applyColors(ItemStack itemStack, List<DyeColor> list, List<DyeColor> list1) {
        }

        private void applyDyenamicsColors(ItemStack coloredStorage, List<DyenamicDyeColor> mainDyes, List<DyenamicDyeColor> trimDyes) {
            coloredStorage.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(coloredWrapper -> coloredWrapper.setColors(BackpackDyeRecipe.calculateColor(coloredWrapper.getMainColor(), 13394234, mainDyes), BackpackDyeRecipe.calculateColor(coloredWrapper.getAccentColor(), 6434330, trimDyes)));
        }

        public static int calculateColor(int baseColor, int defaultColor, List<DyenamicDyeColor> dyes) {
            if (dyes.isEmpty()) {
                return baseColor;
            }
            int[] rgb = new int[3];
            int sumMaxComponent = 0;
            int numberOfColors = 0;
            if (baseColor != defaultColor) {
                float baseRed = baseColor >> 16 & 0xFF;
                float baseGreen = baseColor >> 8 & 0xFF;
                float baseBlue = baseColor & 0xFF;
                sumMaxComponent = (int)((float)sumMaxComponent + Math.max(baseRed, Math.max(baseGreen, baseBlue)));
                rgb[0] = (int)((float)rgb[0] + baseRed);
                rgb[1] = (int)((float)rgb[1] + baseGreen);
                rgb[2] = (int)((float)rgb[2] + baseBlue);
                ++numberOfColors;
            }
            for (DyenamicDyeColor dye : dyes) {
                float[] dyeRgb = dye.getColorComponentValues();
                int dyeRed = (int)(dyeRgb[0] * 255.0f);
                int dyeGreen = (int)(dyeRgb[1] * 255.0f);
                int dyeBlue = (int)(dyeRgb[2] * 255.0f);
                sumMaxComponent += Math.max(dyeRed, Math.max(dyeGreen, dyeBlue));
                rgb[0] = rgb[0] + dyeRed;
                rgb[1] = rgb[1] + dyeGreen;
                rgb[2] = rgb[2] + dyeBlue;
                ++numberOfColors;
            }
            int avgRed = rgb[0] / numberOfColors;
            int avgGreen = rgb[1] / numberOfColors;
            int avgBlue = rgb[2] / numberOfColors;
            float avgMaxComponent = (float)sumMaxComponent / (float)numberOfColors;
            float maxAvgComponent = Math.max(avgRed, Math.max(avgGreen, avgBlue));
            avgRed = (int)((float)avgRed * avgMaxComponent / maxAvgComponent);
            avgGreen = (int)((float)avgGreen * avgMaxComponent / maxAvgComponent);
            avgBlue = (int)((float)avgBlue * avgMaxComponent / maxAvgComponent);
            int finalColor = (avgRed << 8) + avgGreen;
            finalColor = (finalColor << 8) + avgBlue;
            return finalColor;
        }
    }
}

