/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.compat;

import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.registry.DyenamicRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.RegistryObject;

public class RegionsUnexploredCompat {
    private static final Map<DyenamicDyeColor, RegistryObject<? extends Block>> PLANKS = new HashMap<DyenamicDyeColor, RegistryObject<? extends Block>>();
    private static final Map<DyenamicDyeColor, RegistryObject<? extends Block>> STAIRS = new HashMap<DyenamicDyeColor, RegistryObject<? extends Block>>();
    private static final Map<DyenamicDyeColor, RegistryObject<? extends Block>> SLABS = new HashMap<DyenamicDyeColor, RegistryObject<? extends Block>>();

    public static void registerBlocks(DyenamicDyeColor color) {
        String prefix = "regions_unexplored_" + color.m_7912_();
        PLANKS.put(color, DyenamicRegistry.registerBlock(prefix + "_painted_planks", () -> new Block(BlockBehaviour.Properties.m_284310_().m_284180_(color.getMapColor()).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60953_(state -> color.getLightValue())), true));
        STAIRS.put(color, DyenamicRegistry.registerBlock(prefix + "_painted_stairs", () -> new StairBlock(() -> ((Block)PLANKS.get(color).get()).m_49966_(), BlockBehaviour.Properties.m_284310_().m_284180_(color.getMapColor()).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60953_(state -> color.getLightValue())), true));
        SLABS.put(color, DyenamicRegistry.registerBlock(prefix + "_painted_slab", () -> new SlabBlock(BlockBehaviour.Properties.m_284310_().m_284180_(color.getMapColor()).m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_60953_(state -> color.getLightValue())), true));
    }

    public static void buildTabContents(BuildCreativeModeTabContentsEvent event) {
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("regions_unexplored:ru_main"));
        if (event.getTabKey().equals((Object)key)) {
            PLANKS.forEach((dyenamicDyeColor, registryObject) -> event.accept((Supplier)registryObject));
            STAIRS.forEach((dyenamicDyeColor, registryObject) -> event.accept((Supplier)registryObject));
            SLABS.forEach((dyenamicDyeColor, registryObject) -> event.accept((Supplier)registryObject));
        }
    }
}

