/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamicsandfriends.compat;

import appeng.api.ids.AECreativeTabIds;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartModels;
import appeng.items.parts.ColoredPartItem;
import appeng.items.parts.PartModelsHelper;
import appeng.parts.AEBasePart;
import appeng.parts.networking.CoveredCablePart;
import appeng.parts.networking.CoveredDenseCablePart;
import appeng.parts.networking.GlassCablePart;
import appeng.parts.networking.SmartCablePart;
import appeng.parts.networking.SmartDenseCablePart;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import cy.jdkdigital.dyenamics.core.init.BlockInit;
import cy.jdkdigital.dyenamics.core.util.DyenamicDyeColor;
import cy.jdkdigital.dyenamicsandfriends.common.item.ae2.DyenamicsColorApplicatorItem;
import cy.jdkdigital.dyenamicsandfriends.common.item.ae2.DyenamicsColoredPartItem;
import cy.jdkdigital.dyenamicsandfriends.registry.DyenamicRegistry;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.RegistryObject;

public class Ae2Compat {
    public static MethodHandle setPartItemHandle;
    static RegistryObject<? extends Item> COLOR_APPLICATOR;
    public static Map<DyenamicDyeColor, RegistryObject<ColoredPartItem<SmartCablePart>>> SMART_CABLES;
    public static Map<DyenamicDyeColor, RegistryObject<ColoredPartItem<CoveredCablePart>>> COVERED_CABLES;
    public static Map<DyenamicDyeColor, RegistryObject<ColoredPartItem<GlassCablePart>>> GLASS_CABLES;
    public static Map<DyenamicDyeColor, RegistryObject<ColoredPartItem<CoveredDenseCablePart>>> COVERED_DENSE_CABLES;
    public static Map<DyenamicDyeColor, RegistryObject<ColoredPartItem<SmartDenseCablePart>>> SMART_DENSE_CABLES;

    public static void registerBlocks(DyenamicDyeColor color) {
        String prefix = "ae2_" + color.m_7912_();
    }

    public static void buildTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals((Object)AECreativeTabIds.MAIN)) {
            event.accept(COLOR_APPLICATOR);
        }
    }

    public static void postRegister() {
        COLOR_APPLICATOR = DyenamicRegistry.registerItem("color_applicator", () -> new DyenamicsColorApplicatorItem(new Item.Properties().m_41487_(1)));
        SMART_CABLES = Ae2Compat.constructColoredDefinition("smart_cable", SmartCablePart.class, SmartCablePart::new);
        COVERED_CABLES = Ae2Compat.constructColoredDefinition("covered_cable", CoveredCablePart.class, CoveredCablePart::new);
        GLASS_CABLES = Ae2Compat.constructColoredDefinition("glass_cable", GlassCablePart.class, GlassCablePart::new);
        COVERED_DENSE_CABLES = Ae2Compat.constructColoredDefinition("covered_dense_cable", CoveredDenseCablePart.class, CoveredDenseCablePart::new);
        SMART_DENSE_CABLES = Ae2Compat.constructColoredDefinition("smart_dense_cable", SmartDenseCablePart.class, SmartDenseCablePart::new);
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandles.Lookup targetLookup = MethodHandles.privateLookupIn(AEBasePart.class, lookup);
            MethodType mt = MethodType.methodType(Void.TYPE, IPartItem.class);
            setPartItemHandle = targetLookup.findVirtual(AEBasePart.class, "setPartItem", mt);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private static <T extends IPart> Map<DyenamicDyeColor, RegistryObject<ColoredPartItem<T>>> constructColoredDefinition(String idSuffix, Class<T> partClass, Function<ColoredPartItem<T>, T> factory) {
        PartModels.registerModels((Collection)PartModelsHelper.createModels(partClass));
        HashMap<DyenamicDyeColor, RegistryObject<ColoredPartItem<T>>> definition = new HashMap<DyenamicDyeColor, RegistryObject<ColoredPartItem<T>>>();
        for (DyenamicDyeColor color : DyenamicDyeColor.dyenamicValues()) {
            String id = "ae2_" + color.m_7912_() + "_" + idSuffix;
            definition.put(color, DyenamicRegistry.registerItem(id, () -> new DyenamicsColoredPartItem(new Item.Properties(), partClass, factory, color)));
        }
        return definition;
    }

    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(BlockRecolorer::register);
    }

    static {
        SMART_CABLES = new HashMap<DyenamicDyeColor, RegistryObject<ColoredPartItem<SmartCablePart>>>();
        COVERED_CABLES = new HashMap<DyenamicDyeColor, RegistryObject<ColoredPartItem<CoveredCablePart>>>();
        GLASS_CABLES = new HashMap<DyenamicDyeColor, RegistryObject<ColoredPartItem<GlassCablePart>>>();
        COVERED_DENSE_CABLES = new HashMap<DyenamicDyeColor, RegistryObject<ColoredPartItem<CoveredDenseCablePart>>>();
        SMART_DENSE_CABLES = new HashMap<DyenamicDyeColor, RegistryObject<ColoredPartItem<SmartDenseCablePart>>>();
    }

    public final class BlockRecolorer {
        private static BiMap<DyenamicDyeColor, Block> STAINED_GLASS_BY_COLOR;
        private static BiMap<DyenamicDyeColor, Block> STAINED_GLASS_PANE_BY_COLOR;
        private static BiMap<DyenamicDyeColor, Block> WOOL_BY_COLOR;
        private static BiMap<DyenamicDyeColor, Block> BANNER_BY_COLOR;
        private static BiMap<DyenamicDyeColor, Block> WALL_BANNER_BY_COLOR;
        private static BiMap<DyenamicDyeColor, Block> CARPET_BY_COLOR;
        private static BiMap<DyenamicDyeColor, Block> TERRACOTTA_BY_COLOR;
        private static BiMap<DyenamicDyeColor, Block> GLAZED_TERRACOTTA_BY_COLOR;
        private static BiMap<DyenamicDyeColor, Block> CONCRETE_BY_COLOR;
        private static List<RecolorableBlockGroup> BLOCK_GROUPS;

        public static void register() {
            STAINED_GLASS_BY_COLOR = (BiMap)Arrays.stream(DyenamicDyeColor.dyenamicValues()).collect(HashBiMap::create, (bm, c) -> bm.put(c, (Object)((Block)((RegistryObject)((Map)BlockInit.DYED_BLOCKS.get(c.m_7912_())).get("stained_glass")).get())), BiMap::putAll);
            STAINED_GLASS_PANE_BY_COLOR = (BiMap)Arrays.stream(DyenamicDyeColor.dyenamicValues()).collect(HashBiMap::create, (bm, c) -> bm.put(c, (Object)((Block)((RegistryObject)((Map)BlockInit.DYED_BLOCKS.get(c.m_7912_())).get("stained_glass_pane")).get())), BiMap::putAll);
            WOOL_BY_COLOR = (BiMap)Arrays.stream(DyenamicDyeColor.dyenamicValues()).collect(HashBiMap::create, (bm, c) -> bm.put(c, (Object)((Block)((RegistryObject)((Map)BlockInit.DYED_BLOCKS.get(c.m_7912_())).get("wool")).get())), BiMap::putAll);
            BANNER_BY_COLOR = (BiMap)Arrays.stream(DyenamicDyeColor.dyenamicValues()).collect(HashBiMap::create, (bm, c) -> bm.put(c, (Object)((Block)((RegistryObject)((Map)BlockInit.DYED_BLOCKS.get(c.m_7912_())).get("banner")).get())), BiMap::putAll);
            WALL_BANNER_BY_COLOR = (BiMap)Arrays.stream(DyenamicDyeColor.dyenamicValues()).collect(HashBiMap::create, (bm, c) -> bm.put(c, (Object)((Block)((RegistryObject)((Map)BlockInit.DYED_BLOCKS.get(c.m_7912_())).get("wall_banner")).get())), BiMap::putAll);
            CARPET_BY_COLOR = (BiMap)Arrays.stream(DyenamicDyeColor.dyenamicValues()).collect(HashBiMap::create, (bm, c) -> bm.put(c, (Object)((Block)((RegistryObject)((Map)BlockInit.DYED_BLOCKS.get(c.m_7912_())).get("carpet")).get())), BiMap::putAll);
            TERRACOTTA_BY_COLOR = (BiMap)Arrays.stream(DyenamicDyeColor.dyenamicValues()).collect(HashBiMap::create, (bm, c) -> bm.put(c, (Object)((Block)((RegistryObject)((Map)BlockInit.DYED_BLOCKS.get(c.m_7912_())).get("terracotta")).get())), BiMap::putAll);
            GLAZED_TERRACOTTA_BY_COLOR = (BiMap)Arrays.stream(DyenamicDyeColor.dyenamicValues()).collect(HashBiMap::create, (bm, c) -> bm.put(c, (Object)((Block)((RegistryObject)((Map)BlockInit.DYED_BLOCKS.get(c.m_7912_())).get("glazed_terracotta")).get())), BiMap::putAll);
            CONCRETE_BY_COLOR = (BiMap)Arrays.stream(DyenamicDyeColor.dyenamicValues()).collect(HashBiMap::create, (bm, c) -> bm.put(c, (Object)((Block)((RegistryObject)((Map)BlockInit.DYED_BLOCKS.get(c.m_7912_())).get("concrete")).get())), BiMap::putAll);
            BLOCK_GROUPS = ImmutableList.of((Object)new RecolorableBlockGroup(Blocks.f_50058_, STAINED_GLASS_BY_COLOR), (Object)new RecolorableBlockGroup(Blocks.f_50185_, STAINED_GLASS_PANE_BY_COLOR), (Object)new RecolorableBlockGroup(Blocks.f_50041_, WOOL_BY_COLOR), (Object)new RecolorableBlockGroup(Blocks.f_50414_, BANNER_BY_COLOR), (Object)new RecolorableBlockGroup(Blocks.f_50430_, WALL_BANNER_BY_COLOR), (Object)new RecolorableBlockGroup(Blocks.f_50336_, CARPET_BY_COLOR), (Object)new RecolorableBlockGroup(Blocks.f_50352_, TERRACOTTA_BY_COLOR), (Object)new RecolorableBlockGroup(null, GLAZED_TERRACOTTA_BY_COLOR), (Object)new RecolorableBlockGroup(null, CONCRETE_BY_COLOR));
        }

        public static Block recolor(Block block, DyenamicDyeColor newColor) {
            Objects.requireNonNull(block);
            for (RecolorableBlockGroup group : BLOCK_GROUPS) {
                if (group.uncoloredVariant != block && !group.coloredVariants.containsValue((Object)block)) continue;
                Block newBlock = (Block)group.coloredVariants.get((Object)newColor);
                if (newBlock == null) {
                    newBlock = group.uncoloredVariant != null ? group.uncoloredVariant : block;
                }
                return newBlock;
            }
            return block;
        }

        private static class RecolorableBlockGroup {
            final Block uncoloredVariant;
            final BiMap<DyenamicDyeColor, Block> coloredVariants;

            public RecolorableBlockGroup(Block uncoloredVariant, BiMap<DyenamicDyeColor, Block> coloredVariants) {
                this.uncoloredVariant = uncoloredVariant;
                this.coloredVariants = coloredVariants;
            }
        }
    }
}

