/*
 * Decompiled with CFR 0.152.
 */
package com.farsight;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundForgetLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jctools.maps.NonBlockingHashMapLong;

public class FarsightClientChunkManager
extends ClientChunkCache {
    private static int EXTRA_CHUNK_DATA_LEEWAY = 10;
    private final NonBlockingHashMapLong<LevelChunk> chunks = new NonBlockingHashMapLong();
    private final Long2ObjectOpenHashMap<ClientboundForgetLevelChunkPacket> unloadedOnServer = new Long2ObjectOpenHashMap();
    private final ClientLevel world;
    public ClientPacketListener packetListener = null;
    public static List<BiConsumer<ClientLevel, LevelChunk>> unloadCallback = new ArrayList<BiConsumer<ClientLevel, LevelChunk>>();
    public static List<BiConsumer<ClientLevel, LevelChunk>> loadCallback = new ArrayList<BiConsumer<ClientLevel, LevelChunk>>();
    boolean unloading = false;

    public FarsightClientChunkManager(ClientLevel world) {
        super(world, 5);
        this.world = world;
    }

    public LevelChunk m_7587_(int x, int z, ChunkStatus leastStatus, boolean create) {
        LevelChunk chunk = (LevelChunk)this.chunks.get(ChunkPos.m_45589_((int)x, (int)z));
        if (chunk != null) {
            return chunk;
        }
        if (create) {
            return this.f_104408_;
        }
        return null;
    }

    public String m_6754_() {
        return this.chunks.size() + ", " + this.m_8482_();
    }

    public int m_8482_() {
        return this.chunks.size();
    }

    public void m_104416_(int loadDistance) {
    }

    public LevelChunk m_194116_(int x, int z, FriendlyByteBuf buf, CompoundTag nbt, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> consumer) {
        LevelChunk levelChunk = (LevelChunk)this.chunks.get(ChunkPos.m_45589_((int)x, (int)z));
        if (levelChunk == null) {
            levelChunk = new LevelChunk((Level)this.world, new ChunkPos(x, z));
            levelChunk.m_187971_(buf, nbt, consumer);
            this.chunks.put(ChunkPos.m_45589_((int)x, (int)z), (Object)levelChunk);
        } else {
            this.world.m_104665_(levelChunk);
            levelChunk.m_187971_(buf, nbt, consumer);
        }
        this.unloadedOnServer.remove(ChunkPos.m_45589_((int)x, (int)z));
        this.world.m_171649_(new ChunkPos(x, z));
        for (BiConsumer<ClientLevel, LevelChunk> loadCallbackEntry : loadCallback) {
            loadCallbackEntry.accept(this.world, levelChunk);
        }
        return levelChunk;
    }

    public void m_104455_(int chunkX, int chunkZ) {
        LevelChunk chunk = (LevelChunk)this.chunks.remove(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
        if (chunk == null) {
            return;
        }
        for (BiConsumer<ClientLevel, LevelChunk> unloader : unloadCallback) {
            unloader.accept(this.world, chunk);
        }
        this.world.m_104665_(chunk);
    }

    public void m_274444_(int x, int z, FriendlyByteBuf data) {
        LevelChunk levelChunk = (LevelChunk)this.chunks.get(ChunkPos.m_45589_((int)x, (int)z));
        if (levelChunk != null) {
            levelChunk.m_274381_(data);
        }
    }

    public int getChebyshevDistance(int chunkXa, int chunkZa, int chunkXb, int chunkZb) {
        return Math.max(Math.abs(chunkXa - chunkXb), Math.abs(chunkZa - chunkZb));
    }

    public boolean delayUnload(ClientboundForgetLevelChunkPacket packet) {
        if (this.unloading) {
            return false;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            this.unloadedOnServer.clear();
            return false;
        }
        if (player.m_146902_().m_45594_(new ChunkPos(packet.m_132149_(), packet.m_132152_())) > (Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_() + EXTRA_CHUNK_DATA_LEEWAY) {
            return false;
        }
        this.unloadedOnServer.put(ChunkPos.m_45589_((int)packet.m_132149_(), (int)packet.m_132152_()), (Object)packet);
        ObjectIterator iterator = this.unloadedOnServer.long2ObjectEntrySet().fastIterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            long chunkLong = entry.getLongKey();
            if (this.getChebyshevDistance(player.m_146902_().f_45578_, player.m_146902_().f_45579_, ChunkPos.m_45592_((long)chunkLong), ChunkPos.m_45602_((long)chunkLong)) <= (Integer)Minecraft.m_91087_().f_91066_.m_231984_().m_231551_() + EXTRA_CHUNK_DATA_LEEWAY) continue;
            this.unloading = true;
            if (this.packetListener != null) {
                this.packetListener.m_5729_((ClientboundForgetLevelChunkPacket)entry.getValue());
            }
            this.unloading = false;
            iterator.remove();
        }
        return true;
    }
}

