/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.utilitarian.event;

import cy.jdkdigital.utilitarian.Config;
import cy.jdkdigital.utilitarian.Utilitarian;
import cy.jdkdigital.utilitarian.module.NoSolicitingModule;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="utilitarian")
public class EventHandler {
    @SubscribeEvent
    static void onEntitySpawn(EntityJoinLevelEvent event) {
        Level level;
        if (((Boolean)Config.SERVER.NO_SOLICITING_ENABLED.get()).booleanValue() && !event.loadedFromDisk() && (level = event.getLevel()) instanceof ServerLevel) {
            LivingEntity entity;
            ServerLevel serverLevel = (ServerLevel)level;
            level = event.getEntity();
            if (level instanceof LivingEntity && (entity = (LivingEntity)level).m_6095_().m_204039_(NoSolicitingModule.ENTITY_BLACKLIST)) {
                BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
                executor.m_6937_((Runnable)new TickTask(0, () -> {
                    List<BlockPos> nearbySoliciting = NoSolicitingModule.locateNearbySoliciting(serverLevel, event.getEntity().m_20183_());
                    if (nearbySoliciting.size() > 0) {
                        BlockPos pos = nearbySoliciting.get(0);
                        entity.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                        if (serverLevel.m_8055_(pos).m_204336_(NoSolicitingModule.TRAPPED_SOLICITING_CARPETS)) {
                            entity.m_6074_();
                        }
                    } else {
                        int nearbyNoSolicitingCount = NoSolicitingModule.locateNearbyNoSoliciting(serverLevel, event.getEntity().m_20183_());
                        if (nearbyNoSolicitingCount > 0) {
                            entity.m_146870_();
                        }
                    }
                }));
            }
        }
    }

    @SubscribeEvent
    public static void blockToolModified(BlockEvent.BlockToolModificationEvent event) {
        LevelAccessor levelAccessor;
        if (((Boolean)Config.SERVER.HOE_PLANTING_ENABLED.get()).booleanValue() && !event.isSimulated() && event.getToolAction().equals(ToolActions.HOE_TILL) && (levelAccessor = event.getLevel()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            if (event.getPlayer() != null && level.m_8055_(event.getPos().m_7494_()).m_247087_()) {
                ItemStack slotItem;
                ItemStack seedStack = ItemStack.f_41583_;
                if (event.getPlayer().m_21206_().m_204117_(Tags.Items.SEEDS)) {
                    seedStack = event.getPlayer().m_21206_();
                    event.getPlayer().m_6674_(InteractionHand.OFF_HAND);
                } else {
                    for (int i = 0; i <= 9; ++i) {
                        slotItem = event.getPlayer().m_150109_().m_8020_(i);
                        if (slotItem.m_41619_() || !slotItem.m_204117_(Tags.Items.SEEDS)) continue;
                        seedStack = slotItem;
                        event.getPlayer().m_6674_(InteractionHand.MAIN_HAND);
                        break;
                    }
                }
                if (!seedStack.m_41619_() && !seedStack.m_204117_(Utilitarian.BLACKLISTED_SEEDS) && (slotItem = seedStack.m_41720_()) instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)slotItem;
                    ItemStack usedSeedStack = seedStack;
                    BlockableEventLoop executor = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
                    executor.m_6937_((Runnable)new TickTask(0, () -> {
                        if (level.m_8055_(event.getPos()).m_60734_() instanceof FarmBlock) {
                            BlockHitResult hitResult = new BlockHitResult(Vec3.f_82478_, Direction.UP, event.getPos(), false);
                            BlockState blockState = blockItem.m_40614_().m_5573_(new BlockPlaceContext((Level)level, event.getPlayer(), event.getContext().m_43724_(), usedSeedStack, hitResult));
                            if (blockState != null) {
                                level.m_7731_(event.getPos().m_7494_(), blockItem.m_40614_().m_49966_(), 3);
                                if (!event.getPlayer().m_7500_()) {
                                    usedSeedStack.m_41774_(1);
                                }
                            }
                        }
                    }));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSystemMessage(ClientChatReceivedEvent.System event) {
        if (((Boolean)Config.COMMON.NO_STARTUP_MESSAGES_ENABLED.get()).booleanValue()) {
            ((List)Config.COMMON.NO_STARTUP_MESSAGES_MESSAGE_STRINGS.get()).forEach(s -> {
                if (event.getMessage().getString().contains((CharSequence)s)) {
                    Utilitarian.LOGGER.debug("Blocked message: \"" + event.getMessage().getString() + "\"");
                    event.setCanceled(true);
                }
            });
        }
    }
}

