/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.teams;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import shetiphian.core.internal.network.NetworkHandler;
import shetiphian.core.internal.teams.PacketTeamSync;
import shetiphian.core.internal.teams.TeamHelper;

public class PlayerTeam {
    private final String id;
    private Component displayName;
    @Nullable
    private UUID leader;
    private final Set<UUID> managers = new HashSet<UUID>();
    private final Set<UUID> members = new HashSet<UUID>();

    public static PlayerTeam create(String id, Player leader, Component displayName) {
        UUID uuid = leader != null ? leader.m_20148_() : null;
        PlayerTeam team = new PlayerTeam(id, uuid, displayName);
        TeamHelper.SAVEDATA.TEAMS.put(id, team);
        if (leader != null) {
            TeamHelper.PLAYER_TEAM.put(uuid, team);
            team.syncChanges(leader);
        }
        TeamHelper.markDirty();
        TeamHelper.syncDisplayName(team.id, team.displayName.getString());
        return team;
    }

    public String getId() {
        return this.id;
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public List<UUID> getMembers() {
        return ImmutableList.copyOf(this.members);
    }

    public boolean isManager(UUID player) {
        return this.managers.contains(player);
    }

    public List<UUID> getManagers() {
        return ImmutableList.copyOf(this.managers);
    }

    private PlayerTeam(String id, UUID leader, Component displayName) {
        this.id = id;
        Object object = this.displayName = displayName != null ? displayName : Component.m_237113_((String)id);
        if (leader != null) {
            this.leader = leader;
            this.managers.add(leader);
            this.members.add(leader);
        }
    }

    @Nullable
    UUID getLeader() {
        return this.leader;
    }

    boolean changeDisplayName(Component displayName) {
        Object object = displayName = displayName != null ? displayName : Component.m_237113_((String)this.id);
        if (!this.displayName.equals(displayName)) {
            this.displayName = displayName;
            TeamHelper.markDirty();
            TeamHelper.syncDisplayName(this.id, this.displayName.getString());
            return true;
        }
        return false;
    }

    void add(Player player) {
        UUID uuid = player.m_20148_();
        this.members.add(uuid);
        TeamHelper.PLAYER_TEAM.put(uuid, this);
        TeamHelper.markDirty();
        this.syncChanges(player);
    }

    void leave(Player player) {
        UUID uuid = player.m_20148_();
        if (!uuid.equals(this.leader)) {
            this.managers.remove(uuid);
            this.members.remove(uuid);
            TeamHelper.PLAYER_TEAM.remove(uuid);
            TeamHelper.markDirty();
        }
        this.syncChanges(player);
    }

    void kick(Player player) {
        UUID uuid = player.m_20148_();
        if (uuid.equals(this.leader)) {
            this.leader = null;
        }
        this.managers.remove(uuid);
        this.members.remove(uuid);
        TeamHelper.PLAYER_TEAM.remove(uuid);
        TeamHelper.markDirty();
        this.syncChanges(player);
    }

    boolean promote(Player player) {
        UUID uuid = player.m_20148_();
        if (!this.managers.contains(uuid)) {
            this.managers.add(uuid);
            this.members.add(uuid);
            TeamHelper.markDirty();
            this.syncChanges(player);
            return true;
        }
        return false;
    }

    boolean demote(Player player) {
        UUID uuid = player.m_20148_();
        if (!uuid.equals(this.leader) && this.managers.contains(uuid)) {
            this.managers.remove(uuid);
            TeamHelper.markDirty();
            this.syncChanges(player);
            return true;
        }
        return false;
    }

    boolean transfer(Player player) {
        UUID uuid = player.m_20148_();
        if (!uuid.equals(this.leader)) {
            this.leader = uuid;
            this.managers.add(uuid);
            this.members.add(uuid);
            TeamHelper.PLAYER_TEAM.put(uuid, this);
            TeamHelper.markDirty();
            this.syncChanges(player);
            return true;
        }
        return false;
    }

    private void syncChanges(Player player) {
        if (player instanceof ServerPlayer) {
            NetworkHandler.sendToPlayer(new PacketTeamSync(this, player), (ServerPlayer)player);
        }
    }

    byte getPlayerStatus(Player player) {
        UUID uuid = player.m_20148_();
        return (byte)(this.members.contains(uuid) ? (this.leader == uuid ? 3 : (this.managers.contains(uuid) ? 2 : 1)) : 0);
    }

    @OnlyIn(value=Dist.CLIENT)
    void setPlayerStatus(byte status, UUID uuid) {
        if (status > 0) {
            switch (status) {
                case 3: {
                    this.leader = uuid;
                }
                case 2: {
                    this.managers.add(uuid);
                }
                case 1: {
                    this.members.add(uuid);
                }
            }
            TeamHelper.PLAYER_TEAM.put(uuid, this);
        }
    }

    static PlayerTeam load(String teamId, CompoundTag nbt) {
        UUID leader = null;
        try {
            leader = nbt.m_128425_("leader", 11) ? nbt.m_128342_("leader") : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        MutableComponent displayName = null;
        try {
            displayName = nbt.m_128425_("display_name", 8) ? Component.Serializer.m_130701_((String)nbt.m_128461_("display_name")) : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        PlayerTeam team = new PlayerTeam(teamId, leader, (Component)displayName);
        if (nbt.m_128425_("members", 9)) {
            nbt.m_128437_("members", 11).forEach(player -> {
                try {
                    team.members.add(NbtUtils.m_129233_((Tag)player));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (nbt.m_128425_("managers", 9)) {
            nbt.m_128437_("managers", 11).forEach(player -> {
                try {
                    team.managers.add(NbtUtils.m_129233_((Tag)player));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        return team;
    }

    CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_("display_name", Component.Serializer.m_130703_((Component)this.displayName));
        if (this.leader != null) {
            nbt.m_128362_("leader", this.leader);
        }
        ListTag memberNBT = new ListTag();
        this.members.forEach(player -> {
            try {
                memberNBT.add((Object)NbtUtils.m_129226_((UUID)player));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        nbt.m_128365_("members", (Tag)memberNBT);
        ListTag adminNBT = new ListTag();
        this.managers.forEach(player -> {
            try {
                adminNBT.add((Object)NbtUtils.m_129226_((UUID)player));
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        nbt.m_128365_("managers", (Tag)adminNBT);
        return nbt;
    }
}

