/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.util;

import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.blockentity.AEBaseBlockEntity;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.IForgeRegistry;

public class FCUtil {
    public static void replaceTile(Level world, BlockPos pos, BlockEntity oldTile, BlockEntity newTile, BlockState newBlock) {
        CompoundTag contents = oldTile.serializeNBT();
        world.m_46747_(pos);
        world.m_7471_(pos, false);
        world.m_7731_(pos, newBlock, 3);
        world.m_151523_(newTile);
        newTile.deserializeNBT(contents);
        if (newTile instanceof AEBaseBlockEntity) {
            AEBaseBlockEntity aeTile = (AEBaseBlockEntity)newTile;
            aeTile.markForUpdate();
        } else {
            newTile.m_6596_();
        }
    }

    public static Component getItemDisplayName(ItemLike item) {
        ItemStack itemStack = new ItemStack(item);
        return itemStack.m_41786_();
    }

    public static boolean checkInvalidRL(String rl, IForgeRegistry<?> registry) {
        return FCUtil.checkInvalidRL(new ResourceLocation(rl), registry);
    }

    public static boolean checkInvalidRL(ResourceLocation rl, IForgeRegistry<?> registry) {
        return registry.containsKey(rl);
    }

    public static String[] trimSplit(String str) {
        String[] sp = str.split(",");
        for (int i = 0; i < sp.length; ++i) {
            sp[i] = sp[i].trim();
        }
        return sp;
    }

    public static int speedCardMap(int card) {
        return FCUtil.speedCardMap(card, 1);
    }

    public static int speedCardMap(int card, int multi) {
        return multi * (switch (card) {
            case 1 -> 3;
            case 2 -> 5;
            case 3 -> 10;
            case 4 -> 50;
            default -> 2;
        });
    }

    public static boolean ejectInv(Level world, BlockPos pos, InternalInventory inv, Predicate<? super BlockEntity> shouldIgnore) {
        for (Direction dir : Direction.values()) {
            ItemTransfer target;
            BlockEntity te = world.m_7702_(pos.m_121945_(dir));
            if (te == null || shouldIgnore.test((BlockEntity)te) || (target = InternalInventory.wrapExternal((Level)world, (BlockPos)pos.m_121945_(dir), (Direction)dir.m_122424_())) == null) continue;
            int startItems = inv.getStackInSlot(0).m_41613_();
            inv.insertItem(0, target.addItems(inv.extractItem(0, 64, false)), false);
            int endItems = inv.getStackInSlot(0).m_41613_();
            if (startItems == endItems) continue;
            return true;
        }
        return false;
    }
}

