/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.prism;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.DirectionAxis;

public class FramedPrismBlock
extends FramedBlock {
    public FramedPrismBlock(BlockType type) {
        super(type);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PropertyHolder.FACING_AXIS, BlockStateProperties.f_61362_, FramedProperties.SOLID, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return FramedPrismBlock.getStateForPlacement(context, this);
    }

    public static BlockState getStateForPlacement(BlockPlaceContext ctx, Block block) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(block, ctx).withCustom((state, modCtx) -> {
            Direction face = modCtx.m_43719_();
            Direction.Axis axis = modCtx.m_8125_().m_122434_();
            if (!Utils.isY(face)) {
                Vec3 subHit = Utils.fraction(modCtx.m_43720_());
                double xz = (Utils.isX(face) ? subHit.m_7094_() : subHit.m_7096_()) - 0.5;
                double y = subHit.m_7098_() - 0.5;
                axis = Math.max(Math.abs(xz), Math.abs(y)) == Math.abs(xz) ? face.m_122427_().m_122434_() : Direction.Axis.Y;
            }
            return (BlockState)state.m_61124_(PropertyHolder.FACING_AXIS, (Comparable)((Object)DirectionAxis.of(face, axis)));
        })).withYSlope(Utils.isY(ctx.m_43719_()))).tryWithWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        if (player.m_21205_().m_204117_(Utils.WRENCH)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE) == false)));
            return true;
        }
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        DirectionAxis dirAxis = (DirectionAxis)((Object)state.m_61143_(PropertyHolder.FACING_AXIS));
        return (BlockState)state.m_61124_(PropertyHolder.FACING_AXIS, (Comparable)((Object)dirAxis.rotate(rot)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        DirectionAxis dirAxis = (DirectionAxis)((Object)state.m_61143_(PropertyHolder.FACING_AXIS));
        return (BlockState)state.m_61124_(PropertyHolder.FACING_AXIS, (Comparable)((Object)dirAxis.mirror(mirror)));
    }
}

