/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lost_aether.capability.player;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.event.hooks.DimensionClientHooks;
import com.legacy.lost_aether.capability.player.ILCPlayer;
import com.legacy.lost_aether.event.LCEvents;
import com.legacy.lost_aether.network.PacketHandler;
import com.legacy.lost_aether.network.SyncPlayerPacket;
import com.legacy.lost_aether.registry.LCItems;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LCPlayer
implements ILCPlayer {
    private static final Supplier<Vector3f> KING_FOG_TINT = () -> new Vector3f(99.0f, 123.0f, 152.0f).div(255.0f);
    private Player player;
    private float fogScale;
    private float fogScaleO;
    private boolean fogActive;
    private boolean kingFight;
    private int fogTime;
    private int capeRiseTime;
    private static final String FOG_TIME_KEY = "WhaleFogTime";
    private static final String PHOENIX_RISE_KEY = "PhoenixRiseTime";

    public LCPlayer() {
    }

    public LCPlayer(Player player) {
        this.player = player;
    }

    @Override
    public Capability<ILCPlayer> getDefaultInstance() {
        return ILCPlayer.INSTANCE;
    }

    @Nullable
    public static ILCPlayer get(Player player) {
        return LCPlayer.getIfPresent(player, lcPlayer -> lcPlayer, () -> null);
    }

    public static <E extends Player> void ifPresent(E player, Consumer<ILCPlayer> action) {
        Optional optional;
        if (player != null && !(player instanceof FakePlayer) && (optional = player.getCapability(ILCPlayer.INSTANCE).resolve()).isPresent()) {
            action.accept((ILCPlayer)optional.get());
        }
    }

    public static <E extends Player, R> R getIfPresent(E player, Function<ILCPlayer, R> action, Supplier<R> elseSupplier) {
        Optional optional;
        if (player != null && !(player instanceof FakePlayer) && (optional = player.getCapability(ILCPlayer.INSTANCE).resolve()).isPresent()) {
            return action.apply((ILCPlayer)optional.get());
        }
        return elseSupplier.get();
    }

    @Override
    public void serverTick() {
        ServerPlayer player;
        Player player2;
        if (this.player != null && (player2 = this.player) instanceof ServerPlayer && !(player = (ServerPlayer)player2).m_9236_().m_5776_()) {
            if (this.fogTime > 0) {
                this.setFogTime(this.fogTime - 1);
            }
            if (this.capeRiseTime > 0) {
                if (this.capeRiseTime == 1) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, 160, 0, true, true, true));
                }
                this.setRiseTime(this.capeRiseTime - 1);
                Level level = player.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel sl = (ServerLevel)level;
                    float width = player.m_20205_() / 2.0f;
                    float height = player.m_20206_() * 0.3f;
                    sl.m_8767_((ParticleOptions)ParticleTypes.f_175834_, player.m_20185_(), player.m_20186_() + (double)height, player.m_20189_(), 3, (double)width, (double)height, (double)width, (double)0.1f);
                    sl.m_8767_((ParticleOptions)ParticleTypes.f_123748_, player.m_20185_(), player.m_20186_() + (double)height, player.m_20189_(), 1, (double)width, (double)height, (double)width, (double)0.1f);
                }
            }
            if (!(player.m_7500_() || player.m_6144_() || player.m_21255_())) {
                int min = player.m_9236_().m_141937_();
                if (player.m_20184_().m_7098_() < -1.6 && (this.player.m_9236_().m_46472_().equals((Object)Level.f_46430_) || this.player.m_9236_().m_204166_(player.m_20183_()).m_203656_(AetherTags.Biomes.FALL_TO_OVERWORLD)) && player.m_20186_() > (double)min && player.m_20186_() <= (double)(min + 13)) {
                    LCEvents.getAccessory((Player)player, LCItems.phoenix_cape).ifPresent(slot -> {
                        if (this.getRiseTime() <= 0 && !player.m_21023_(MobEffects.f_19591_) && !player.m_21023_(MobEffects.f_19620_)) {
                            player.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 100, 10, true, true, true));
                            player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)AetherSoundEvents.ITEM_HAMMER_OF_KINGBDOGZ_SHOOT.get(), player.m_5720_(), 1.0f, 1.0f);
                            Vec3 vec = player.m_20184_();
                            player.m_20334_(vec.f_82479_, 1.0, vec.f_82481_);
                            player.f_19864_ = true;
                            Level patt4828$temp = player.m_9236_();
                            if (patt4828$temp instanceof ServerLevel) {
                                ServerLevel sl = (ServerLevel)patt4828$temp;
                                float width = player.m_20205_() / 2.0f;
                                float height = player.m_20206_() * 0.3f;
                                sl.m_8767_((ParticleOptions)ParticleTypes.f_123744_, player.m_20185_(), player.m_20186_() + (double)height, player.m_20189_(), 40, (double)width, (double)height, (double)width, (double)0.1f);
                            }
                            slot.stack().m_41622_(1, (LivingEntity)player, p -> {});
                            this.setRiseTime(100);
                        }
                    });
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        LocalPlayer player;
        Player player2;
        if (this.player != null && (player2 = this.player) instanceof LocalPlayer && (player = (LocalPlayer)player2).m_9236_().m_5776_()) {
            boolean showFog;
            boolean bl = showFog = this.getFogTime() > 0;
            if (!showFog && this.fogScale == this.fogScaleO && this.fogScale <= 0.0f) {
                this.fogActive = false;
            }
            this.fogScaleO = this.fogScale;
            if (showFog) {
                this.fogActive = true;
                this.fogScale = Mth.m_14121_((float)this.fogScale, (float)1.0f, (float)0.02f);
            } else {
                this.fogScale = Mth.m_14121_((float)this.fogScale, (float)0.0f, (float)0.005f);
            }
            if (this.capeRiseTime > 0 && !Minecraft.m_91087_().m_91104_()) {
                for (int i = 0; i < 4; ++i) {
                    player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.player.m_20185_() + this.player.m_217043_().m_188583_() * (double)0.4f, this.player.m_20186_(), this.player.m_20189_() + this.player.m_217043_().m_188583_() * (double)0.4f, this.player.m_217043_().m_188583_() * (double)0.2f, (double)-0.3f, this.player.m_217043_().m_188583_() * (double)0.2f);
                }
            }
        }
    }

    @Override
    public void renderFog(ViewportEvent.RenderFog event) {
        boolean terrain;
        if (!this.fogActive) {
            return;
        }
        event.setCanceled(true);
        boolean bl = terrain = event.getMode() == FogRenderer.FogMode.FOG_TERRAIN;
        if (terrain) {
            Float renderNearFog = DimensionClientHooks.renderNearFog((Camera)event.getCamera(), (FogRenderer.FogMode)event.getMode(), (float)event.getFarPlaneDistance());
            if (renderNearFog != null) {
                event.setNearPlaneDistance(renderNearFog.floatValue());
            }
            float scale = Mth.m_14179_((float)((float)event.getPartialTick()), (float)this.fogScaleO, (float)this.fogScale);
            event.scaleFarPlaneDistance(1.0f - (terrain ? 0.95f : 0.1f) * scale);
            event.scaleNearPlaneDistance(1.0f - (terrain ? 1.05f : 0.05f) * scale);
        }
    }

    @Override
    public void modifyFogColor(ViewportEvent.ComputeFogColor event) {
        float scale = 1.0f * Mth.m_14179_((float)((float)event.getPartialTick()), (float)this.fogScaleO, (float)this.fogScale);
        Vector3f base = new Vector3f(event.getRed(), event.getGreen(), event.getBlue());
        Vector3f biome = KING_FOG_TINT.get();
        Vector3f last = base.mul(1.0f - scale).add((Vector3fc)biome.mul(scale));
        event.setRed(last.x);
        event.setGreen(last.y);
        event.setBlue(last.z);
    }

    @Override
    public Vec3 modifyAetherSkyColor(Vec3 pPos, float pPartialTick, Vec3 value) {
        if (this.fogActive) {
            float scale = 1.0f * Mth.m_14179_((float)pPartialTick, (float)this.fogScaleO, (float)this.fogScale);
            Vector3f base = new Vector3f((float)value.m_7096_(), (float)value.m_7098_(), (float)value.m_7094_());
            Vector3f biome = KING_FOG_TINT.get();
            Vector3f last = base.mul(1.0f - scale).add((Vector3fc)biome.mul(scale));
            return new Vec3((double)last.x, (double)last.y, (double)last.z);
        }
        return null;
    }

    public static int rgbToDecimal(int red, int green, int blue) {
        return (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    @Override
    public CompoundTag writeAdditional(CompoundTag nbt) {
        nbt.m_128405_(FOG_TIME_KEY, this.getFogTime());
        nbt.m_128405_(PHOENIX_RISE_KEY, this.getRiseTime());
        nbt.m_128379_("InKingFight", this.inKingFight());
        return nbt;
    }

    @Override
    public void read(CompoundTag nbt) {
        this.setFogTime(nbt.m_128451_(FOG_TIME_KEY));
        this.setRiseTime(nbt.m_128451_(PHOENIX_RISE_KEY));
        this.setKingFight(nbt.m_128471_("InKingFight"));
    }

    @Override
    public void syncDataToClient() {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer s = (ServerPlayer)player;
            PacketHandler.sendToClient(new SyncPlayerPacket(this.writeAdditional(new CompoundTag())), s);
        }
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public int getFogTime() {
        return this.fogTime;
    }

    @Override
    public void setFogTime(int value) {
        this.fogTime = value;
        this.syncDataToClient();
    }

    @Override
    public int getRiseTime() {
        return this.capeRiseTime;
    }

    @Override
    public void setRiseTime(int value) {
        this.capeRiseTime = value;
        this.syncDataToClient();
    }

    @Override
    public boolean inKingFight() {
        return this.kingFight;
    }

    @Override
    public void setKingFight(boolean inFight) {
        this.kingFight = inFight;
    }
}

