/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.backpack;

import com.google.common.collect.ImmutableList;
import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.compat.curios.UtilCurios;
import de.melanx.utilitix.content.backpack.ItemBackpack;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.moddingx.libx.impl.menu.GenericContainerSlotValidationWrapper;
import org.moddingx.libx.inventory.BaseItemStackHandler;
import org.moddingx.libx.menu.MenuBase;

public class BackpackMenu
extends MenuBase {
    private static final BiPredicate<Integer, ItemStack> BACKPACK_SLOT_VALIDATOR = (slot, stack) -> !(stack.m_41720_() instanceof ItemBackpack);
    private static final int MAX_ROWS = 8;
    private final ItemStack backpack;
    public final int width;
    public final int height;
    public final int invX;
    public final int invY;
    public final List<Pair<Integer, Integer>> slotList;
    public static final MenuType<BackpackMenu> TYPE = IForgeMenuType.create((id, playerInv, buffer) -> {
        int size = buffer.m_130242_();
        GenericContainerSlotValidationWrapper handler = new GenericContainerSlotValidationWrapper((IItemHandlerModifiable)new ItemStackHandler(size), BACKPACK_SLOT_VALIDATOR, null);
        return new BackpackMenu(id, (IItemHandlerModifiable)handler, playerInv, buffer.m_130267_());
    });

    protected BackpackMenu(int id, IItemHandlerModifiable handler, Inventory inventory, ItemStack backpack) {
        super(TYPE, id, inventory);
        Triple<Pair<Integer, Integer>, Pair<Integer, Integer>, List<Pair<Integer, Integer>>> layout = BackpackMenu.layoutSlots(handler.getSlots());
        this.backpack = backpack;
        this.width = (Integer)((Pair)layout.getLeft()).getLeft();
        this.height = (Integer)((Pair)layout.getLeft()).getRight();
        this.invX = (Integer)((Pair)layout.getMiddle()).getLeft();
        this.invY = (Integer)((Pair)layout.getMiddle()).getRight();
        this.slotList = (List)layout.getRight();
        for (int i = 0; i < this.slotList.size(); ++i) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, i, ((Integer)this.slotList.get(i).getLeft()).intValue(), ((Integer)this.slotList.get(i).getRight()).intValue()));
        }
        this.layoutPlayerInventorySlots((Integer)((Pair)layout.getMiddle()).getLeft(), (Integer)((Pair)layout.getMiddle()).getRight());
    }

    public boolean m_6875_(@Nonnull Player player) {
        return player.m_21120_(player.m_7655_()).m_41720_() instanceof ItemBackpack || UtilCurios.getBackpack(player).isPresent();
    }

    public static void open(ServerPlayer player, final BaseItemStackHandler inventory, final ItemStack backpack) {
        MenuProvider provider = new MenuProvider(){

            @Nonnull
            public Component m_5446_() {
                return Component.m_237115_((String)("screen." + UtilitiX.getInstance().modid + ".backpack"));
            }

            public AbstractContainerMenu m_7208_(int containerId, @Nonnull Inventory inv, @Nonnull Player player) {
                return new BackpackMenu(containerId, (IItemHandlerModifiable)new GenericContainerSlotValidationWrapper((IItemHandlerModifiable)inventory, BACKPACK_SLOT_VALIDATOR, null), inv, backpack);
            }
        };
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)provider, buffer -> {
            buffer.m_130130_(inventory.getSlots());
            buffer.writeItemStack(backpack, false);
        });
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            itemstack = stack.m_41777_();
            int inventorySize = this.slotList.size();
            int playerInventoryEnd = inventorySize + 27;
            int playerHotBarEnd = playerInventoryEnd + 9;
            if (index >= inventorySize) {
                if (!this.m_38903_(stack, 0, inventorySize, false)) {
                    return ItemStack.f_41583_;
                }
                if (index < playerInventoryEnd ? !this.m_38903_(stack, playerInventoryEnd, playerHotBarEnd, false) : index < playerHotBarEnd && !this.m_38903_(stack, inventorySize, playerInventoryEnd, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(stack, inventorySize, playerHotBarEnd, false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (stack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, stack);
        }
        return itemstack;
    }

    public void m_150399_(int slotId, int button, @Nonnull ClickType clickType, @Nonnull Player player) {
        if (this.validSlotId(slotId) && this.isOpenedBackpack(((Slot)this.f_38839_.get(slotId)).m_7993_())) {
            return;
        }
        super.m_150399_(slotId, button, clickType, player);
    }

    private boolean isOpenedBackpack(ItemStack stack) {
        return stack.m_41720_() instanceof ItemBackpack && stack == this.backpack;
    }

    private boolean validSlotId(int slotId) {
        return slotId != -999 && slotId != -1;
    }

    private static Triple<Pair<Integer, Integer>, Pair<Integer, Integer>, List<Pair<Integer, Integer>>> layoutSlots(int size) {
        int[] preferredWidths;
        if (size < 9) {
            return BackpackMenu.layoutRectangle(size, 1, size);
        }
        for (int width : preferredWidths = new int[]{9, 11, 12, 8, 13, 14}) {
            if (size % width != 0 || size > width * 8) continue;
            return BackpackMenu.layoutRectangle(width, size / width, size);
        }
        for (int width : preferredWidths) {
            if (size > width * 8) continue;
            return BackpackMenu.layoutRectangle(width, (size + width - 1) / width, size);
        }
        return BackpackMenu.layoutRectangle(14, (size + 13) / 14, size);
    }

    private static Triple<Pair<Integer, Integer>, Pair<Integer, Integer>, List<Pair<Integer, Integer>>> layoutRectangle(int width, int height, int maxSize) {
        int invX = Math.max((width - 9) * 9, 0);
        int paddingX = width < 9 ? (9 - width) * 9 : 0;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                if (y * width + x >= maxSize) continue;
                builder.add((Object)Pair.of((Object)(7 + paddingX + 18 * x + 1), (Object)(17 + 18 * y + 1)));
            }
        }
        int totalWidth = Math.max(2 * (7 + invX) + 162, 2 * (7 + paddingX) + width * 18);
        int totalHeight = 17 + 18 * height + 14 + 83;
        return Triple.of((Object)Pair.of((Object)totalWidth, (Object)totalHeight), (Object)Pair.of((Object)(7 + invX + 1), (Object)(17 + height * 18 + 14 + 1)), (Object)builder.build());
    }
}

