/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.UtilitiXConfig;
import de.melanx.utilitix.content.gildingarmor.GildingArmorRecipe;
import de.melanx.utilitix.content.slime.SlimyCapability;
import de.melanx.utilitix.content.slime.StickyChunk;
import de.melanx.utilitix.network.OpenCurioBackpack;
import de.melanx.utilitix.network.StickyChunkRequest;
import de.melanx.utilitix.registration.ModItems;
import de.melanx.utilitix.registration.ModKeys;
import de.melanx.utilitix.util.MobUtil;
import de.melanx.utilitix.util.XPUtils;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class EventListener {
    private static final MutableComponent GILDED = Component.m_237115_((String)"tooltip.utilitix.gilded").m_130940_(ChatFormatting.GOLD);
    private static final Set<ResourceLocation> AIOTBOTANIA_FLATTEN_ALLOWED = Set.of(new ResourceLocation("aiotbotania", "livingwood_aiot"), new ResourceLocation("aiotbotania", "livingrock_aiot"), new ResourceLocation("aiotbotania", "manasteel_aiot"), new ResourceLocation("aiotbotania", "elementium_aiot"), new ResourceLocation("aiotbotania", "terra_aiot"), new ResourceLocation("aiotbotania", "alfsteel_aiot"));

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Entity entity;
        Player player = event.getEntity();
        if (player.m_6144_() && (entity = event.getTarget()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            InteractionHand hand = event.getHand();
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41720_() == ModItems.mobBell) {
                if (MobUtil.storeEntityData(player, hand, target, UtilitiXConfig.HandBells.mobBellEntities, true)) {
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                }
            } else if (stack.m_41720_() == ModItems.mobYoinker) {
                int health;
                int xp;
                int diff;
                if (!player.m_7500_() && (diff = (xp = XPUtils.getExpPoints(player.f_36078_, player.f_36080_)) - (health = (int)target.m_21223_())) < 0) {
                    player.m_5661_((Component)Component.m_237110_((String)"message.utilitix.mob_yoinker", (Object[])new Object[]{-diff}), true);
                    return;
                }
                if (MobUtil.storeEntityData(player, hand, target, UtilitiXConfig.mobYoinkerEntities, false)) {
                    player.m_6756_((int)(-target.m_21223_()));
                    target.m_142687_(Entity.RemovalReason.DISCARDED);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void entityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        if (event.getTarget() instanceof ArmorStand && event.getTarget().getPersistentData().m_128471_("UtilitiXArmorStand") && event.getItemStack().m_41720_() == Items.f_42484_ && event.getEntity().m_6144_()) {
            ArmorStand entity = (ArmorStand)event.getTarget();
            if (UtilitiXConfig.armorStandPoses.size() >= 2) {
                int newIdx = (entity.getPersistentData().m_128451_("UtilitiXPoseIdx") + 1) % UtilitiXConfig.armorStandPoses.size();
                entity.getPersistentData().m_128405_("UtilitiXPoseIdx", newIdx);
                UtilitiXConfig.armorStandPoses.get(newIdx).apply(entity);
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void loadChunk(ChunkEvent.Load event) {
        if (event.getLevel().m_5776_()) {
            UtilitiX.getNetwork().channel.sendToServer((Object)new StickyChunkRequest(event.getChunk().m_7697_()));
        }
    }

    @SubscribeEvent
    public void neighbourChange(BlockEvent.NeighborNotifyEvent event) {
        Direction[] directionArray;
        if (!event.getLevel().m_5776_() && (directionArray = event.getLevel()) instanceof Level) {
            Level level = (Level)directionArray;
            for (Direction dir : Direction.values()) {
                BlockPos thePos = event.getPos().m_121945_(dir);
                BlockState state = level.m_8055_(thePos);
                if (state.m_60734_() == Blocks.f_50110_ && (state.m_61143_((Property)BlockStateProperties.f_61372_) == dir || state.m_61143_((Property)BlockStateProperties.f_61372_) == dir.m_122424_())) {
                    return;
                }
                if (state.m_60734_() != Blocks.f_50040_ || !((Boolean)state.m_61143_((Property)BlockStateProperties.f_61449_)).booleanValue() || state.m_61143_((Property)BlockStateProperties.f_61372_) != dir && state.m_61143_((Property)BlockStateProperties.f_61372_) != dir.m_122424_()) continue;
                return;
            }
            LevelChunk chunk = level.m_46745_(event.getPos());
            StickyChunk glue = (StickyChunk)chunk.getCapability(SlimyCapability.STICKY_CHUNK).orElse(null);
            if (glue != null) {
                int x = event.getPos().m_123341_() & 0xF;
                int y = event.getPos().m_123342_();
                int z = event.getPos().m_123343_() & 0xF;
                for (Direction dir : Direction.values()) {
                    if (!glue.get(x, y, z, dir) || SlimyCapability.canGlue(level, event.getPos(), dir)) continue;
                    glue.set(x, y, z, dir, false);
                    chunk.m_8092_(true);
                    BlockPos targetPos = event.getPos().m_121945_(dir);
                    ItemEntity ie = new ItemEntity(level, (double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5, new ItemStack((ItemLike)ModItems.glueBall));
                    ie.m_32010_(20);
                    level.m_7967_((Entity)ie);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemDespawn(ItemExpireEvent event) {
        ItemEntity entity = event.getEntity();
        Level level = entity.m_20193_();
        if (!level.f_46443_) {
            BlockItem item;
            BlockPos pos = entity.m_20183_();
            ItemStack stack = entity.m_32055_();
            Item item2 = stack.m_41720_();
            if (item2 instanceof BlockItem && ((item = (BlockItem)item2).m_40614_() instanceof CropBlock || item.m_40614_() instanceof SaplingBlock)) {
                if (!UtilitiXConfig.plantsOnDespawn.test(ForgeRegistries.ITEMS.getKey((Object)item))) {
                    return;
                }
                try {
                    DirectionalPlaceContext context = new DirectionalPlaceContext(level, pos, Direction.DOWN, stack, Direction.UP);
                    if (item.m_40576_((BlockPlaceContext)context) == InteractionResult.SUCCESS) {
                        level.m_46597_(pos, item.m_40614_().m_49966_());
                        return;
                    }
                    context = new DirectionalPlaceContext(level, pos.m_7494_(), Direction.DOWN, stack, Direction.UP);
                    if (item.m_40576_((BlockPlaceContext)context) == InteractionResult.SUCCESS) {
                        level.m_46597_(pos.m_7494_(), item.m_40614_().m_49966_());
                    }
                }
                catch (NullPointerException e) {
                    UtilitiX.getInstance().logger.warn("Tried to place {} but was prevented.", (Object)item);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (GildingArmorRecipe.isGilded(stack)) {
            event.getToolTip().add(Math.min(event.getToolTip().size() - 1, 1), GILDED);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onExplosionStart(ExplosionEvent.Start event) {
        if (event.isCanceled()) {
            return;
        }
        Explosion explosion = event.getExplosion();
        Entity entity = explosion.getExploder();
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            float health = creeper.m_21223_();
            float maxHealth = creeper.m_21233_();
            explosion.f_46017_ *= health / maxHealth;
        }
    }

    @SubscribeEvent
    public void onBlockToolInteraction(BlockEvent.BlockToolModificationEvent event) {
        if (!(event.getToolAction() != ToolActions.SHOVEL_FLATTEN || event.getPlayer() == null || !event.getPlayer().m_6047_() || ModList.get().isLoaded("aiotbotania") && AIOTBOTANIA_FLATTEN_ALLOWED.contains(ForgeRegistries.ITEMS.getKey((Object)event.getHeldItemStack().m_41720_())))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void addLayers(LootTableLoadEvent event) {
        LootTable table = event.getTable();
        if (table.getLootTableId().equals((Object)BuiltInLootTables.f_78742_)) {
            table.addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)ModItems.ancientCompass)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41852_).m_79707_(31)).m_79082_());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onLevelTick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            while (((KeyMapping)ModKeys.OPEN_BACKPACK.get()).m_90859_() && Minecraft.m_91087_().f_91080_ == null) {
                UtilitiX.getNetwork().channel.sendToServer((Object)new OpenCurioBackpack());
            }
        }
    }
}

