/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.regassets.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import mcjty.lostcities.worldgen.lost.regassets.data.DataTools;
import net.minecraft.resources.ResourceLocation;

public class ResourceLocationMatcher
implements Predicate<ResourceLocation> {
    private final Set<ResourceLocation> ifAny = new HashSet<ResourceLocation>();
    private final Set<ResourceLocation> excluding;
    public static final Codec<ResourceLocationMatcher> CODEC = RecordCodecBuilder.create(codec -> codec.group((App)Codec.STRING.listOf().optionalFieldOf("if_any").forGetter(ResourceLocationMatcher::getIfAny), (App)Codec.STRING.listOf().optionalFieldOf("excluding").forGetter(ResourceLocationMatcher::getExcluding)).apply((Applicative)codec, ResourceLocationMatcher::new));
    public static final ResourceLocationMatcher ANY = new ResourceLocationMatcher(Optional.empty(), Optional.empty()){

        @Override
        public boolean test(ResourceLocation str) {
            return true;
        }
    };

    public ResourceLocationMatcher(Optional<List<String>> ifAny, Optional<List<String>> excluding) {
        ifAny.ifPresent(strings -> strings.forEach(s -> this.ifAny.add(DataTools.fromName(s))));
        this.excluding = new HashSet<ResourceLocation>();
        excluding.ifPresent(strings -> strings.forEach(s -> this.excluding.add(DataTools.fromName(s))));
    }

    public boolean isAny() {
        return this.ifAny.isEmpty() && this.excluding.isEmpty();
    }

    private Optional<List<String>> getIfAny() {
        if (this.ifAny == null || this.ifAny.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.ifAny.stream().map(ResourceLocation::toString).toList());
    }

    private Optional<List<String>> getExcluding() {
        if (this.excluding == null || this.excluding.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.excluding.stream().map(ResourceLocation::toString).toList());
    }

    @Override
    public boolean test(ResourceLocation rl) {
        if (rl == null) {
            return false;
        }
        if (!this.ifAny.isEmpty() && !this.ifAny.contains(rl)) {
            return false;
        }
        return this.excluding.isEmpty() || !this.excluding.contains(rl);
    }
}

