/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.regassets.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mcjty.lostcities.worldgen.lost.regassets.data.DataTools;

public class ParkSettings {
    private final Float parkChance;
    private final Boolean avoidFoliage;
    private final Boolean parkBorder;
    private final Boolean parkElevation;
    private final Integer parkStreetThreshold;
    private final Character parkElevationBlock;
    private final Character grassBlock;
    public static final Codec<ParkSettings> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("parkchance").forGetter(l -> Optional.ofNullable(l.parkChance)), (App)Codec.BOOL.optionalFieldOf("avoidfoliage").forGetter(l -> Optional.ofNullable(l.avoidFoliage)), (App)Codec.BOOL.optionalFieldOf("parkborder").forGetter(l -> Optional.ofNullable(l.parkBorder)), (App)Codec.BOOL.optionalFieldOf("parkelevation").forGetter(l -> Optional.ofNullable(l.parkElevation)), (App)Codec.INT.optionalFieldOf("parkstreetthreshold").forGetter(l -> Optional.ofNullable(l.parkStreetThreshold)), (App)Codec.STRING.optionalFieldOf("elevation").forGetter(l -> DataTools.toNullable(l.parkElevationBlock)), (App)Codec.STRING.optionalFieldOf("grass").forGetter(l -> DataTools.toNullable(l.grassBlock))).apply((Applicative)instance, ParkSettings::new));

    public Float getParkChance() {
        return this.parkChance;
    }

    public Boolean getAvoidFoliage() {
        return this.avoidFoliage;
    }

    public Boolean getParkBorder() {
        return this.parkBorder;
    }

    public Boolean getParkElevation() {
        return this.parkElevation;
    }

    public Integer getParkStreetThreshold() {
        return this.parkStreetThreshold;
    }

    public Character getParkElevationBlock() {
        return this.parkElevationBlock;
    }

    public Character getGrassBlock() {
        return this.grassBlock;
    }

    public ParkSettings(Optional<Float> parkChance, Optional<Boolean> avoidFoliage, Optional<Boolean> parkBorder, Optional<Boolean> parkElevation, Optional<Integer> parkStreetThreshold, Optional<String> parkElevationBlock, Optional<String> grassBlock) {
        this.parkChance = parkChance.orElse(null);
        this.avoidFoliage = avoidFoliage.orElse(null);
        this.parkBorder = parkBorder.orElse(null);
        this.parkElevation = parkElevation.orElse(null);
        this.parkStreetThreshold = parkStreetThreshold.orElse(null);
        this.parkElevationBlock = DataTools.getNullableChar(parkElevationBlock);
        this.grassBlock = DataTools.getNullableChar(grassBlock);
    }
}

