/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost.cityassets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import mcjty.lostcities.api.ILostCityCityStyle;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.Tools;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.regassets.CityStyleRE;
import mcjty.lostcities.worldgen.lost.regassets.data.DataTools;
import mcjty.lostcities.worldgen.lost.regassets.data.ObjectSelector;
import mcjty.lostcities.worldgen.lost.regassets.data.StreetParts;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.CommonLevelAccessor;

public class CityStyle
implements ILostCityCityStyle {
    private final ResourceLocation name;
    private final Set<String> stuffTags = new HashSet<String>();
    private final List<ObjectSelector> buildingSelector = new ArrayList<ObjectSelector>();
    private final List<ObjectSelector> bridgeSelector = new ArrayList<ObjectSelector>();
    private final List<ObjectSelector> parkSelector = new ArrayList<ObjectSelector>();
    private final List<ObjectSelector> fountainSelector = new ArrayList<ObjectSelector>();
    private final List<ObjectSelector> stairSelector = new ArrayList<ObjectSelector>();
    private final List<ObjectSelector> frontSelector = new ArrayList<ObjectSelector>();
    private final List<ObjectSelector> railDungeonSelector = new ArrayList<ObjectSelector>();
    private final List<ObjectSelector> multiBuildingSelector = new ArrayList<ObjectSelector>();
    private StreetParts streetParts = StreetParts.DEFAULT;
    private Integer minFloorCount;
    private Integer minCellarCount;
    private Integer maxFloorCount;
    private Integer maxCellarCount;
    private Float buildingChance;
    private Float fountainChance;
    private Float frontChance;
    private Integer streetWidth;
    private Character streetBlock;
    private Character streetBaseBlock;
    private Character streetVariantBlock;
    private Character borderBlock;
    private Character wallBlock;
    private Float parkChance;
    private Boolean avoidFoliage;
    private Boolean parkBorder;
    private Boolean parkElevation;
    private Integer parkStreetThreshold;
    private Character parkElevationBlock;
    private Character grassBlock;
    private Float corridorChance;
    private Character corridorRoofBlock;
    private Character corridorGlassBlock;
    private Character railMainBlock;
    private Character sphereBlock;
    private Character sphereSideBlock;
    private Character sphereGlassBlock;
    private Character ironbarsBlock;
    private Character glowstoneBlock;
    private Character leavesBlock;
    private Character rubbleDirtBlock;
    private Float explosionChance;
    private String style;
    private final String inherit;
    private boolean resolveInherit = false;

    public CityStyle(CityStyleRE object) {
        this.name = object.getRegistryName();
        this.inherit = object.getInherit();
        this.style = object.getStyle();
        this.stuffTags.add("all");
        if (object.getStuffTags() != null) {
            this.stuffTags.addAll(object.getStuffTags());
        }
        this.explosionChance = object.getExplosionChance();
        object.getBuildingSettings().ifPresent(s -> {
            this.buildingChance = s.getBuildingChance();
            this.maxCellarCount = s.getMaxCellarCount();
            this.maxFloorCount = s.getMaxFloorCount();
            this.minCellarCount = s.getMinCellarCount();
            this.minFloorCount = s.getMinFloorCount();
        });
        object.getCorridorSettings().ifPresent(s -> {
            this.corridorChance = s.getCorridorChance();
            this.corridorGlassBlock = s.getCorridorGlassBlock();
            this.corridorRoofBlock = s.getCorridorRoofBlock();
        });
        object.getRailSettings().ifPresent(s -> {
            this.railMainBlock = s.getRailMainBlock();
        });
        object.getParkSettings().ifPresent(s -> {
            this.parkChance = s.getParkChance();
            this.avoidFoliage = s.getAvoidFoliage();
            this.parkBorder = s.getParkBorder();
            this.parkElevation = s.getParkElevation();
            this.parkStreetThreshold = s.getParkStreetThreshold();
            this.grassBlock = s.getGrassBlock();
            this.parkElevationBlock = s.getParkElevationBlock();
        });
        object.getSphereSettings().ifPresent(s -> {
            this.sphereBlock = s.getSphereBlock();
            this.sphereGlassBlock = s.getSphereGlassBlock();
            this.sphereSideBlock = s.getSphereSideBlock();
        });
        object.getStreetSettings().ifPresent(s -> {
            this.fountainChance = s.getFountainChance();
            this.frontChance = s.getFrontChance();
            this.borderBlock = s.getBorderBlock();
            this.streetBaseBlock = s.getStreetBaseBlock();
            this.streetBlock = s.getStreetBlock();
            this.streetVariantBlock = s.getStreetVariantBlock();
            this.wallBlock = s.getWallBlock();
            this.streetWidth = s.getStreetWidth();
            this.streetParts = s.getParts();
        });
        object.getGeneralSettings().ifPresent(s -> {
            this.glowstoneBlock = s.getGlowstoneBlock();
            this.ironbarsBlock = s.getIronbarsBlock();
            this.leavesBlock = s.getLeavesBlock();
            this.rubbleDirtBlock = s.getRubbleDirtBlock();
        });
        object.getSelectors().ifPresent(s -> {
            s.getBridgeSelector().ifPresent(this.bridgeSelector::addAll);
            s.getBuildingSelector().ifPresent(this.buildingSelector::addAll);
            s.getFountainSelector().ifPresent(this.fountainSelector::addAll);
            s.getFrontSelector().ifPresent(this.frontSelector::addAll);
            s.getParkSelector().ifPresent(this.parkSelector::addAll);
            s.getMultiBuildingSelector().ifPresent(this.multiBuildingSelector::addAll);
            s.getRailDungeonSelector().ifPresent(this.railDungeonSelector::addAll);
            s.getStairSelector().ifPresent(this.stairSelector::addAll);
        });
    }

    @Override
    public String getName() {
        return DataTools.toName(this.name);
    }

    @Override
    public ResourceLocation getId() {
        return this.name;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public Float getExplosionChance() {
        return this.explosionChance;
    }

    @Override
    public int getStreetWidth() {
        return this.streetWidth;
    }

    public StreetParts getStreetParts() {
        return this.streetParts;
    }

    @Override
    public Integer getMinFloorCount() {
        return this.minFloorCount;
    }

    @Override
    public Integer getMinCellarCount() {
        return this.minCellarCount;
    }

    @Override
    public Integer getMaxFloorCount() {
        return this.maxFloorCount;
    }

    @Override
    public Integer getMaxCellarCount() {
        return this.maxCellarCount;
    }

    @Override
    public Float getBuildingChance() {
        return this.buildingChance;
    }

    @Override
    public Float getParkChance() {
        return this.parkChance;
    }

    @Override
    public Float getFrontChance() {
        return this.frontChance;
    }

    @Override
    public Float getCorridorChance() {
        return this.corridorChance;
    }

    @Override
    public Boolean getAvoidFoliage() {
        return this.avoidFoliage;
    }

    @Override
    public Boolean getParkBorder() {
        return this.parkBorder;
    }

    @Override
    public Integer getParkStreetThreshold() {
        return this.parkStreetThreshold;
    }

    @Override
    public Boolean getParkElevation() {
        return this.parkElevation;
    }

    @Override
    public Character getGrassBlock() {
        return this.grassBlock;
    }

    @Override
    public Character getIronbarsBlock() {
        return this.ironbarsBlock;
    }

    @Override
    public Character getGlowstoneBlock() {
        return this.glowstoneBlock;
    }

    @Override
    public Character getLeavesBlock() {
        return this.leavesBlock;
    }

    public Character getRubbleDirtBlock() {
        return this.rubbleDirtBlock;
    }

    @Override
    public Float getFountainChance() {
        return this.fountainChance;
    }

    @Override
    public Character getStreetBlock() {
        return this.streetBlock;
    }

    @Override
    public Character getStreetBaseBlock() {
        return this.streetBaseBlock;
    }

    @Override
    public Character getStreetVariantBlock() {
        return this.streetVariantBlock;
    }

    @Override
    public Character getRailMainBlock() {
        return this.railMainBlock;
    }

    @Override
    public Character getParkElevationBlock() {
        return this.parkElevationBlock;
    }

    @Override
    public Character getCorridorRoofBlock() {
        return this.corridorRoofBlock;
    }

    @Override
    public Character getCorridorGlassBlock() {
        return this.corridorGlassBlock;
    }

    @Override
    public Character getBorderBlock() {
        return this.borderBlock;
    }

    @Override
    public Character getWallBlock() {
        return this.wallBlock;
    }

    public Character getSphereBlock() {
        return this.sphereBlock;
    }

    public Character getSphereSideBlock() {
        return this.sphereSideBlock;
    }

    public Character getSphereGlassBlock() {
        return this.sphereGlassBlock;
    }

    @Override
    public void init(CommonLevelAccessor level) {
        if (!this.resolveInherit) {
            this.resolveInherit = true;
            if (this.inherit != null) {
                CityStyle inheritFrom = AssetRegistries.CITYSTYLES.getOrThrow(level, this.inherit);
                if (this.style == null) {
                    this.style = inheritFrom.getStyle();
                }
                this.stuffTags.addAll(inheritFrom.stuffTags);
                this.buildingSelector.addAll(inheritFrom.buildingSelector);
                this.bridgeSelector.addAll(inheritFrom.bridgeSelector);
                this.parkSelector.addAll(inheritFrom.parkSelector);
                this.fountainSelector.addAll(inheritFrom.fountainSelector);
                this.stairSelector.addAll(inheritFrom.stairSelector);
                this.frontSelector.addAll(inheritFrom.frontSelector);
                this.railDungeonSelector.addAll(inheritFrom.railDungeonSelector);
                this.multiBuildingSelector.addAll(inheritFrom.multiBuildingSelector);
                if (this.explosionChance == null) {
                    this.explosionChance = inheritFrom.explosionChance;
                }
                if (this.streetWidth == null) {
                    this.streetWidth = inheritFrom.streetWidth;
                }
                if (this.streetParts == StreetParts.DEFAULT) {
                    this.streetParts = inheritFrom.streetParts;
                }
                if (this.minFloorCount == null) {
                    this.minFloorCount = inheritFrom.minFloorCount;
                }
                if (this.minCellarCount == null) {
                    this.minCellarCount = inheritFrom.minCellarCount;
                }
                if (this.maxFloorCount == null) {
                    this.maxFloorCount = inheritFrom.maxFloorCount;
                }
                if (this.maxCellarCount == null) {
                    this.maxCellarCount = inheritFrom.maxCellarCount;
                }
                if (this.buildingChance == null) {
                    this.buildingChance = inheritFrom.buildingChance;
                }
                if (this.parkChance == null) {
                    this.parkChance = inheritFrom.parkChance;
                }
                if (this.fountainChance == null) {
                    this.fountainChance = inheritFrom.fountainChance;
                }
                if (this.frontChance == null) {
                    this.frontChance = inheritFrom.frontChance;
                }
                if (this.corridorChance == null) {
                    this.corridorChance = inheritFrom.corridorChance;
                }
                if (this.parkElevation == null) {
                    this.parkElevation = inheritFrom.parkElevation;
                }
                if (this.avoidFoliage == null) {
                    this.avoidFoliage = inheritFrom.avoidFoliage;
                }
                if (this.parkBorder == null) {
                    this.parkBorder = inheritFrom.parkBorder;
                }
                if (this.parkStreetThreshold == null) {
                    this.parkStreetThreshold = inheritFrom.parkStreetThreshold;
                }
                if (this.streetBlock == null) {
                    this.streetBlock = inheritFrom.streetBlock;
                }
                if (this.streetBaseBlock == null) {
                    this.streetBaseBlock = inheritFrom.streetBaseBlock;
                }
                if (this.streetVariantBlock == null) {
                    this.streetVariantBlock = inheritFrom.streetVariantBlock;
                }
                if (this.parkElevationBlock == null) {
                    this.parkElevationBlock = inheritFrom.parkElevationBlock;
                }
                if (this.corridorRoofBlock == null) {
                    this.corridorRoofBlock = inheritFrom.corridorRoofBlock;
                }
                if (this.corridorGlassBlock == null) {
                    this.corridorGlassBlock = inheritFrom.corridorGlassBlock;
                }
                if (this.railMainBlock == null) {
                    this.railMainBlock = inheritFrom.railMainBlock;
                }
                if (this.borderBlock == null) {
                    this.borderBlock = inheritFrom.borderBlock;
                }
                if (this.wallBlock == null) {
                    this.wallBlock = inheritFrom.wallBlock;
                }
                if (this.sphereBlock == null) {
                    this.sphereBlock = inheritFrom.sphereBlock;
                }
                if (this.sphereSideBlock == null) {
                    this.sphereSideBlock = inheritFrom.sphereSideBlock;
                }
                if (this.sphereGlassBlock == null) {
                    this.sphereGlassBlock = inheritFrom.sphereGlassBlock;
                }
            }
        }
    }

    private static String getRandomFromList(Random random, List<ObjectSelector> list, ChunkCoord pos) {
        ObjectSelector fromList = Tools.getRandomFromList(random, list, (T objectSelector) -> {
            if (objectSelector.minSpawnDistance() > 0 || objectSelector.maxSpawnDistance() < Integer.MAX_VALUE) {
                int squaredDist = (pos.chunkX() << 4) * (pos.chunkX() << 4) + (pos.chunkZ() << 4) * (pos.chunkZ() << 4);
                int minDist = objectSelector.minSpawnDistance();
                int maxDist = objectSelector.maxSpawnDistance();
                if (squaredDist < minDist * minDist) {
                    if (objectSelector.feather() <= 0) {
                        return Float.valueOf(0.0f);
                    }
                    int fd = minDist - objectSelector.feather();
                    if (squaredDist < fd * fd) {
                        return Float.valueOf(0.0f);
                    }
                    float f = (float)(Math.sqrt(squaredDist) - (double)fd) / (float)(minDist - fd);
                    return Float.valueOf(f * objectSelector.factor());
                }
                if (squaredDist > maxDist * maxDist) {
                    if (objectSelector.feather() <= 0) {
                        return Float.valueOf(0.0f);
                    }
                    int fd = maxDist + objectSelector.feather();
                    if (squaredDist > fd * fd) {
                        return Float.valueOf(0.0f);
                    }
                    float f = (float)((double)fd - Math.sqrt(squaredDist)) / (float)(fd - maxDist);
                    return Float.valueOf(f * objectSelector.factor());
                }
            }
            return Float.valueOf(objectSelector.factor());
        });
        if (fromList == null) {
            return null;
        }
        return fromList.value();
    }

    public Set<String> getStuffTags() {
        return this.stuffTags;
    }

    public String getRandomStair(Random random, ChunkCoord pos) {
        return CityStyle.getRandomFromList(random, this.stairSelector, pos);
    }

    public String getRandomFront(Random random, ChunkCoord pos) {
        return CityStyle.getRandomFromList(random, this.frontSelector, pos);
    }

    public String getRandomRailDungeon(Random random, ChunkCoord pos) {
        return CityStyle.getRandomFromList(random, this.railDungeonSelector, pos);
    }

    public String getRandomPark(Random random, ChunkCoord pos) {
        return CityStyle.getRandomFromList(random, this.parkSelector, pos);
    }

    public String getRandomBridge(Random random, ChunkCoord pos) {
        return CityStyle.getRandomFromList(random, this.bridgeSelector, pos);
    }

    public String getRandomFountain(Random random, ChunkCoord pos) {
        return CityStyle.getRandomFromList(random, this.fountainSelector, pos);
    }

    public String getRandomBuilding(Random random, ChunkCoord pos) {
        return CityStyle.getRandomFromList(random, this.buildingSelector, pos);
    }

    public String getRandomMultiBuilding(Random random, ChunkCoord pos) {
        return CityStyle.getRandomFromList(random, this.multiBuildingSelector, pos);
    }

    public boolean hasMultiBuildings() {
        return !this.multiBuildingSelector.isEmpty();
    }

    public List<ObjectSelector> getMultiBuildingSelector() {
        return this.multiBuildingSelector;
    }
}

