/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lostcities.api.ILostChunkInfo;
import mcjty.lostcities.api.ILostCities;
import mcjty.lostcities.api.ILostCityAssetRegistry;
import mcjty.lostcities.api.ILostCityBuilding;
import mcjty.lostcities.api.ILostCityCityStyle;
import mcjty.lostcities.api.ILostCityInformation;
import mcjty.lostcities.api.ILostCityMultiBuilding;
import mcjty.lostcities.api.ILostSphere;
import mcjty.lostcities.gui.GuiLCConfig;
import mcjty.lostcities.setup.Config;
import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityFeature;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;

public class LostCitiesImp
implements ILostCities {
    private final Map<ResourceKey<Level>, LostCityInformation> info = new HashMap<ResourceKey<Level>, LostCityInformation>();

    public void cleanUp() {
        this.info.clear();
    }

    @Override
    @Nullable
    public ILostCityInformation getLostInfo(Level world) {
        IDimensionInfo dimensionInfo = ((LostCityFeature)((Object)Registration.LOSTCITY_FEATURE.get())).getDimensionInfo((WorldGenLevel)world);
        if (dimensionInfo != null) {
            if (!this.info.containsKey(world.m_46472_())) {
                LostCityInformation gen = new LostCityInformation(dimensionInfo);
                this.info.put((ResourceKey<Level>)world.m_46472_(), gen);
            }
            return this.info.get(world.m_46472_());
        }
        return null;
    }

    @Override
    public void registerDimension(ResourceKey<Level> key, String profile) {
        Config.registerLostCityDimension(key, profile);
    }

    @Override
    public void setOverworldProfile(String profile) {
        GuiLCConfig.selectProfile(profile, null);
    }

    public record LostCityInformation(IDimensionInfo dimensionInfo) implements ILostCityInformation
    {
        @Override
        public ILostChunkInfo getChunkInfo(int chunkX, int chunkZ) {
            ChunkCoord coord = new ChunkCoord(this.dimensionInfo.getType(), chunkX, chunkZ);
            return BuildingInfo.getBuildingInfo(coord, this.dimensionInfo);
        }

        @Override
        public ILostSphere getSphere(int x, int y, int z) {
            if (this.dimensionInfo.getProfile().isSpheres() || this.dimensionInfo.getProfile().isSpace()) {
                return BuildingInfo.getSphereInt(x, y, z, this.dimensionInfo);
            }
            return null;
        }

        @Override
        public ILostSphere getSphere(int x, int z) {
            if (this.dimensionInfo.getProfile().isSpheres() || this.dimensionInfo.getProfile().isSpace()) {
                return BuildingInfo.getSphereInt(x, z, this.dimensionInfo);
            }
            return null;
        }

        @Override
        public int getRealHeight(int level) {
            return this.dimensionInfo.getProfile().GROUNDLEVEL + level * 6;
        }

        @Override
        public ILostCityAssetRegistry<ILostCityBuilding> getBuildings() {
            return AssetRegistries.BUILDINGS.cast();
        }

        @Override
        public ILostCityAssetRegistry<ILostCityMultiBuilding> getMultiBuildings() {
            return AssetRegistries.MULTI_BUILDINGS.cast();
        }

        @Override
        public ILostCityAssetRegistry<ILostCityCityStyle> getCityStyles() {
            return AssetRegistries.CITYSTYLES.cast();
        }
    }
}

