/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.tools.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.api.ITrowelable;
import org.violetmoon.quark.api.IUsageTickerOverride;
import org.violetmoon.quark.base.Quark;
import org.violetmoon.quark.content.tools.module.SeedPouchModule;
import org.violetmoon.zeta.item.ZetaItem;
import org.violetmoon.zeta.module.IDisableable;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.registry.CreativeTabManager;
import org.violetmoon.zeta.util.ItemNBTHelper;
import org.violetmoon.zeta.util.RegistryUtil;

public class SeedPouchItem
extends ZetaItem
implements IUsageTickerOverride,
ITrowelable,
CreativeTabManager.AppendsUniquely {
    private static final int SEED_BAR_COLOR = Mth.m_14159_((float)0.4f, (float)0.4f, (float)1.0f);
    private static final int FERTILIZER_BAR_COLOR = Mth.m_14159_((float)0.85f, (float)0.85f, (float)0.85f);

    public SeedPouchItem(ZetaModule module) {
        super("seed_pouch", module, new Item.Properties().m_41487_(1));
        CreativeTabManager.addToCreativeTabNextTo((ResourceKey)CreativeModeTabs.f_256869_, (ItemLike)this, (ItemLike)Items.f_42655_, (boolean)false);
    }

    public boolean m_142305_(@NotNull ItemStack pouch, @NotNull ItemStack incoming, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess carriedSlotAccessor) {
        if (pouch.m_41613_() != 1 || action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (incoming.m_41619_()) {
            return this.dropOntoEmptyCursor(player, pouch, carriedSlotAccessor);
        }
        return this.absorbFromCursor(player, pouch, carriedSlotAccessor);
    }

    public boolean m_142207_(@NotNull ItemStack pouch, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        if (pouch.m_41613_() != 1 || action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        ItemStack droppedOnto = slot.m_7993_();
        if (droppedOnto.m_41619_()) {
            return this.dropIntoEmptySlot(player, pouch, slot);
        }
        return this.absorbFromSlot(player, pouch, slot);
    }

    private boolean absorbFromCursor(Player player, ItemStack pouch, SlotAccess cursorAccess) {
        return SeedPouchItem.mutateContents(pouch, contents -> {
            ItemStack onCursor = cursorAccess.m_142196_();
            if (!contents.absorb(onCursor)) {
                return false;
            }
            cursorAccess.m_142104_(onCursor);
            SeedPouchItem.playInsertSound((Entity)player);
            return true;
        });
    }

    private boolean absorbFromSlot(Player player, ItemStack pouch, Slot pickupFrom) {
        return SeedPouchItem.mutateContents(pouch, contents -> {
            if (!contents.absorb(pickupFrom.m_7993_())) {
                return false;
            }
            pickupFrom.m_6654_();
            SeedPouchItem.playInsertSound((Entity)player);
            return true;
        });
    }

    private boolean dropOntoEmptyCursor(Player player, ItemStack pouch, SlotAccess cursorAccess) {
        return SeedPouchItem.mutateContents(pouch, contents -> {
            if (contents.isEmpty()) {
                return false;
            }
            cursorAccess.m_142104_(contents.splitOneStack());
            SeedPouchItem.playRemoveOneSound((Entity)player);
            return true;
        });
    }

    private boolean dropIntoEmptySlot(Player player, ItemStack pouch, Slot depositInto) {
        return SeedPouchItem.mutateContents(pouch, contents -> {
            if (contents.isEmpty()) {
                return false;
            }
            depositInto.m_5852_(contents.splitOneStack());
            SeedPouchItem.playRemoveOneSound((Entity)player);
            return true;
        });
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    private static void playRemoveOneSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private static void playInsertSound(Entity entity) {
        entity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + entity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public boolean m_142522_(@NotNull ItemStack stack) {
        return true;
    }

    public int m_142158_(@NotNull ItemStack stack) {
        int count = SeedPouchItem.getCount(stack);
        return Math.round((float)count * 13.0f / (float)SeedPouchModule.maxItems);
    }

    public int m_142159_(@NotNull ItemStack stack) {
        return SeedPouchItem.getContents(stack).isFertilizer() ? FERTILIZER_BAR_COLOR : SEED_BAR_COLOR;
    }

    public static PouchContents getContents(ItemStack stack) {
        return PouchContents.readFromStack(stack);
    }

    public static int getCount(ItemStack stack) {
        return PouchContents.readCountOnlyFromStack(stack);
    }

    public static <T> T mutateContents(ItemStack pouch, Function<PouchContents, T> func) {
        return PouchContents.mutate(pouch, func);
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        Component base = super.m_7626_(stack);
        PouchContents contents = SeedPouchItem.getContents(stack);
        if (contents.isEmpty()) {
            return base;
        }
        MutableComponent comp = base.m_6881_();
        comp.m_7220_((Component)Component.m_237113_((String)" ("));
        comp.m_7220_(contents.getContents().m_41786_());
        comp.m_7220_((Component)Component.m_237113_((String)")"));
        return comp;
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack pouch = context.m_43722_();
        return SeedPouchItem.mutateContents(pouch, contents -> {
            ChestBlockEntity chest;
            Optional optionalItemHandler;
            BlockEntity targetedBE;
            if (contents.isEmpty()) {
                return super.m_6225_(context);
            }
            ItemStack seed = contents.getContents().m_41777_();
            int total = contents.count;
            seed.m_41764_(Math.min(seed.m_41741_(), total));
            Player player = context.m_43723_();
            if (player != null && player.m_6144_() && !context.m_43725_().m_5776_() && (targetedBE = context.m_43725_().m_7702_(BlockPos.m_274446_((Position)context.m_43720_()))) instanceof ChestBlockEntity && (optionalItemHandler = (chest = (ChestBlockEntity)targetedBE).getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.NORTH).resolve()).isPresent()) {
                ItemStack toInsert = seed.m_41777_();
                toInsert.m_41764_(total);
                ItemStack inserted = ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)optionalItemHandler.get()), (ItemStack)toInsert, (boolean)false);
                int amountInserted = total - inserted.m_41613_();
                if (amountInserted == 0) {
                    MutableComponent component = Component.m_237113_((String)"The inventory you are trying to insert into is full...").m_130940_(ChatFormatting.RED);
                    player.m_5661_((Component)component, true);
                } else {
                    contents.shrink(amountInserted);
                }
            }
            if (player == null || !player.m_6144_()) {
                return this.placeSeed((PouchContents)contents, context, seed, context.m_8083_());
            }
            InteractionResult bestRes = InteractionResult.FAIL;
            int range = contents.isSeed() ? SeedPouchModule.shiftRange : SeedPouchModule.fertilizerShiftRange;
            int blocks = range * range;
            int shift = -((int)Math.floor((float)range / 2.0f));
            for (int i = 0; i < blocks; ++i) {
                int x = shift + i % range;
                int z = shift + i / range;
                InteractionResult res = this.placeSeed((PouchContents)contents, context, seed, context.m_8083_().m_7918_(x, 0, z));
                if (contents.isEmpty()) break;
                if (bestRes.m_19077_()) continue;
                bestRes = res;
            }
            return bestRes;
        });
    }

    private InteractionResult placeSeed(PouchContents mutableContents, UseOnContext context, ItemStack seed, BlockPos pos) {
        int itemsToTake;
        InteractionResult res;
        @Nullable Player player = context.m_43723_();
        if (player == null) {
            res = seed.m_41720_().m_6225_((UseOnContext)new PouchItemUseContext(context, seed, pos));
        } else {
            ItemStack restore = player.m_21120_(context.m_43724_());
            player.m_21008_(context.m_43724_(), seed);
            res = seed.m_41720_().m_6225_((UseOnContext)new PouchItemUseContext(context, seed, pos));
            player.m_21008_(context.m_43724_(), restore);
        }
        int n = itemsToTake = res == InteractionResult.CONSUME ? 1 : 0;
        if (!(itemsToTake == 0 || player != null && player.m_150110_().f_35937_)) {
            mutableContents.shrink(itemsToTake);
        }
        return res;
    }

    public List<ItemStack> appendItemsToCreativeTab() {
        RegistryAccess access;
        if (!this.isEnabled()) {
            return List.of();
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)this));
        if (SeedPouchModule.showAllVariantsInCreative && (access = Quark.proxy.hackilyGetCurrentClientLevelRegistryAccess()) != null) {
            (SeedPouchModule.allowFertilizer ? Stream.of(SeedPouchModule.seedPouchHoldableTag, SeedPouchModule.seedPouchFertilizersTag) : Stream.of(SeedPouchModule.seedPouchHoldableTag)).flatMap(tag -> RegistryUtil.getTagValues((RegistryAccess)access, (TagKey)tag).stream()).filter(IDisableable::isEnabled).map(seed -> {
                PouchContents contents = new PouchContents();
                contents.setContents(new ItemStack((ItemLike)seed));
                contents.setCount(SeedPouchModule.maxItems);
                return contents.writeToStack(new ItemStack((ItemLike)this));
            }).forEach(list::add);
        }
        return list;
    }

    @Override
    public ItemStack getUsageTickerItem(ItemStack stack) {
        PouchContents contents = SeedPouchItem.getContents(stack);
        return contents.isEmpty() ? stack : contents.getContents();
    }

    @Override
    public int getUsageTickerCountForItem(ItemStack stack, Predicate<ItemStack> target) {
        PouchContents contents = SeedPouchItem.getContents(stack);
        return !contents.isEmpty() && target.test(contents.getContents()) ? contents.getCount() : 0;
    }

    @NotNull
    public Optional<TooltipComponent> m_142422_(@NotNull ItemStack stack) {
        return SeedPouchItem.getCount(stack) == 0 ? Optional.empty() : Optional.of(new Tooltip(stack));
    }

    public static class PouchContents {
        public static final String TAG_STORED_ITEM = "storedItem";
        public static final String TAG_COUNT = "itemCount";
        private ItemStack contents = ItemStack.f_41583_;
        private int count = 0;

        public ItemStack writeToStack(ItemStack target) {
            CompoundTag tag = target.m_41783_();
            if (this.isEmpty()) {
                if (tag != null) {
                    tag.m_128473_(TAG_STORED_ITEM);
                    tag.m_128473_(TAG_COUNT);
                    if (tag.m_128456_()) {
                        target.m_41751_(null);
                    }
                }
            } else {
                ItemNBTHelper.setCompound((ItemStack)target, (String)TAG_STORED_ITEM, (CompoundTag)this.contents.m_41739_(new CompoundTag()));
                ItemNBTHelper.setInt((ItemStack)target, (String)TAG_COUNT, (int)this.count);
            }
            return target;
        }

        public static PouchContents readFromStack(ItemStack target) {
            CompoundTag tag = target.m_41783_();
            PouchContents contents = new PouchContents();
            if (tag != null && tag.m_128441_(TAG_STORED_ITEM) && tag.m_128441_(TAG_COUNT)) {
                contents.contents = ItemStack.m_41712_((CompoundTag)tag.m_128469_(TAG_STORED_ITEM));
                contents.count = tag.m_128451_(TAG_COUNT);
            }
            return contents;
        }

        public static int readCountOnlyFromStack(ItemStack target) {
            return ItemNBTHelper.getInt((ItemStack)target, (String)TAG_COUNT, (int)0);
        }

        public static <T> T mutate(ItemStack pouch, Function<PouchContents, T> action) {
            PouchContents contents = PouchContents.readFromStack(pouch);
            T result = action.apply(contents);
            contents.writeToStack(pouch);
            return result;
        }

        public boolean isEmpty() {
            return this.contents.m_41619_() || this.count == 0;
        }

        public ItemStack getContents() {
            return this.contents;
        }

        public int getCount() {
            return this.count;
        }

        public boolean isSeed() {
            return !this.isEmpty() && this.contents.m_204117_(SeedPouchModule.seedPouchHoldableTag);
        }

        public boolean isFertilizer() {
            return !this.isEmpty() && this.contents.m_204117_(SeedPouchModule.seedPouchFertilizersTag);
        }

        public void setContents(ItemStack contents) {
            this.contents = contents.m_41777_();
            this.contents.m_41764_(1);
        }

        public void setCount(int newCount) {
            this.count = newCount;
            if (this.count <= 0) {
                this.count = 0;
                this.contents = ItemStack.f_41583_;
            }
        }

        public void grow(int more) {
            this.setCount(this.count + more);
        }

        public void shrink(int less) {
            this.setCount(this.count - less);
        }

        public boolean absorb(ItemStack other) {
            if (!this.canFit(other)) {
                return false;
            }
            int toMove = Math.min(SeedPouchModule.maxItems - this.count, other.m_41613_());
            if (toMove == 0) {
                return false;
            }
            if (this.isEmpty()) {
                this.setContents(other);
                this.setCount(toMove);
            } else {
                this.grow(toMove);
            }
            other.m_41774_(toMove);
            return true;
        }

        public ItemStack split(int request) {
            int howMany = Math.min(this.count, request);
            ItemStack result = this.contents.m_41777_();
            result.m_41764_(howMany);
            this.shrink(howMany);
            return result;
        }

        public ItemStack splitOneStack() {
            return this.split(this.contents.m_41741_());
        }

        public boolean canFit(ItemStack other) {
            if (this.isEmpty()) {
                return other.m_204117_(SeedPouchModule.seedPouchHoldableTag) || SeedPouchModule.allowFertilizer && other.m_204117_(SeedPouchModule.seedPouchFertilizersTag);
            }
            return this.count < SeedPouchModule.maxItems && ItemStack.m_150942_((ItemStack)this.contents, (ItemStack)other);
        }
    }

    public static class PouchItemUseContext
    extends UseOnContext {
        protected PouchItemUseContext(UseOnContext parent, ItemStack stack, BlockPos targetPos) {
            super(parent.m_43725_(), parent.m_43723_(), parent.m_43724_(), stack, new BlockHitResult(parent.m_43720_(), parent.m_43719_(), targetPos, parent.m_43721_()));
        }
    }

    public record Tooltip(ItemStack stack) implements TooltipComponent
    {
    }
}

