/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wires;

import com.google.common.cache.LoadingCache;
import commoble.morered.MoreRed;
import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import commoble.morered.api.WireConnector;
import commoble.morered.api.internal.DefaultWireProperties;
import commoble.morered.api.internal.WireVoxelHelpers;
import commoble.morered.util.BlockStateUtil;
import commoble.morered.util.DirectionHelper;
import commoble.morered.wires.AbstractWireBlock;
import commoble.morered.wires.BundledCableBlockEntity;
import commoble.morered.wires.Edge;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BundledCableBlock
extends AbstractWireBlock
implements EntityBlock {
    public static final VoxelShape[] NODE_SHAPES_DUNSWE = WireVoxelHelpers.makeNodeShapes(3, 4);
    public static final VoxelShape[] RAYTRACE_BACKBOARDS = WireVoxelHelpers.makeRaytraceBackboards(4);
    public static final VoxelShape[] LINE_SHAPES = WireVoxelHelpers.makeLineShapes(3, 4);
    public static final VoxelShape[] SHAPES_BY_STATE_INDEX = AbstractWireBlock.makeVoxelShapes(NODE_SHAPES_DUNSWE, LINE_SHAPES);
    public static final LoadingCache<Long, VoxelShape> VOXEL_CACHE = AbstractWireBlock.makeVoxelCache(SHAPES_BY_STATE_INDEX, LINE_SHAPES);

    public BundledCableBlock(BlockBehaviour.Properties properties) {
        super(properties, SHAPES_BY_STATE_INDEX, RAYTRACE_BACKBOARDS, VOXEL_CACHE, false);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)MoreRed.get().bundledNetworkCableBeType.get()).m_155264_(pos, state);
    }

    public void onNeighborChange(BlockState state, LevelReader world, BlockPos pos, BlockPos neighbor) {
        if (!(world instanceof Level)) {
            return;
        }
        BlockEntity neighborTE = world.m_7702_(pos);
        if (neighborTE == null) {
            return;
        }
        Direction directionFromNeighbor = DirectionHelper.getDirectionToNeighborPos(neighbor, pos);
        if (directionFromNeighbor == null) {
            return;
        }
        neighborTE.getCapability(MoreRedAPI.CHANNELED_POWER_CAPABILITY, directionFromNeighbor).ifPresent($ -> this.updatePowerAfterBlockUpdate((Level)world, pos, state));
        long edgeFlags = this.getEdgeFlags((BlockGetter)world, pos);
        if (edgeFlags != 0L) {
            EnumSet<Direction> edgeUpdateDirs = EnumSet.noneOf(Direction.class);
            Direction directionToNeighbor = directionFromNeighbor.m_122424_();
            Edge[] edges = Edge.values();
            for (int edgeFlag = 0; edgeFlag < 12; ++edgeFlag) {
                if ((edgeFlags & (long)(1 << edgeFlag)) == 0L) continue;
                Edge edge = edges[edgeFlag];
                if (edge.sideA == directionToNeighbor) {
                    edgeUpdateDirs.add(edge.sideB);
                    continue;
                }
                if (edge.sideB != directionToNeighbor) continue;
                edgeUpdateDirs.add(edge.sideA);
            }
            if (!edgeUpdateDirs.isEmpty()) {
                BlockPos.MutableBlockPos mutaPos = pos.m_122032_();
                for (Direction dir : edgeUpdateDirs) {
                    BlockPos.MutableBlockPos otherNeighborPos = mutaPos.m_122159_((Vec3i)pos, dir);
                    world.m_8055_((BlockPos)otherNeighborPos).onNeighborChange(world, (BlockPos)otherNeighborPos, pos);
                }
            }
        }
    }

    @Override
    protected void updatePowerAfterBlockUpdate(Level world, BlockPos wirePos, BlockState wireState) {
        BlockEntity te = world.m_7702_(wirePos);
        if (!(te instanceof BundledCableBlockEntity)) {
            return;
        }
        BundledCableBlockEntity wire = (BundledCableBlockEntity)te;
        Map<Block, WireConnector> connectors = MoreRedAPI.getCableConnectabilityRegistry();
        WireConnector defaultConnector = MoreRedAPI.getDefaultCableConnector();
        BlockPos.MutableBlockPos mutaPos = wirePos.m_122032_();
        BlockState[] neighborStates = new BlockState[6];
        EnumMap<Direction, ChanneledPowerSupplier> neighborPowerSuppliers = new EnumMap<Direction, ChanneledPowerSupplier>(Direction.class);
        ChanneledPowerSupplier noPower = DefaultWireProperties.NO_POWER_SUPPLIER;
        Function<BlockPos, Function> neighborPowerFinder = neighborPos -> directionToNeighbor -> {
            BlockEntity neighborTE = world.m_7702_(neighborPos);
            if (neighborTE == null) {
                return noPower;
            }
            return (ChanneledPowerSupplier)neighborTE.getCapability(MoreRedAPI.CHANNELED_POWER_CAPABILITY, directionToNeighbor.m_122424_()).orElse((Object)noPower);
        };
        for (int channel = 0; channel < 16; ++channel) {
            EnumSet<Direction> facesNeedingUpdates = EnumSet.noneOf(Direction.class);
            boolean[] attachedFaceStates = new boolean[6];
            for (int attachmentSide = 0; attachmentSide < 6; ++attachmentSide) {
                if (((Boolean)wireState.m_61143_((Property)INTERIOR_FACES[attachmentSide])).booleanValue()) {
                    attachedFaceStates[attachmentSide] = true;
                    facesNeedingUpdates.add(Direction.m_122376_((int)attachmentSide));
                    continue;
                }
                wire.setPower(attachmentSide, channel, 0);
            }
            int iteration = 0;
            while (!facesNeedingUpdates.isEmpty()) {
                ChanneledPowerSupplier attachedNeighborPowerSupplier;
                int attachmentSide;
                Direction attachmentDirection;
                if (!facesNeedingUpdates.remove(attachmentDirection = Direction.m_122376_((int)(attachmentSide = iteration++ % 6)))) continue;
                mutaPos.m_122159_((Vec3i)wirePos, attachmentDirection);
                BlockState attachedNeighborState = neighborStates[attachmentSide];
                if (attachedNeighborState == null) {
                    neighborStates[attachmentSide] = attachedNeighborState = world.m_8055_((BlockPos)mutaPos);
                }
                if ((attachedNeighborPowerSupplier = (ChanneledPowerSupplier)neighborPowerSuppliers.get(attachmentDirection)) == null) {
                    attachedNeighborPowerSupplier = (ChanneledPowerSupplier)neighborPowerFinder.apply((BlockPos)mutaPos).apply(attachmentDirection);
                    neighborPowerSuppliers.put(attachmentDirection, attachedNeighborPowerSupplier);
                }
                int power = Math.max(0, attachedNeighborPowerSupplier.getPowerOnChannel(world, wirePos, wireState, attachmentDirection, channel) - 1);
                for (int orthagonal = 0; orthagonal < 4; ++orthagonal) {
                    BlockEntity diagonalTe;
                    Block neighborBlock;
                    WireConnector connector;
                    int neighborSide = DirectionHelper.uncompressSecondSide(attachmentSide, orthagonal);
                    Direction directionToNeighbor = Direction.m_122376_((int)neighborSide);
                    Direction directionToWire = directionToNeighbor.m_122424_();
                    BlockState neighborState = neighborStates[neighborSide];
                    mutaPos.m_122159_((Vec3i)wirePos, directionToNeighbor);
                    if (neighborState == null) {
                        neighborStates[neighborSide] = neighborState = world.m_8055_((BlockPos)mutaPos);
                    }
                    if ((connector = connectors.getOrDefault(neighborBlock = neighborState.m_60734_(), defaultConnector)).canConnectToAdjacentWire((BlockGetter)world, (BlockPos)mutaPos, neighborState, wirePos, wireState, attachmentDirection, directionToWire)) {
                        ChanneledPowerSupplier orthagonalPowerSupplier = (ChanneledPowerSupplier)neighborPowerSuppliers.get(directionToNeighbor);
                        if (orthagonalPowerSupplier == null) {
                            orthagonalPowerSupplier = (ChanneledPowerSupplier)neighborPowerFinder.apply((BlockPos)mutaPos).apply(directionToNeighbor);
                            neighborPowerSuppliers.put(directionToNeighbor, orthagonalPowerSupplier);
                        }
                        power = Math.max(power, orthagonalPowerSupplier.getPowerOnChannel(world, wirePos, wireState, attachmentDirection, channel) - 1);
                    }
                    if (directionToNeighbor != attachmentDirection) {
                        power = Math.max(power, wire.getPower(neighborSide, channel) - 1);
                    }
                    if (attachedFaceStates[neighborSide] || neighborBlock != this || ((Boolean)neighborState.m_61143_((Property)INTERIOR_FACES[attachmentSide])).booleanValue()) continue;
                    BlockPos.MutableBlockPos diagonalPos = mutaPos.m_122173_(attachmentDirection);
                    BlockState diagonalState = world.m_8055_((BlockPos)mutaPos);
                    int directionToWireSide = directionToWire.ordinal();
                    if (diagonalState.m_60734_() != this || !((Boolean)diagonalState.m_61143_((Property)INTERIOR_FACES[directionToWireSide])).booleanValue() || !((diagonalTe = world.m_7702_((BlockPos)diagonalPos)) instanceof BundledCableBlockEntity)) continue;
                    power = Math.max(power, ((BundledCableBlockEntity)diagonalTe).getPower(directionToWireSide, channel) - 1);
                }
                if (!wire.setPower(attachmentSide, channel, power)) continue;
                Direction[] nextUpdateDirs = BlockStateUtil.OUTPUT_TABLE[attachmentSide];
                for (int i = 0; i < 4; ++i) {
                    Direction nextUpdateDir = nextUpdateDirs[i];
                    if (!attachedFaceStates[nextUpdateDir.ordinal()]) continue;
                    facesNeedingUpdates.add(nextUpdateDir);
                }
            }
        }
    }

    @Override
    protected void notifyNeighbors(Level world, BlockPos wirePos, BlockState newState, EnumSet<Direction> updateDirections, boolean doConductedPowerUpdates) {
    }

    @Override
    protected boolean canAdjacentBlockConnectToFace(BlockGetter world, BlockPos thisPos, BlockState thisState, Block neighborBlock, Direction attachmentDirection, Direction directionToWire, BlockPos neighborPos, BlockState neighborState) {
        return MoreRedAPI.getCableConnectabilityRegistry().getOrDefault(neighborBlock, MoreRedAPI.getDefaultCableConnector()).canConnectToAdjacentWire(world, neighborPos, neighborState, thisPos, thisState, attachmentDirection, directionToWire);
    }
}

