/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.wire_post;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import commoble.morered.MoreRed;
import commoble.morered.ServerConfig;
import commoble.morered.wire_post.SyncPostsInChunkPacket;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PostsInChunk
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final Capability<PostsInChunk> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PostsInChunk>(){});
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String POSITIONS = "positions";
    public static final Codec<Set<BlockPos>> DATA_CODEC = BlockPos.f_121852_.listOf().xmap(HashSet::new, List::copyOf);
    private final LazyOptional<PostsInChunk> holder = LazyOptional.of(() -> this);
    private Set<BlockPos> positions = new HashSet<BlockPos>();
    private final LevelChunk chunk;

    public LevelChunk getChunk() {
        return this.chunk;
    }

    public PostsInChunk(LevelChunk chunk) {
        this.chunk = chunk;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CAPABILITY) {
            return CAPABILITY.orEmpty(cap, this.holder);
        }
        return LazyOptional.empty();
    }

    public Set<BlockPos> getPositions() {
        return this.positions;
    }

    public void setPositions(Set<BlockPos> set) {
        this.positions = set;
        MoreRed.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(this::getChunk), (Object)new SyncPostsInChunkPacket(this.chunk.m_7697_(), set));
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        DATA_CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.positions).resultOrPartial(e -> LOGGER.error("Error encoding PostsInChunk for chunk {}, {}: {}", (Object)this.chunk.m_7697_().f_45578_, (Object)this.chunk.m_7697_().f_45579_, e)).ifPresent(tag -> compound.m_128365_(POSITIONS, tag));
        return compound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        Tag tag = nbt.m_128423_(POSITIONS);
        if (tag != null) {
            DATA_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tag).resultOrPartial(e -> LOGGER.error("Error dencoding PostsInChunk for chunk {}, {}: {}", (Object)this.chunk.m_7697_().f_45578_, (Object)this.chunk.m_7697_().f_45579_, e)).ifPresent(set -> {
                this.positions = set;
            });
        }
    }

    public static Set<ChunkPos> getRelevantChunkPositionsNearPos(BlockPos pos) {
        double range = (Double)ServerConfig.INSTANCE.maxWirePostConnectionRange().get();
        ChunkPos chunkPos = new ChunkPos(pos);
        int chunkRange = (int)Math.ceil(range / 16.0);
        HashSet<ChunkPos> set = new HashSet<ChunkPos>();
        for (int xOff = -chunkRange; xOff <= chunkRange; ++xOff) {
            for (int zOff = -chunkRange; zOff <= chunkRange; ++zOff) {
                set.add(new ChunkPos(chunkPos.f_45578_ + xOff, chunkPos.f_45579_ + zOff));
            }
        }
        return set;
    }

    public void onCapabilityInvalidated() {
        this.holder.invalidate();
    }
}

