/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.util;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.world.phys.AABB;

public class NestedBoundingBox {
    @Nonnull
    private final List<NestedBoundingBox> subBoxes;
    @Nonnull
    private final AABB superBox;
    private static final AABB EMPTY_AABB = new AABB(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    public static final NestedBoundingBox EMPTY = new NestedBoundingBox(EMPTY_AABB);

    public NestedBoundingBox(@Nonnull NestedBoundingBox boxA, @Nonnull NestedBoundingBox boxB) {
        this.subBoxes = Collections.unmodifiableList(Lists.newArrayList((Object[])new NestedBoundingBox[]{boxA, boxB}));
        this.superBox = boxA.superBox.m_82367_(boxB.superBox);
    }

    public NestedBoundingBox(@Nonnull AABB box) {
        this.subBoxes = Collections.emptyList();
        this.superBox = box;
    }

    public NestedBoundingBox combine(@Nonnull NestedBoundingBox other) {
        return new NestedBoundingBox(this, other);
    }

    public static NestedBoundingBox fromAABBs(AABB ... boxes) {
        return NestedBoundingBox.fromAABBs(0, boxes.length - 1, boxes);
    }

    private static NestedBoundingBox fromAABBs(int fromIndex, int toIndex, AABB ... boxes) {
        int size = toIndex - fromIndex + 1;
        if (size <= 0) {
            return new NestedBoundingBox(EMPTY_AABB);
        }
        if (size == 1) {
            return new NestedBoundingBox(boxes[toIndex]);
        }
        int partition = (fromIndex + toIndex) / 2;
        return new NestedBoundingBox(NestedBoundingBox.fromAABBs(fromIndex, partition, boxes), NestedBoundingBox.fromAABBs(partition + 1, toIndex, boxes));
    }

    public boolean intersects(@Nonnull AABB target) {
        return new IntersectionPredicate(target).test(this);
    }

    private static class IntersectionPredicate
    implements Predicate<NestedBoundingBox> {
        private final AABB target;

        public IntersectionPredicate(AABB target) {
            this.target = target;
        }

        @Override
        public boolean test(NestedBoundingBox box) {
            if (!box.superBox.m_82381_(this.target)) {
                return false;
            }
            if (box.subBoxes.isEmpty()) {
                return true;
            }
            return box.subBoxes.parallelStream().anyMatch(this);
        }
    }
}

