/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.bitwise_logic;

import commoble.morered.api.ChanneledPowerSupplier;
import commoble.morered.api.MoreRedAPI;
import commoble.morered.bitwise_logic.BitwiseLogicPlateBlock;
import commoble.morered.bitwise_logic.ChanneledPowerStorageBlockEntity;
import commoble.morered.plate_blocks.LogicFunction;
import commoble.morered.plate_blocks.PlateBlock;
import commoble.morered.plate_blocks.PlateBlockStateProperties;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SingleInputBitwiseLogicPlateBlock
extends BitwiseLogicPlateBlock {
    private final LogicFunction operator;

    public SingleInputBitwiseLogicPlateBlock(BlockBehaviour.Properties properties, LogicFunction operator) {
        super(properties);
        this.operator = operator;
    }

    @Override
    protected void updatePower(Level level, BlockPos thisPos, BlockState thisState) {
        BlockEntity be = level.m_7702_(thisPos);
        if (be instanceof ChanneledPowerStorageBlockEntity) {
            ChanneledPowerStorageBlockEntity powerBe = (ChanneledPowerStorageBlockEntity)be;
            Direction outputDir = PlateBlockStateProperties.getOutputDirection(thisState);
            Direction inputDir = outputDir.m_122424_();
            BlockPos inputPos = thisPos.m_121945_(inputDir);
            BlockEntity inputTE = level.m_7702_(inputPos);
            byte[] power = new byte[16];
            ChanneledPowerSupplier inputSupplier = inputTE == null ? BitwiseLogicPlateBlock.NO_POWER_SUPPLIER : (ChanneledPowerSupplier)inputTE.getCapability(MoreRedAPI.CHANNELED_POWER_CAPABILITY, inputDir.m_122424_()).orElse((Object)NO_POWER_SUPPLIER);
            Direction attachmentDir = (Direction)thisState.m_61143_((Property)PlateBlockStateProperties.ATTACHMENT_DIRECTION);
            for (int i = 0; i < 16; ++i) {
                byte inputPower = (byte)inputSupplier.getPowerOnChannel(level, thisPos, thisState, attachmentDir, i);
                boolean inputBit = inputPower > 0;
                boolean outputBit = this.operator.apply(false, inputBit, false);
                power[i] = (byte)(outputBit ? 31 : 0);
            }
            powerBe.setPower(power);
        }
    }

    @Override
    public boolean canConnectToAdjacentCable(@Nonnull BlockGetter level, @Nonnull BlockPos thisPos, @Nonnull BlockState thisState, @Nonnull BlockPos wirePos, @Nonnull BlockState wireState, @Nonnull Direction wireFace, @Nonnull Direction directionToWire) {
        Direction plateAttachmentDir = (Direction)thisState.m_61143_((Property)PlateBlock.ATTACHMENT_DIRECTION);
        Direction primaryOutputDirection = PlateBlockStateProperties.getOutputDirection(thisState);
        return plateAttachmentDir == wireFace && (directionToWire == primaryOutputDirection || directionToWire == primaryOutputDirection.m_122424_());
    }
}

