/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.ritual.types;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import wayoftime.bloodmagic.common.item.BloodMagicItems;
import wayoftime.bloodmagic.core.living.ILivingContainer;
import wayoftime.bloodmagic.core.living.LivingStats;
import wayoftime.bloodmagic.core.living.LivingUpgrade;
import wayoftime.bloodmagic.core.living.LivingUtil;
import wayoftime.bloodmagic.ritual.AreaDescriptor;
import wayoftime.bloodmagic.ritual.EnumRuneType;
import wayoftime.bloodmagic.ritual.IMasterRitualStone;
import wayoftime.bloodmagic.ritual.Ritual;
import wayoftime.bloodmagic.ritual.RitualComponent;
import wayoftime.bloodmagic.ritual.RitualRegister;

@RitualRegister(value="upgrade_remove")
public class RitualUpgradeRemove
extends Ritual {
    public static final String CHECK_RANGE = "fillRange";

    public RitualUpgradeRemove() {
        super("ritualUpgradeRemove", 0, 25000, "ritual.bloodmagic.upgradeRemoveRitual");
        this.addBlockRange(CHECK_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1, 2, 1));
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        Level world = masterRitualStone.getWorldObj();
        if (world.f_46443_) {
            return;
        }
        BlockPos pos = masterRitualStone.getMasterBlockPos();
        AreaDescriptor checkRange = masterRitualStone.getBlockRange(CHECK_RANGE);
        List playerList = world.m_45976_(Player.class, checkRange.getAABB(pos));
        for (Player player : playerList) {
            if (!LivingUtil.hasFullSet(player)) continue;
            boolean removedUpgrade = false;
            ItemStack chestStack = player.m_6844_(EquipmentSlot.CHEST);
            LivingStats stats = LivingStats.fromPlayer(player);
            if (stats == null) continue;
            Map<LivingUpgrade, Double> upgrades = stats.getUpgrades();
            for (Map.Entry<LivingUpgrade, Double> entry : upgrades.entrySet()) {
                int exp = entry.getValue().intValue();
                LivingUpgrade upgrade = entry.getKey();
                int level = upgrade.getLevel(exp);
                if (level >= 1) {
                    ItemStack upgradeStack = new ItemStack((ItemLike)BloodMagicItems.LIVING_TOME.get());
                    ((ILivingContainer)BloodMagicItems.LIVING_TOME.get()).updateLivingStats(upgradeStack, new LivingStats().setMaxPoints(upgrade.getLevelCost(exp)).addExperience(upgrade.getKey(), exp));
                    ItemEntity item = new ItemEntity(world, player.m_20185_(), player.m_20186_(), player.m_20189_(), upgradeStack);
                    world.m_7967_((Entity)item);
                    removedUpgrade = true;
                }
                stats.resetExperience(upgrade.getKey());
            }
            if (!removedUpgrade) continue;
            LivingStats.toPlayer(player, stats);
            masterRitualStone.setActive(false);
            LightningBolt lightningboltentity = (LightningBolt)EntityType.f_20465_.m_20615_(world);
            lightningboltentity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            lightningboltentity.m_20874_(true);
            world.m_7967_((Entity)lightningboltentity);
        }
    }

    @Override
    public int getRefreshTime() {
        return 1;
    }

    @Override
    public int getRefreshCost() {
        return 0;
    }

    @Override
    public void gatherComponents(Consumer<RitualComponent> components) {
        this.addCornerRunes(components, 1, 0, EnumRuneType.DUSK);
        this.addCornerRunes(components, 2, 0, EnumRuneType.FIRE);
        this.addOffsetRunes(components, 1, 2, 0, EnumRuneType.FIRE);
        this.addCornerRunes(components, 1, 1, EnumRuneType.WATER);
        this.addParallelRunes(components, 4, 0, EnumRuneType.EARTH);
        this.addCornerRunes(components, 1, 3, EnumRuneType.WATER);
        this.addParallelRunes(components, 1, 4, EnumRuneType.AIR);
        for (int i = 0; i < 4; ++i) {
            this.addCornerRunes(components, 3, i, EnumRuneType.EARTH);
        }
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualUpgradeRemove();
    }
}

