/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import wayoftime.bloodmagic.common.tile.TileAlchemyTable;

public class AlchemyTableFlagPacket {
    private BlockPos pos;
    private boolean orbFlag;
    private boolean lpFlag;

    public AlchemyTableFlagPacket() {
        this.pos = BlockPos.f_121853_;
        this.orbFlag = false;
        this.lpFlag = false;
    }

    public AlchemyTableFlagPacket(TileAlchemyTable tile) {
        this(tile.m_58899_(), tile.getOrbFlagForGui(), tile.getLPFlagforGui());
    }

    public AlchemyTableFlagPacket(BlockPos pos, boolean orbFlag, boolean lpFlag) {
        this.pos = pos;
        this.orbFlag = orbFlag;
        this.lpFlag = lpFlag;
    }

    public static void encode(AlchemyTableFlagPacket pkt, FriendlyByteBuf buf) {
        buf.m_130064_(pkt.pos);
        buf.writeBoolean(pkt.orbFlag);
        buf.writeBoolean(pkt.lpFlag);
    }

    public static AlchemyTableFlagPacket decode(FriendlyByteBuf buf) {
        AlchemyTableFlagPacket pkt = new AlchemyTableFlagPacket(buf.m_130135_(), buf.readBoolean(), buf.readBoolean());
        return pkt;
    }

    public static void handle(AlchemyTableFlagPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> AlchemyTableFlagPacket.updateTanks(message.pos, message.orbFlag, message.lpFlag));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void updateTanks(BlockPos pos, boolean orbFlag, boolean lpFlag) {
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        BlockEntity tile = world.m_7702_(pos);
        if (tile instanceof TileAlchemyTable) {
            ((TileAlchemyTable)tile).setOrbFlagForGui(orbFlag);
            ((TileAlchemyTable)tile).setLPFlagForGui(lpFlag);
            if (!orbFlag && !lpFlag) {
                ((TileAlchemyTable)tile).burnTime = 0;
            }
        }
    }
}

