/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.core.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.util.helper.PlayerHelper;

public class BMWorldSavedData
extends SavedData {
    public static final String ID = "BloodMagic-SoulNetworks";
    private int numberOfDungeons = 0;
    public static final int DUNGEON_DISPLACEMENT = 1000;
    private Map<UUID, SoulNetwork> soulNetworks = new HashMap<UUID, SoulNetwork>();

    public BMWorldSavedData(String id) {
    }

    public BMWorldSavedData() {
        this(ID);
    }

    public SoulNetwork getNetwork(Player player) {
        return this.getNetwork(PlayerHelper.getUUIDFromPlayer(player));
    }

    public SoulNetwork getNetwork(UUID playerId) {
        if (!this.soulNetworks.containsKey(playerId)) {
            this.soulNetworks.put(playerId, SoulNetwork.newEmpty(playerId).setParent(this));
        }
        return this.soulNetworks.get(playerId);
    }

    public static BMWorldSavedData load(CompoundTag tagCompound) {
        BMWorldSavedData worldData = new BMWorldSavedData();
        ListTag networkData = tagCompound.m_128437_("networkData", 10);
        for (int i = 0; i < networkData.size(); ++i) {
            CompoundTag data = networkData.m_128728_(i);
            SoulNetwork network = SoulNetwork.fromNBT(data);
            network.setParent(worldData);
            worldData.soulNetworks.put(network.getPlayerId(), network);
        }
        worldData.numberOfDungeons = tagCompound.m_128451_("numberOfDungeons");
        return worldData;
    }

    public CompoundTag m_7176_(CompoundTag tagCompound) {
        ListTag networkData = new ListTag();
        for (SoulNetwork soulNetwork : this.soulNetworks.values()) {
            networkData.add((Object)soulNetwork.serializeNBT());
        }
        tagCompound.m_128365_("networkData", (Tag)networkData);
        tagCompound.m_128405_("numberOfDungeons", this.numberOfDungeons);
        return tagCompound;
    }

    public int getNumberOfDungeons() {
        return this.numberOfDungeons;
    }

    public void setNumberOfDungeons(int numberOfDungeons) {
        this.numberOfDungeons = numberOfDungeons;
    }
}

