/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.compat.jei.alchemytable;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.common.block.BloodMagicBlocks;
import wayoftime.bloodmagic.core.registry.OrbRegistry;
import wayoftime.bloodmagic.recipe.RecipeAlchemyTable;
import wayoftime.bloodmagic.util.ChatUtil;

public class AlchemyTableRecipeCategory
implements IRecipeCategory<RecipeAlchemyTable> {
    public static final RecipeType<RecipeAlchemyTable> RECIPE_TYPE = RecipeType.create((String)"bloodmagic", (String)"alchemytable", RecipeAlchemyTable.class);
    @Nonnull
    private final IDrawable background;
    private final IDrawable icon;

    public AlchemyTableRecipeCategory(IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)BloodMagicBlocks.ALCHEMY_TABLE.get()));
        this.background = guiHelper.createDrawable(BloodMagic.rl("gui/jei/alchemytable.png"), 0, 0, 118, 40);
    }

    public List<Component> getTooltipStrings(RecipeAlchemyTable recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList tooltip = Lists.newArrayList();
        if (mouseX >= 58.0 && mouseX <= 78.0 && mouseY >= 21.0 && mouseY <= 34.0) {
            tooltip.add(Component.m_237110_((String)"tooltip.bloodmagic.tier", (Object[])new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getMinimumTier())}));
            tooltip.add(Component.m_237110_((String)"jei.bloodmagic.recipe.lpDrained", (Object[])new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getSyphon())}));
            tooltip.add(Component.m_237110_((String)"jei.bloodmagic.recipe.ticksRequired", (Object[])new Object[]{ChatUtil.DECIMAL_FORMAT.format(recipe.getTicks())}));
        }
        return tooltip;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)"jei.bloodmagic.recipe.alchemytable");
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeAlchemyTable recipe, IFocusGroup focuses) {
        IRecipeSlotBuilder output = builder.addSlot(RecipeIngredientRole.OUTPUT, 92, 14);
        output.addItemStack(recipe.getOutput());
        IRecipeSlotBuilder orb = builder.addSlot(RecipeIngredientRole.CATALYST, 61, 1);
        orb.addItemStacks(OrbRegistry.getOrbsDownToTier(recipe.getMinimumTier()));
        for (int index = 0; index < recipe.getInput().size(); ++index) {
            int x = index % 3;
            int y = index / 3;
            IRecipeSlotBuilder input = builder.addSlot(RecipeIngredientRole.INPUT, x * 18 + 1, y * 18 + 1);
            input.addIngredients(recipe.getInput().get(index));
        }
    }

    public RecipeType<RecipeAlchemyTable> getRecipeType() {
        return RECIPE_TYPE;
    }
}

