/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.tile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import wayoftime.bloodmagic.common.alchemyarray.AlchemyArrayEffect;
import wayoftime.bloodmagic.common.tile.BloodMagicTileEntities;
import wayoftime.bloodmagic.common.tile.TileInventory;
import wayoftime.bloodmagic.core.registry.AlchemyArrayRegistry;

public class TileAlchemyArray
extends TileInventory {
    public boolean isActive = false;
    public int activeCounter = 0;
    public Direction rotation = Direction.m_122407_((int)0);
    public int rotateCooldown = 0;
    private String key = "";
    public AlchemyArrayEffect arrayEffect;
    private boolean doDropIngredients = true;

    public TileAlchemyArray(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, 2, "alchemyarray", pos, state);
    }

    public TileAlchemyArray(BlockPos pos, BlockState state) {
        this((BlockEntityType)BloodMagicTileEntities.ALCHEMY_ARRAY_TYPE.get(), pos, state);
    }

    public void onEntityCollidedWithBlock(BlockState state, Entity entity) {
        if (this.arrayEffect != null) {
            this.arrayEffect.onEntityCollidedWithBlock(this, this.m_58904_(), this.f_58858_, state, entity);
        }
    }

    @Override
    public void deserialize(CompoundTag tagCompound) {
        super.deserialize(tagCompound);
        this.isActive = tagCompound.m_128471_("isActive");
        this.activeCounter = tagCompound.m_128451_("activeCounter");
        this.key = tagCompound.m_128461_("stringKey");
        this.doDropIngredients = !tagCompound.m_128441_("doDropIngredients") ? true : tagCompound.m_128471_("doDropIngredients");
        this.rotation = Direction.m_122407_((int)tagCompound.m_128451_("direction"));
        CompoundTag arrayTag = tagCompound.m_128469_("arrayTag");
        if (this.arrayEffect != null) {
            this.arrayEffect.readFromNBT(arrayTag);
        }
    }

    public void doDropIngredients(boolean drop) {
        this.doDropIngredients = drop;
    }

    @Override
    public CompoundTag serialize(CompoundTag tagCompound) {
        super.serialize(tagCompound);
        tagCompound.m_128379_("isActive", this.isActive);
        tagCompound.m_128405_("activeCounter", this.activeCounter);
        tagCompound.m_128359_("stringKey", "".equals(this.key) ? "empty" : this.key.toString());
        tagCompound.m_128379_("doDropIngredients", this.doDropIngredients);
        tagCompound.m_128405_("direction", this.rotation.m_122416_());
        CompoundTag arrayTag = new CompoundTag();
        if (this.arrayEffect != null) {
            this.arrayEffect.writeToNBT(arrayTag);
        }
        tagCompound.m_128365_("arrayTag", (Tag)arrayTag);
        return tagCompound;
    }

    public void tick() {
        if (this.isActive && this.attemptCraft()) {
            ++this.activeCounter;
        } else {
            this.isActive = false;
            this.doDropIngredients = true;
            this.activeCounter = 0;
            this.arrayEffect = null;
            this.key = "empty";
        }
        if (this.rotateCooldown > 0) {
            --this.rotateCooldown;
        }
    }

    public boolean attemptCraft() {
        if (this.arrayEffect != null) {
            this.isActive = true;
        } else {
            AlchemyArrayEffect effect = AlchemyArrayRegistry.getEffect(this.f_58857_, this.m_8020_(0), this.m_8020_(1));
            if (effect == null) {
                return false;
            }
            this.arrayEffect = effect;
        }
        if (this.arrayEffect != null) {
            this.isActive = true;
            if (this.arrayEffect.update(this, this.activeCounter)) {
                this.m_7407_(0, 1);
                this.m_7407_(1, 1);
                this.m_58904_().m_46597_(this.m_58899_(), Blocks.f_50016_.m_49966_());
            }
            return true;
        }
        return false;
    }

    public Direction getRotation() {
        return this.rotation;
    }

    public void setRotation(Direction rotation) {
        this.rotation = rotation;
    }

    @Override
    public boolean m_7013_(int slot, ItemStack itemstack) {
        return slot == 0 || slot == 1;
    }
}

