/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils.memoization;

import java.util.function.Supplier;

public class MemoizedSupplier<T>
implements Supplier<T> {
    protected T value = null;
    protected boolean initialized = false;
    protected final Supplier<T> delegate;

    protected MemoizedSupplier(Supplier<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public T get() {
        if (!this.initialized) {
            this.value = this.delegate.get();
            this.initialized = true;
        }
        return this.value;
    }

    public void invalidate() {
        this.initialized = false;
        this.value = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.initialized ? this.value : "Uninitialized") + ")";
    }
}

