/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class TagExprFilter {
    public static TagExprParser.MatchExpr parseExpression(String expression) {
        return new TagExprParser().parse(expression);
    }

    public static boolean tagsMatch(TagExprParser.MatchExpr expr, ItemStack stack) {
        Set<String> tags = stack.m_204131_().map(TagKey::f_203868_).map(ResourceLocation::toString).collect(Collectors.toSet());
        return expr != null && expr.matches(tags);
    }

    public static boolean tagsMatch(TagExprParser.MatchExpr expr, FluidStack stack) {
        Set<String> tags = stack.getFluid().m_76145_().m_205075_().map(TagKey::f_203868_).map(ResourceLocation::toString).collect(Collectors.toSet());
        return expr != null && expr.matches(tags);
    }

    public static class TagExprParser {
        List<Token> tokens;
        int idx = 0;
        Token prev = null;

        public MatchExpr parse(String expr) {
            this.tokens = this.tokenize(expr);
            return this.expression();
        }

        private boolean match(TokenType tt) {
            if (this.idx >= this.tokens.size()) {
                return false;
            }
            if (this.tokens.get((int)this.idx).type == tt) {
                this.prev = this.tokens.get(this.idx);
                ++this.idx;
                return true;
            }
            return false;
        }

        private MatchExpr expression() {
            return this.term();
        }

        private MatchExpr term() {
            MatchExpr lhs = this.unary();
            BinExpr result = null;
            while (this.match(TokenType.And) || this.match(TokenType.Or) || this.match(TokenType.Xor)) {
                if (result == null) {
                    result = new BinExpr(this.prev, lhs, this.unary());
                    continue;
                }
                result = new BinExpr(this.prev, result, this.unary());
            }
            if (result != null) {
                return result;
            }
            return lhs;
        }

        private MatchExpr unary() {
            if (this.match(TokenType.Not)) {
                return new UnaryExpr(this.prev, this.id());
            }
            return this.id();
        }

        private MatchExpr id() {
            if (this.match(TokenType.LParen)) {
                MatchExpr inner = this.expression();
                this.match(TokenType.RParen);
                return new GroupingExpr(inner);
            }
            if (this.match(TokenType.String)) {
                return new StringExpr(this.prev.lexeme);
            }
            return null;
        }

        private List<Token> tokenize(String expr) {
            ArrayList<Token> result = new ArrayList<Token>();
            int idx = 0;
            while (idx < expr.length()) {
                char cur = expr.charAt(idx);
                if (Character.isWhitespace(cur)) {
                    ++idx;
                    continue;
                }
                int stringLen = 0;
                while (cur != '(' && cur != ')' && cur != '!' && cur != '&' && cur != '|' && cur != '^' && cur != ' ' && ++stringLen + idx != expr.length()) {
                    cur = expr.charAt(idx + stringLen);
                }
                if (stringLen > 0) {
                    result.add(new Token(TokenType.String, expr.substring(idx, idx + stringLen)));
                    idx += stringLen;
                    continue;
                }
                switch (cur) {
                    case '!': {
                        result.add(new Token(TokenType.Not));
                        break;
                    }
                    case '&': {
                        result.add(new Token(TokenType.And));
                        break;
                    }
                    case '|': {
                        result.add(new Token(TokenType.Or));
                        break;
                    }
                    case '^': {
                        result.add(new Token(TokenType.Xor));
                        break;
                    }
                    case '(': {
                        result.add(new Token(TokenType.LParen));
                        break;
                    }
                    case ')': {
                        result.add(new Token(TokenType.RParen));
                    }
                }
                ++idx;
            }
            return result;
        }

        public static class Token {
            public String lexeme;
            public TokenType type;

            public Token(TokenType type) {
                this.type = type;
            }

            public Token(TokenType type, String lexeme) {
                this.lexeme = lexeme;
                this.type = type;
            }
        }

        public static abstract class MatchExpr {
            public abstract boolean matches(Set<String> var1);
        }

        public static enum TokenType {
            LParen,
            RParen,
            And,
            Or,
            Not,
            Xor,
            String;

        }

        private static class BinExpr
        extends MatchExpr {
            MatchExpr left;
            MatchExpr right;
            Token op;

            public BinExpr(Token op, MatchExpr left, MatchExpr right) {
                this.op = op;
                this.left = left;
                this.right = right;
            }

            @Override
            public boolean matches(Set<String> input) {
                if (this.left == null || this.right == null) {
                    return false;
                }
                return switch (this.op.type) {
                    case TokenType.And -> {
                        if (this.left.matches(input) && this.right.matches(input)) {
                            yield true;
                        }
                        yield false;
                    }
                    case TokenType.Or -> {
                        if (this.left.matches(input) || this.right.matches(input)) {
                            yield true;
                        }
                        yield false;
                    }
                    case TokenType.Xor -> this.left.matches(input) ^ this.right.matches(input);
                    default -> false;
                };
            }
        }

        private static class UnaryExpr
        extends MatchExpr {
            Token token;
            MatchExpr expr;

            public UnaryExpr(Token token, MatchExpr expr) {
                this.token = token;
                this.expr = expr;
            }

            @Override
            public boolean matches(Set<String> input) {
                if (this.token.type == TokenType.Not) {
                    return this.expr != null && !this.expr.matches(input);
                }
                return false;
            }
        }

        private static class GroupingExpr
        extends MatchExpr {
            MatchExpr inner;

            public GroupingExpr(MatchExpr inner) {
                this.inner = inner;
            }

            @Override
            public boolean matches(Set<String> input) {
                return this.inner != null && this.inner.matches(input);
            }
        }

        private static class StringExpr
        extends MatchExpr {
            String value;

            public StringExpr(String value) {
                this.value = value;
            }

            @Override
            public boolean matches(Set<String> input) {
                if (this.value == null || this.value.isEmpty()) {
                    return false;
                }
                if (this.value.equals("$") && input.isEmpty()) {
                    return true;
                }
                if (!this.value.contains(":") && !this.value.startsWith("*")) {
                    this.value = "forge:" + this.value;
                }
                String val = this.quote(this.value);
                return input.stream().anyMatch(inp -> Pattern.matches(val, inp));
            }

            private String quote(String str) {
                if (str.contains("*")) {
                    int idx = str.indexOf("*");
                    if (idx == str.length() - 1) {
                        return this.quote(str.substring(0, idx)) + ".*";
                    }
                    return this.quote(str.substring(0, idx)) + ".*" + this.quote(str.substring(idx + 1));
                }
                return Pattern.quote(str);
            }
        }
    }
}

