/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.recipe.components;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import dev.latvian.mods.kubejs.recipe.InputReplacement;
import dev.latvian.mods.kubejs.recipe.OutputReplacement;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.component.ComponentRole;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import net.minecraft.util.GsonHelper;

public record ContentJS<T>(RecipeComponent<T> baseComponent, RecipeCapability<?> capability, boolean isOutput) implements RecipeComponent<Content>
{
    public ComponentRole role() {
        return this.isOutput ? ComponentRole.OUTPUT : ComponentRole.INPUT;
    }

    public Class<?> componentClass() {
        return Content.class;
    }

    public JsonElement write(RecipeJS recipe, Content value) {
        JsonObject object = new JsonObject();
        object.add("content", this.baseComponent.write(recipe, this.baseComponent.read(recipe, value.content)));
        object.addProperty("chance", (Number)value.chance);
        object.addProperty("maxChance", (Number)value.maxChance);
        object.addProperty("tierChanceBoost", (Number)value.tierChanceBoost);
        return object;
    }

    public Content read(RecipeJS recipe, Object from) {
        if (from instanceof Content) {
            return (Content)from;
        }
        if (from instanceof JsonObject) {
            JsonObject json = (JsonObject)from;
            Object content = this.baseComponent.read(recipe, (Object)json.get("content"));
            int chance = GsonHelper.m_13824_((JsonObject)json, (String)"chance", (int)ChanceLogic.getMaxChancedValue());
            int maxChance = GsonHelper.m_13824_((JsonObject)json, (String)"maxChance", (int)ChanceLogic.getMaxChancedValue());
            int tierChanceBoost = GsonHelper.m_13824_((JsonObject)json, (String)"tierChanceBoost", (int)0);
            return new Content(content, chance, maxChance, tierChanceBoost);
        }
        return null;
    }

    public boolean isInput(RecipeJS recipe, Content value, ReplacementMatch match) {
        return !this.isOutput && this.baseComponent.isInput(recipe, this.baseComponent.read(recipe, value.content), match);
    }

    public boolean isOutput(RecipeJS recipe, Content value, ReplacementMatch match) {
        return this.isOutput && this.baseComponent.isOutput(recipe, this.baseComponent.read(recipe, value.content), match);
    }

    public Content replaceInput(RecipeJS recipe, Content original, ReplacementMatch match, InputReplacement with) {
        return this.isInput(recipe, original, match) ? new Content(this.baseComponent.replaceInput(recipe, this.baseComponent.read(recipe, original.content), match, with), original.chance, original.maxChance, original.tierChanceBoost) : original;
    }

    public Content replaceOutput(RecipeJS recipe, Content original, ReplacementMatch match, OutputReplacement with) {
        return this.isOutput(recipe, original, match) ? new Content(with.replaceOutput(recipe, match, with), original.chance, original.maxChance, original.tierChanceBoost) : original;
    }
}

