/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.helpers;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;

public record MaterialStackWrapper(Supplier<Material> material, long amount) {
    public static MaterialStackWrapper EMPTY = new MaterialStackWrapper(() -> GTMaterials.NULL, 0L);
    private static final Map<String, MaterialStackWrapper> PARSE_CACHE = new WeakHashMap<String, MaterialStackWrapper>();

    public static MaterialStackWrapper fromString(CharSequence str) {
        String trimmed;
        String copy = trimmed = str.toString().trim();
        MaterialStackWrapper cached = PARSE_CACHE.get(trimmed);
        if (cached != null) {
            return cached.copy();
        }
        int count = 1;
        int spaceIndex = copy.indexOf(32);
        if (spaceIndex >= 2 && copy.indexOf(120) == spaceIndex - 1) {
            count = Integer.parseInt(copy.substring(0, spaceIndex - 1));
            copy = copy.substring(spaceIndex + 1);
        }
        String copyFinal = copy;
        Supplier<Material> mat = () -> GTMaterials.get(copyFinal);
        cached = new MaterialStackWrapper(mat, count);
        PARSE_CACHE.put(trimmed, cached);
        return cached.copy();
    }

    public MaterialStackWrapper copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new MaterialStackWrapper(this.material, this.amount);
    }

    public boolean isEmpty() {
        return this.amount < 1L || this.material == null;
    }

    public MaterialStack toMatStack() {
        if (this.isEmpty()) {
            return MaterialStack.EMPTY;
        }
        return new MaterialStack(this.material.get(), this.amount);
    }
}

