/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.research.DataBankMachine;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class DataBankBlockProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public ResourceLocation getUid() {
        return GTCEu.id("data_bank");
    }

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        IMachineBlockEntity blockEntity;
        MetaMachine machine;
        BlockEntity blockEntity2 = blockAccessor.getBlockEntity();
        if (blockEntity2 instanceof IMachineBlockEntity && (machine = (blockEntity = (IMachineBlockEntity)blockEntity2).getMetaMachine()) instanceof DataBankMachine) {
            long energyUsage = blockAccessor.getServerData().m_128454_("energyUsage");
            String energyFormatted = FormattingUtil.formatNumbers(energyUsage);
            MutableComponent voltageName = Component.m_237113_((String)GTValues.VNF[GTUtil.getTierByVoltage(energyUsage)]);
            MutableComponent text = Component.m_237110_((String)"gtceu.multiblock.energy_consumption", (Object[])new Object[]{energyFormatted, voltageName});
            iTooltip.add((Component)text);
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        IMachineBlockEntity blockEntity;
        MetaMachine machine;
        BlockEntity blockEntity2 = blockAccessor.getBlockEntity();
        if (blockEntity2 instanceof IMachineBlockEntity && (machine = (blockEntity = (IMachineBlockEntity)blockEntity2).getMetaMachine()) instanceof DataBankMachine) {
            DataBankMachine dataBank = (DataBankMachine)machine;
            compoundTag.m_128356_("energyUsage", (long)dataBank.getEnergyUsage());
        }
    }
}

