/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine.trait;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerGroupDistinctness;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.integration.ae2.machine.MEPatternBufferPartMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.MEPatternBufferProxyPartMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.trait.InternalSlotRecipeHandler;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public final class ProxySlotRecipeHandler {
    private final List<RecipeHandlerList> proxySlotHandlers;

    public ProxySlotRecipeHandler(MEPatternBufferProxyPartMachine machine, int slots) {
        this.proxySlotHandlers = new ArrayList<RecipeHandlerList>(slots);
        for (int i = 0; i < slots; ++i) {
            this.proxySlotHandlers.add(new ProxyRHL(machine));
        }
    }

    public void updateProxy(MEPatternBufferPartMachine patternBuffer) {
        List<RecipeHandlerList> slotHandlers = patternBuffer.getInternalRecipeHandler().getSlotHandlers();
        for (int i = 0; i < this.proxySlotHandlers.size(); ++i) {
            ProxyRHL proxyRHL = (ProxyRHL)this.proxySlotHandlers.get(i);
            InternalSlotRecipeHandler.SlotRHL slotRHL = (InternalSlotRecipeHandler.SlotRHL)slotHandlers.get(i);
            proxyRHL.setBuffer(patternBuffer, slotRHL);
        }
    }

    public void clearProxy() {
        for (RecipeHandlerList slotHandler : this.proxySlotHandlers) {
            ((ProxyRHL)slotHandler).clearBuffer();
        }
    }

    @Generated
    public List<RecipeHandlerList> getProxySlotHandlers() {
        return this.proxySlotHandlers;
    }

    private static class ProxyRHL
    extends RecipeHandlerList {
        private final ProxyItemRecipeHandler circuit;
        private final ProxyItemRecipeHandler sharedItem;
        private final ProxyItemRecipeHandler slotItem;
        private final ProxyFluidRecipeHandler sharedFluid;
        private final ProxyFluidRecipeHandler slotFluid;

        public ProxyRHL(MEPatternBufferProxyPartMachine machine) {
            super(IO.IN);
            this.circuit = new ProxyItemRecipeHandler(machine);
            this.sharedItem = new ProxyItemRecipeHandler(machine);
            this.slotItem = new ProxyItemRecipeHandler(machine);
            this.sharedFluid = new ProxyFluidRecipeHandler(machine);
            this.slotFluid = new ProxyFluidRecipeHandler(machine);
            this.addHandlers(this.circuit, this.sharedItem, this.slotItem, this.sharedFluid, this.slotFluid);
            this.setGroup(RecipeHandlerGroupDistinctness.BUS_DISTINCT);
        }

        public void setBuffer(MEPatternBufferPartMachine buffer, InternalSlotRecipeHandler.SlotRHL slotRHL) {
            this.circuit.setProxy(buffer.getCircuitInventory());
            this.sharedItem.setProxy(buffer.getShareInventory());
            this.sharedFluid.setProxy(buffer.getShareTank());
            this.slotItem.setProxy(slotRHL.getItemRecipeHandler());
            this.slotFluid.setProxy(slotRHL.getFluidRecipeHandler());
        }

        public void clearBuffer() {
            this.circuit.setProxy(null);
            this.sharedItem.setProxy(null);
            this.sharedFluid.setProxy(null);
            this.slotItem.setProxy(null);
            this.slotFluid.setProxy(null);
        }

        @Override
        public boolean isDistinct() {
            return true;
        }

        @Override
        public void setDistinct(boolean ignored, boolean notify) {
        }
    }

    private static class ProxyFluidRecipeHandler
    extends NotifiableRecipeHandlerTrait<FluidIngredient> {
        private IRecipeHandlerTrait<FluidIngredient> proxy = null;
        private ISubscription proxySub = null;
        private final IO handlerIO = IO.IN;
        private final RecipeCapability<FluidIngredient> capability = FluidRecipeCapability.CAP;
        private final boolean isDistinct = true;

        public ProxyFluidRecipeHandler(MetaMachine machine) {
            super(machine);
        }

        public void setProxy(IRecipeHandlerTrait<FluidIngredient> proxy) {
            this.proxy = proxy;
            if (this.proxySub != null) {
                this.proxySub.unsubscribe();
                this.proxySub = null;
            }
            if (proxy != null) {
                this.proxySub = proxy.addChangedListener(this::notifyListeners);
            }
        }

        @Override
        public List<FluidIngredient> handleRecipeInner(IO io, GTRecipe recipe, List<FluidIngredient> left, boolean simulate) {
            if (this.proxy == null) {
                return left;
            }
            return this.proxy.handleRecipeInner(io, recipe, left, simulate);
        }

        @Override
        public int getSize() {
            if (this.proxy == null) {
                return 0;
            }
            return this.proxy.getSize();
        }

        @Override
        @NotNull
        public List<Object> getContents() {
            if (this.proxy == null) {
                return Collections.emptyList();
            }
            return this.proxy.getContents();
        }

        @Override
        public double getTotalContentAmount() {
            if (this.proxy == null) {
                return 0.0;
            }
            return this.proxy.getTotalContentAmount();
        }

        @Override
        public int getPriority() {
            if (this.proxy == null) {
                return -1073741824;
            }
            return this.proxy.getPriority();
        }

        @Generated
        public IRecipeHandlerTrait<FluidIngredient> getProxy() {
            return this.proxy;
        }

        @Generated
        public ISubscription getProxySub() {
            return this.proxySub;
        }

        @Override
        @Generated
        public IO getHandlerIO() {
            return this.handlerIO;
        }

        @Override
        @Generated
        public RecipeCapability<FluidIngredient> getCapability() {
            return this.capability;
        }

        @Override
        @Generated
        public boolean isDistinct() {
            return this.isDistinct;
        }
    }

    private static class ProxyItemRecipeHandler
    extends NotifiableRecipeHandlerTrait<Ingredient> {
        private IRecipeHandlerTrait<Ingredient> proxy = null;
        private ISubscription proxySub = null;
        private final IO handlerIO = IO.IN;
        private final RecipeCapability<Ingredient> capability = ItemRecipeCapability.CAP;
        private final boolean isDistinct = true;

        public ProxyItemRecipeHandler(MetaMachine machine) {
            super(machine);
        }

        public void setProxy(IRecipeHandlerTrait<Ingredient> proxy) {
            this.proxy = proxy;
            if (this.proxySub != null) {
                this.proxySub.unsubscribe();
                this.proxySub = null;
            }
            if (proxy != null) {
                this.proxySub = proxy.addChangedListener(this::notifyListeners);
            }
        }

        @Override
        public List<Ingredient> handleRecipeInner(IO io, GTRecipe recipe, List<Ingredient> left, boolean simulate) {
            if (this.proxy == null) {
                return left;
            }
            return this.proxy.handleRecipeInner(io, recipe, left, simulate);
        }

        @Override
        public int getSize() {
            if (this.proxy == null) {
                return 0;
            }
            return this.proxy.getSize();
        }

        @Override
        @NotNull
        public List<Object> getContents() {
            if (this.proxy == null) {
                return Collections.emptyList();
            }
            return this.proxy.getContents();
        }

        @Override
        public double getTotalContentAmount() {
            if (this.proxy == null) {
                return 0.0;
            }
            return this.proxy.getTotalContentAmount();
        }

        @Override
        public int getPriority() {
            if (this.proxy == null) {
                return -1073741824;
            }
            return this.proxy.getPriority();
        }

        @Generated
        public IRecipeHandlerTrait<Ingredient> getProxy() {
            return this.proxy;
        }

        @Generated
        public ISubscription getProxySub() {
            return this.proxySub;
        }

        @Override
        @Generated
        public IO getHandlerIO() {
            return this.handlerIO;
        }

        @Override
        @Generated
        public RecipeCapability<Ingredient> getCapability() {
            return this.capability;
        }

        @Override
        @Generated
        public boolean isDistinct() {
            return this.isDistinct;
        }
    }
}

