/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.generated;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterials;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.AlloyBlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.BlastProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.IngotProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterialBlocks;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeCategories;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MaterialRecipeHandler {
    private MaterialRecipeHandler() {
    }

    public static void run(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        MaterialRecipeHandler.processIngot(provider, material);
        MaterialRecipeHandler.processNugget(provider, material);
        MaterialRecipeHandler.processBlock(provider, material);
        MaterialRecipeHandler.processFrame(provider, material);
        MaterialRecipeHandler.processDust(provider, material);
        MaterialRecipeHandler.processSmallDust(provider, material);
        MaterialRecipeHandler.processTinyDust(provider, material);
        if (ConfigHolder.INSTANCE.recipes.generateLowQualityGems) {
            MaterialRecipeHandler.processGemConversion(provider, TagPrefix.gemChipped, null, material);
            MaterialRecipeHandler.processGemConversion(provider, TagPrefix.gemFlawed, TagPrefix.gemChipped, material);
            MaterialRecipeHandler.processGemConversion(provider, TagPrefix.gem, TagPrefix.gemFlawed, material);
        } else {
            MaterialRecipeHandler.processGemConversion(provider, TagPrefix.gem, null, material);
        }
        MaterialRecipeHandler.processGemConversion(provider, TagPrefix.gemFlawless, TagPrefix.gem, material);
        MaterialRecipeHandler.processGemConversion(provider, TagPrefix.gemExquisite, TagPrefix.gemFlawless, material);
        MaterialRecipeHandler.generateSurfaceRockRecipe(provider, material);
    }

    private static void processDust(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        OreProperty oreProperty;
        if (!material.shouldGenerateRecipesFor(TagPrefix.dust) || !material.hasProperty(PropertyKey.DUST)) {
            return;
        }
        String id = "dust_%s".formatted(material.getName().toLowerCase(Locale.ROOT));
        ItemStack dustStack = ChemicalHelper.get(TagPrefix.dust, material);
        OreProperty oreProperty2 = oreProperty = material.hasProperty(PropertyKey.ORE) ? material.getProperty(PropertyKey.ORE) : null;
        if (material.hasProperty(PropertyKey.GEM)) {
            Material smeltingResult;
            ItemStack gemStack = ChemicalHelper.get(TagPrefix.gem, material);
            if (material.hasFlag(MaterialFlags.CRYSTALLIZABLE)) {
                GTRecipeTypes.AUTOCLAVE_RECIPES.recipeBuilder("autoclave_" + id + "_water").inputItems(dustStack).inputFluids(GTMaterials.Water.getFluid(250)).chancedOutput(gemStack, 7500, 0).duration(1200).EUt(24L).save(provider);
                GTRecipeTypes.AUTOCLAVE_RECIPES.recipeBuilder("autoclave_" + id + "_distilled").inputItems(dustStack).inputFluids(GTMaterials.DistilledWater.getFluid(50)).outputItems(gemStack).duration(600).EUt(24L).save(provider);
            }
            if (!material.hasFlag(MaterialFlags.EXPLOSIVE) && !material.hasFlag(MaterialFlags.FLAMMABLE)) {
                GTRecipeTypes.IMPLOSION_RECIPES.recipeBuilder("implode_" + id + "_powderbarrel").inputItems(dustStack.m_255036_(4)).outputItems(gemStack.m_255036_(3)).chancedOutput(TagPrefix.dust, GTMaterials.DarkAsh, 2500, 0).explosivesType(new ItemStack(GTBlocks.POWDERBARREL, 8)).save(provider);
                GTRecipeTypes.IMPLOSION_RECIPES.recipeBuilder("implode_" + id + "_tnt").inputItems(dustStack.m_255036_(4)).outputItems(gemStack.m_255036_(3)).chancedOutput(TagPrefix.dust, GTMaterials.DarkAsh, 2500, 0).explosivesAmount(4).save(provider);
                GTRecipeTypes.IMPLOSION_RECIPES.recipeBuilder("implode_" + id + "_dynamite").inputItems(dustStack.m_255036_(4)).outputItems(gemStack.m_255036_(3)).chancedOutput(TagPrefix.dust, GTMaterials.DarkAsh, 2500, 0).explosivesType(GTItems.DYNAMITE.asStack(2)).save(provider);
                GTRecipeTypes.IMPLOSION_RECIPES.recipeBuilder("implode_" + id + "_itnt").inputItems(dustStack.m_255036_(4)).outputItems(gemStack.m_255036_(3)).chancedOutput(TagPrefix.dust, GTMaterials.DarkAsh, 2500, 0).explosivesType(new ItemStack(GTBlocks.INDUSTRIAL_TNT)).save(provider);
            }
            if (oreProperty != null && !(smeltingResult = oreProperty.getDirectSmeltResult()).isNull()) {
                VanillaRecipeHelper.addSmeltingRecipe(provider, id + "_ingot", ChemicalHelper.getTag(TagPrefix.dust, material), ChemicalHelper.get(TagPrefix.ingot, smeltingResult));
            }
        } else if (material.hasProperty(PropertyKey.INGOT)) {
            if (!material.hasAnyOfFlags(MaterialFlags.FLAMMABLE, MaterialFlags.NO_SMELTING)) {
                int blastTemp;
                Material smeltingResult;
                boolean hasHotIngot = TagPrefix.ingotHot.doGenerateItem(material);
                ItemStack ingotStack = ChemicalHelper.get(hasHotIngot ? TagPrefix.ingotHot : TagPrefix.ingot, material);
                if (ingotStack.m_41619_() && oreProperty != null && !(smeltingResult = oreProperty.getDirectSmeltResult()).isNull()) {
                    ingotStack = ChemicalHelper.get(TagPrefix.ingot, smeltingResult);
                }
                if ((blastTemp = material.getBlastTemperature()) <= 0) {
                    if (!material.hasFlag(MaterialFlags.IS_MAGNETIC)) {
                        VanillaRecipeHelper.addSmeltingRecipe(provider, "smelt_" + id + "_to_ingot", ChemicalHelper.getTag(TagPrefix.dust, material), ingotStack);
                    }
                } else {
                    IngotProperty ingotProperty = material.getProperty(PropertyKey.INGOT);
                    BlastProperty blastProperty = material.getProperty(PropertyKey.BLAST);
                    MaterialRecipeHandler.processEBFRecipe(material, blastProperty, ingotStack, provider);
                    if (!ingotProperty.getMagneticMaterial().isNull()) {
                        MaterialRecipeHandler.processEBFRecipe(ingotProperty.getMagneticMaterial(), blastProperty, ingotStack, provider);
                    }
                }
            }
        } else {
            ItemStack ingotStack;
            Material smeltingResult;
            if (material.hasFlag(MaterialFlags.GENERATE_PLATE) && !material.hasFlag(MaterialFlags.EXCLUDE_PLATE_COMPRESSOR_RECIPE)) {
                GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("compress_plate_" + id).inputItems(dustStack).outputItems(TagPrefix.plate, material).save(provider);
            }
            if (oreProperty != null && !(smeltingResult = oreProperty.getDirectSmeltResult()).isNull() && !(ingotStack = ChemicalHelper.get(TagPrefix.ingot, smeltingResult)).m_41619_()) {
                VanillaRecipeHelper.addSmeltingRecipe(provider, "smelt_" + id + "_to_ingot", ChemicalHelper.getTag(TagPrefix.dust, material), ingotStack);
            }
        }
    }

    private static void processEBFRecipe(Material material, BlastProperty property, ItemStack output, Consumer<FinishedRecipe> provider) {
        AlloyBlastProperty alloyBlastProperty;
        int EUt;
        int blastTemp = property.getBlastTemperature();
        BlastProperty.GasTier gasTier = property.getGasTier();
        int duration = property.getDurationOverride();
        if (duration <= 0) {
            duration = Math.max(1, (int)(material.getMass() * (long)blastTemp / 50L));
        }
        if ((EUt = property.getEUtOverride()) <= 0) {
            EUt = GTValues.VA[2];
        }
        GTRecipeBuilder blastBuilder = GTRecipeTypes.BLAST_RECIPES.recipeBuilder("blast_" + material.getName()).inputItems(TagPrefix.dust, material).outputItems(output).blastFurnaceTemp(blastTemp).EUt(EUt);
        if (gasTier != null) {
            FluidIngredient gas = gasTier.getFluid();
            blastBuilder.copy("blast_" + material.getName()).circuitMeta(1).duration(duration).save(provider);
            blastBuilder.copy("blast_" + material.getName() + "_gas").circuitMeta(2).inputFluids(gas).duration((int)((double)duration * 0.67)).save(provider);
        } else {
            blastBuilder.duration(duration);
            if (material == GTMaterials.Silicon) {
                blastBuilder.circuitMeta(1);
            }
            blastBuilder.save(provider);
        }
        if (TagPrefix.ingotHot.doGenerateItem(material)) {
            int vacuumDuration;
            int vacuumEUt = property.getVacuumEUtOverride() != -1 ? property.getVacuumEUtOverride() : GTValues.VA[2];
            int n = vacuumDuration = property.getVacuumDurationOverride() != -1 ? property.getVacuumDurationOverride() : (int)material.getMass() * 3;
            if (blastTemp < 5000) {
                GTRecipeTypes.VACUUM_RECIPES.recipeBuilder("cool_hot_" + material.getName() + "_ingot").inputItems(TagPrefix.ingotHot, material).outputItems(TagPrefix.ingot, material).duration(vacuumDuration).EUt(vacuumEUt).save(provider);
            } else {
                GTRecipeTypes.VACUUM_RECIPES.recipeBuilder("cool_hot_" + material.getName() + "_ingot").inputItems(TagPrefix.ingotHot, material).inputFluids(GTMaterials.Helium.getFluid(FluidStorageKeys.LIQUID, 500)).outputItems(TagPrefix.ingot, material).outputFluids(GTMaterials.Helium.getFluid(250)).duration(vacuumDuration).EUt(vacuumEUt).save(provider);
            }
        }
        if ((alloyBlastProperty = material.getProperty(PropertyKey.ALLOY_BLAST)) != null) {
            alloyBlastProperty.getRecipeProducer().produce(material, property, provider);
        }
    }

    private static void processSmallDust(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.dustSmall) || !material.hasProperty(PropertyKey.DUST)) {
            return;
        }
        ItemStack smallDustStack = ChemicalHelper.get(TagPrefix.dustSmall, material);
        ItemStack dustStack = ChemicalHelper.get(TagPrefix.dust, material);
        VanillaRecipeHelper.addStrictShapedRecipe(provider, String.format("small_dust_disassembling_%s", material.getName()), smallDustStack.m_255036_(4), " X", "  ", Character.valueOf('X'), new MaterialEntry(TagPrefix.dust, material));
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("small_dust_assembling_%s", material.getName()), dustStack, "XX", "XX", Character.valueOf('X'), new MaterialEntry(TagPrefix.dustSmall, material));
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("package_" + material.getName() + "_small_dust").inputItems(TagPrefix.dustSmall, material, 4).circuitMeta(1).outputItems(dustStack).save(provider);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("unpackage_" + material.getName() + "_small_dust").inputItems(TagPrefix.dust, material).circuitMeta(2).outputItems(smallDustStack.m_255036_(4)).save(provider);
    }

    private static void processTinyDust(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.dustTiny) || !material.hasProperty(PropertyKey.DUST)) {
            return;
        }
        ItemStack tinyDustStack = ChemicalHelper.get(TagPrefix.dustTiny, material);
        ItemStack dustStack = ChemicalHelper.get(TagPrefix.dust, material);
        VanillaRecipeHelper.addStrictShapedRecipe(provider, String.format("tiny_dust_disassembling_%s", material.getName()), tinyDustStack.m_255036_(9), "X ", "  ", Character.valueOf('X'), new MaterialEntry(TagPrefix.dust, material));
        VanillaRecipeHelper.addShapedRecipe(provider, String.format("tiny_dust_assembling_%s", material.getName()), dustStack, "XXX", "XXX", "XXX", Character.valueOf('X'), new MaterialEntry(TagPrefix.dustTiny, material));
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("package_" + material.getName() + "_tiny_dust").inputItems(TagPrefix.dustTiny, material, 9).circuitMeta(1).outputItems(dustStack).save(provider);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("unpackage_" + material.getName() + "_tiny_dust").inputItems(TagPrefix.dust, material).circuitMeta(1).outputItems(tinyDustStack.m_255036_(9)).save(provider);
    }

    private static void processIngot(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        FluidStack stack;
        Material magMaterial;
        if (!material.shouldGenerateRecipesFor(TagPrefix.ingot) || !material.hasProperty(PropertyKey.INGOT)) {
            return;
        }
        if (material.hasFlag(MaterialFlags.MORTAR_GRINDABLE)) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("mortar_grind_%s", material.getName()), ChemicalHelper.get(TagPrefix.dust, material), "X", "m", Character.valueOf('X'), new MaterialEntry(TagPrefix.ingot, material));
        }
        Material material2 = magMaterial = material.hasFlag(MaterialFlags.IS_MAGNETIC) ? material.getProperty(PropertyKey.INGOT).getMacerateInto() : material;
        if (material.hasFlag(MaterialFlags.GENERATE_ROD)) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("stick_%s", material.getName()), ChemicalHelper.get(TagPrefix.rod, magMaterial), "f ", " X", Character.valueOf('X'), new MaterialEntry(TagPrefix.ingot, material));
            if (!material.hasFlag(MaterialFlags.NO_WORKING)) {
                GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_to_rod").inputItems(TagPrefix.ingot, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_ROD).outputItems(TagPrefix.rod, magMaterial, 2).duration((int)material.getMass() * 2).EUt(6L * (long)MaterialRecipeHandler.getVoltageMultiplier(material)).save(provider);
            }
        }
        if (material.hasFluid() && !(stack = material.getProperty(PropertyKey.FLUID).solidifiesFrom(144)).isEmpty()) {
            GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_to_ingot").notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_INGOT).inputFluids(stack).outputItems(TagPrefix.ingot, material).duration(20).EUt(GTValues.VA[0]).save(provider);
        }
        if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
            GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_to_ingot").inputItems(TagPrefix.dust, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_INGOT).outputItems(TagPrefix.ingot, magMaterial).duration(10).EUt(4L * (long)MaterialRecipeHandler.getVoltageMultiplier(material)).save(provider);
        }
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("alloy_smelt_" + material.getName() + "_to_nugget").EUt(GTValues.VA[0]).duration((int)material.getMass()).inputItems(TagPrefix.ingot, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_NUGGET).outputItems(TagPrefix.nugget, magMaterial, 9).category(GTRecipeCategories.INGOT_MOLDING).save(provider);
        if (!ChemicalHelper.get(TagPrefix.block, material).m_41619_()) {
            GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("alloy_smelt_" + material.getName() + "_to_ingot").EUt(GTValues.VA[0]).duration((int)material.getMass() * (int)(TagPrefix.block.getMaterialAmount(material) / 3628800L)).inputItems(TagPrefix.block, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_INGOT).outputItems(TagPrefix.ingot, magMaterial, (int)(TagPrefix.block.getMaterialAmount(material) / 3628800L)).category(GTRecipeCategories.INGOT_MOLDING).save(provider);
            GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("compress_" + material.getName() + "_to_block").EUt(2L).duration(300).inputItems(TagPrefix.ingot, material, (int)(TagPrefix.block.getMaterialAmount(material) / 3628800L)).outputItems(TagPrefix.block, magMaterial).save(provider);
        }
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE) && !material.hasFlag(MaterialFlags.NO_WORKING)) {
            ItemStack plateStack;
            if (!material.hasFlag(MaterialFlags.NO_SMASHING) && !(plateStack = ChemicalHelper.get(TagPrefix.plate, material.hasFlag(MaterialFlags.IS_MAGNETIC) ? material.getProperty(PropertyKey.INGOT).getMacerateInto() : material)).m_41619_()) {
                GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bend_" + material.getName() + "_to_plate").circuitMeta(1).inputItems(TagPrefix.ingot, material).outputItems(plateStack).EUt(24L).duration((int)material.getMass()).save(provider);
                GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + material.getName() + "_to_plate").inputItems(TagPrefix.ingot, material, 3).outputItems(plateStack.m_255036_(2)).EUt(16L).duration((int)material.getMass()).save(provider);
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("plate_%s", material.getName()), plateStack, "h", "I", "I", Character.valueOf('I'), new MaterialEntry(TagPrefix.ingot, material));
            }
            int voltageMultiplier = MaterialRecipeHandler.getVoltageMultiplier(material);
            if (!ChemicalHelper.get(TagPrefix.plate, material).m_41619_()) {
                GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_to_plate").inputItems(TagPrefix.ingot, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PLATE).outputItems(TagPrefix.plate, magMaterial).duration((int)material.getMass()).EUt(8L * (long)voltageMultiplier).save(provider);
                if (material.hasFlag(MaterialFlags.NO_SMASHING)) {
                    GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_dust_to_plate").inputItems(TagPrefix.dust, material).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_PLATE).outputItems(TagPrefix.plate, magMaterial).duration((int)material.getMass()).EUt(8L * (long)voltageMultiplier).save(provider);
                }
            }
        }
    }

    private static void processGemConversion(@NotNull Consumer<FinishedRecipe> provider, @NotNull TagPrefix prefix, @Nullable TagPrefix lowerPrefix, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(prefix) || !material.hasProperty(PropertyKey.GEM)) {
            return;
        }
        long materialAmount = prefix.getMaterialAmount(material);
        ItemStack crushedStack = ChemicalHelper.getDust(material, materialAmount);
        if (material.hasFlag(MaterialFlags.MORTAR_GRINDABLE)) {
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("gem_to_dust_%s_%s", material.getName(), FormattingUtil.toLowerCaseUnderscore(prefix.name)), crushedStack, "X", "m", Character.valueOf('X'), new MaterialEntry(prefix, material));
        }
        if (lowerPrefix == null) {
            return;
        }
        ItemStack prevStack = ChemicalHelper.get(lowerPrefix, material, 2);
        if (prevStack.m_41619_()) {
            return;
        }
        VanillaRecipeHelper.addShapelessRecipe(provider, String.format("gem_to_gem_%s_%s", FormattingUtil.toLowerCaseUnderscore(lowerPrefix.name), material.getName()), prevStack, Character.valueOf('h'), new MaterialEntry(prefix, material));
        GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + material.getName() + "_" + FormattingUtil.toLowerCaseUnderscore(prefix.name) + "_to_" + FormattingUtil.toLowerCaseUnderscore(lowerPrefix.name)).inputItems(prefix, material).outputItems(prevStack).duration(20).EUt(16L).save(provider);
        GTRecipeTypes.LASER_ENGRAVER_RECIPES.recipeBuilder("engrave_" + material.getName() + "_" + FormattingUtil.toLowerCaseUnderscore(prefix.name) + "_to_" + FormattingUtil.toLowerCaseUnderscore(lowerPrefix.name)).inputItems(prevStack).notConsumable(TagPrefix.lens, MarkerMaterials.Color.White).outputItems(prefix, material).duration(300).EUt(240L).save(provider);
    }

    private static void processNugget(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.nugget) || !material.hasProperty(PropertyKey.DUST)) {
            return;
        }
        ItemStack nuggetStack = ChemicalHelper.get(TagPrefix.nugget, material);
        if (material.hasProperty(PropertyKey.INGOT)) {
            FluidStack stack;
            ItemStack ingotStack = ChemicalHelper.get(TagPrefix.ingot, material.hasFlag(MaterialFlags.IS_MAGNETIC) ? material.getProperty(PropertyKey.INGOT).getMacerateInto() : material);
            if (!ConfigHolder.INSTANCE.recipes.disableManualCompression) {
                if (!TagPrefix.ingot.isIgnored(material)) {
                    VanillaRecipeHelper.addShapelessRecipe(provider, String.format("nugget_disassembling_%s", material.getName()), nuggetStack.m_255036_(9), new MaterialEntry(TagPrefix.ingot, material));
                }
                if (!TagPrefix.nugget.isIgnored(material)) {
                    VanillaRecipeHelper.addShapedRecipe(provider, String.format("nugget_assembling_%s", material.getName()), ingotStack, "XXX", "XXX", "XXX", Character.valueOf('X'), new MaterialEntry(TagPrefix.nugget, material));
                }
            }
            GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("compress_" + material.getName() + "_nugget_to_ingot").inputItems(TagPrefix.nugget, material, 9).outputItems(ingotStack).EUt(2L).duration(300).save(provider);
            GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("alloy_smelt_" + material.getName() + "_nugget_to_ingot").EUt(GTValues.VA[0]).duration((int)material.getMass()).inputItems(TagPrefix.nugget, material, 9).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_INGOT).outputItems(ingotStack).category(GTRecipeCategories.INGOT_MOLDING).save(provider);
            if (material.hasFluid() && !(stack = material.getProperty(PropertyKey.FLUID).solidifiesFrom(144)).isEmpty()) {
                GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_to_nugget").notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_NUGGET).inputFluids(stack).outputItems(TagPrefix.nugget, material, 9).duration((int)material.getMass()).EUt(GTValues.VA[0]).save(provider);
            }
        } else if (material.hasProperty(PropertyKey.GEM)) {
            ItemStack gemStack = ChemicalHelper.get(TagPrefix.gem, material);
            if (!ConfigHolder.INSTANCE.recipes.disableManualCompression) {
                if (!TagPrefix.gem.isIgnored(material)) {
                    VanillaRecipeHelper.addShapelessRecipe(provider, String.format("nugget_disassembling_%s", material.getName()), nuggetStack.m_255036_(9), new MaterialEntry(TagPrefix.gem, material));
                }
                if (!TagPrefix.nugget.isIgnored(material)) {
                    VanillaRecipeHelper.addShapedRecipe(provider, String.format("nugget_assembling_%s", material.getName()), gemStack, "XXX", "XXX", "XXX", Character.valueOf('X'), new MaterialEntry(TagPrefix.nugget, material));
                }
            }
        }
    }

    private static void processFrame(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        if (!material.shouldGenerateRecipesFor(TagPrefix.frameGt) || !material.hasProperty(PropertyKey.DUST)) {
            return;
        }
        if (material.hasFlag(MaterialFlags.GENERATE_FRAME)) {
            boolean isWoodenFrame = material.hasProperty(PropertyKey.WOOD);
            VanillaRecipeHelper.addShapedRecipe(provider, String.format("frame_%s", material.getName()), ChemicalHelper.get(TagPrefix.frameGt, material, 2), "SSS", isWoodenFrame ? "SsS" : "SwS", "SSS", Character.valueOf('S'), new MaterialEntry(TagPrefix.rod, material));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("assemble_" + material.getName() + "_frame").inputItems(TagPrefix.rod, material, 4).circuitMeta(4).outputItems(TagPrefix.frameGt, material).EUt(GTValues.VA[0]).duration(64).save(provider);
        }
    }

    private static void processBlock(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        ItemStack plateStack;
        FluidStack stack;
        if (!material.shouldGenerateRecipesFor(TagPrefix.block) || !material.hasProperty(PropertyKey.DUST)) {
            return;
        }
        ItemStack blockStack = ChemicalHelper.get(TagPrefix.block, material.hasFlag(MaterialFlags.IS_MAGNETIC) ? material.getProperty(PropertyKey.INGOT).getMacerateInto() : material);
        long materialAmount = TagPrefix.block.getMaterialAmount(material);
        if (material.hasFluid() && !(stack = material.getProperty(PropertyKey.FLUID).solidifiesFrom((int)(materialAmount * 144L / 3628800L))).isEmpty()) {
            GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_" + material.getName() + "_block").notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BLOCK).inputFluids(stack).outputItems(blockStack).duration((int)material.getMass()).EUt(GTValues.VA[0]).save(provider);
        }
        if (material.hasFlag(MaterialFlags.GENERATE_PLATE) && !(plateStack = ChemicalHelper.get(TagPrefix.plate, material.hasFlag(MaterialFlags.IS_MAGNETIC) ? material.getProperty(PropertyKey.INGOT).getMacerateInto() : material)).m_41619_()) {
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + material.getName() + "_block_to_plate").inputItems(TagPrefix.block, material).outputItems(plateStack.m_255036_((int)(materialAmount / 3628800L))).duration((int)(material.getMass() * 8L)).EUt(GTValues.VA[1]).save(provider);
        }
        MaterialEntry blockEntry = material.hasProperty(PropertyKey.GEM) ? new MaterialEntry(TagPrefix.gem, material) : (material.hasProperty(PropertyKey.INGOT) ? new MaterialEntry(TagPrefix.ingot, material) : new MaterialEntry(TagPrefix.dust, material));
        if (!material.hasFlag(MaterialFlags.EXCLUDE_BLOCK_CRAFTING_RECIPES)) {
            int size = (int)(materialAmount / 3628800L);
            int sizeSqrt = Math.round(Mth.m_14116_((float)size));
            if (!(material.hasFlag(MaterialFlags.EXCLUDE_BLOCK_CRAFTING_BY_HAND_RECIPES) || ConfigHolder.INSTANCE.recipes.disableManualCompression || sizeSqrt * sizeSqrt != size || TagPrefix.block.isIgnored(material))) {
                String patternString = "B".repeat(Math.max(0, sizeSqrt));
                Object[] pattern = new String[sizeSqrt];
                Arrays.fill(pattern, patternString);
                VanillaRecipeHelper.addShapedRecipe(provider, String.format("block_compress_%s", material.getName()), blockStack, pattern, Character.valueOf('B'), blockEntry);
                VanillaRecipeHelper.addShapelessRecipe(provider, String.format("block_decompress_%s", material.getName()), ChemicalHelper.get(blockEntry.tagPrefix(), blockEntry.material()).m_255036_(size), new MaterialEntry(TagPrefix.block, material));
            }
            if (material.hasProperty(PropertyKey.INGOT)) {
                Material nonMagneticMaterial;
                int voltageMultiplier = MaterialRecipeHandler.getVoltageMultiplier(material);
                GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("extrude_" + material.getName() + "_ingot_to_block").inputItems(TagPrefix.ingot, material, (int)(materialAmount / 3628800L)).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_BLOCK).outputItems(blockStack).duration(10).EUt(8L * (long)voltageMultiplier).save(provider);
                GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("alloy_smelt_" + material.getName() + "_ingot_to_block").inputItems(TagPrefix.ingot, material, (int)(materialAmount / 3628800L)).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BLOCK).outputItems(blockStack).duration(5).EUt(4L * (long)voltageMultiplier).category(GTRecipeCategories.INGOT_MOLDING).save(provider);
                Material material2 = nonMagneticMaterial = material.hasFlag(MaterialFlags.IS_MAGNETIC) ? material.getProperty(PropertyKey.INGOT).getSmeltingInto() : material;
                if (!nonMagneticMaterial.hasProperty(PropertyKey.BLAST)) {
                    GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("alloy_smelt_" + material.getName() + "_dust_to_block").inputItems(TagPrefix.dust, material, (int)(materialAmount / 3628800L)).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BLOCK).outputItems(blockStack).duration(20).EUt(4L * (long)voltageMultiplier).category(GTRecipeCategories.INGOT_MOLDING).save(provider);
                }
            } else if (material.hasProperty(PropertyKey.GEM)) {
                GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("compress_" + material.getName() + "_gem_to_block").inputItems(TagPrefix.gem, material, (int)(TagPrefix.block.getMaterialAmount(material) / 3628800L)).outputItems(TagPrefix.block, material).duration(300).EUt(2L).save(provider);
                GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("hammer_" + material.getName() + "_block_to_gem").inputItems(TagPrefix.block, material).outputItems(TagPrefix.gem, material, (int)(TagPrefix.block.getMaterialAmount(material) / 3628800L)).duration(100).EUt(24L).save(provider);
            }
        }
    }

    private static void generateSurfaceRockRecipe(@NotNull Consumer<FinishedRecipe> provider, @NotNull Material material) {
        if (material.hasProperty(PropertyKey.ORE)) {
            VanillaRecipeHelper.addShapedRecipe(provider, "%s_surface_indicator".formatted(material.getName()), GTMaterialBlocks.SURFACE_ROCK_BLOCKS.get(material).asStack(2), "DDD", "DGD", "DDD", Character.valueOf('D'), ChemicalHelper.get(TagPrefix.dustSmall, material), Character.valueOf('G'), Items.f_41832_);
        }
    }

    private static int getVoltageMultiplier(Material material) {
        return material.getBlastTemperature() >= 2800 ? GTValues.VA[1] : GTValues.VA[0];
    }
}

