/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core.mixins.ftbchunks;

import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.map.ButtonState;
import com.gregtechceu.gtceu.integration.map.ftbchunks.FTBChunksOptions;
import dev.ftb.mods.ftbchunks.client.gui.LargeMapScreen;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LargeMapScreen.class}, remap=false)
public abstract class LargeMapScreenMixin
extends BaseScreen {
    @Unique
    private final List<Button> gtceu$injectedWidgets = new ArrayList<Button>();

    @Inject(method={"addWidgets"}, at={@At(value="TAIL")})
    private void gtceu$injectAddWidgets(CallbackInfo ci) {
        if (!ConfigHolder.INSTANCE.compat.minimap.toggle.ftbChunksIntegration) {
            return;
        }
        this.gtceu$injectedWidgets.clear();
        final String prefix = "gtceu.button.";
        for (ButtonState.Button button : ButtonState.getAllButtons()) {
            Icon icon = switch (button.name) {
                case "ore_veins" -> ItemIcon.getItemIcon((Item)Items.f_151050_);
                case "bedrock_fluids" -> ItemIcon.getItemIcon((Item)Items.f_42446_);
                default -> Icons.INFO;
            };
            SimpleButton buttonWidget = new SimpleButton((Panel)this, (Component)Component.m_237115_((String)(prefix + button.name)), icon, (b, m) -> {
                ButtonState.toggleButton(button);
                this.refreshWidgets();
            });
            this.add((Widget)buttonWidget);
            this.gtceu$injectedWidgets.add((Button)buttonWidget);
        }
        SimpleButton hideDepletedButton = new SimpleButton((Panel)this, (Component)Component.m_237115_((String)"gtceu.button.hide_depleted"), ItemIcon.getItemIcon((Item)Items.f_151059_), (b, m) -> FTBChunksOptions.toggleLayer("hide_depleted", !FTBChunksOptions.showLayer("hide_depleted"))){

            public void addMouseOverText(TooltipList list) {
                String lang = prefix + (FTBChunksOptions.hideDepleted() ? "show_depleted" : "hide_depleted");
                list.add((Component)Component.m_237115_((String)lang));
            }
        };
        this.add((Widget)hideDepletedButton);
        this.gtceu$injectedWidgets.add((Button)hideDepletedButton);
    }

    @Inject(method={"alignWidgets"}, at={@At(value="TAIL")})
    private void gtceu$injectAlignWidgets(CallbackInfo ci) {
        if (!ConfigHolder.INSTANCE.compat.minimap.toggle.ftbChunksIntegration) {
            return;
        }
        int buttonCount = this.gtceu$injectedWidgets.size();
        int startHeight = (this.height - buttonCount * 18) / 2;
        for (int i = 0; i < buttonCount; ++i) {
            Button buttonWidget = this.gtceu$injectedWidgets.get(i);
            buttonWidget.setPosAndSize(1, startHeight + i * 18, 16, 16);
        }
    }
}

