/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.duct;

import com.gregtechceu.gtceu.api.pipenet.LevelPipeNet;
import com.gregtechceu.gtceu.api.pipenet.Node;
import com.gregtechceu.gtceu.api.pipenet.PipeNet;
import com.gregtechceu.gtceu.common.pipelike.duct.DuctNetWalker;
import com.gregtechceu.gtceu.common.pipelike.duct.DuctPipeProperties;
import com.gregtechceu.gtceu.common.pipelike.duct.DuctRoutePath;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;

public class DuctPipeNet
extends PipeNet<DuctPipeProperties> {
    private final Map<BlockPos, List<DuctRoutePath>> NET_DATA = new HashMap<BlockPos, List<DuctRoutePath>>();

    public DuctPipeNet(LevelPipeNet<DuctPipeProperties, ? extends PipeNet<DuctPipeProperties>> world) {
        super(world);
    }

    public List<DuctRoutePath> getNetData(BlockPos pipePos, Direction facing) {
        List<DuctRoutePath> data = this.NET_DATA.get(pipePos);
        if (data == null) {
            data = DuctNetWalker.createNetData(this, pipePos, facing);
            if (data == null) {
                return Collections.emptyList();
            }
            this.NET_DATA.put(pipePos, data);
        }
        return data;
    }

    @Override
    public void onNeighbourUpdate(BlockPos fromPos) {
        this.NET_DATA.clear();
    }

    @Override
    public void onPipeConnectionsUpdate() {
        this.NET_DATA.clear();
    }

    @Override
    protected void transferNodeData(Map<BlockPos, Node<DuctPipeProperties>> transferredNodes, PipeNet<DuctPipeProperties> parentNet) {
        super.transferNodeData(transferredNodes, parentNet);
        this.NET_DATA.clear();
        ((DuctPipeNet)parentNet).NET_DATA.clear();
    }

    @Override
    protected void writeNodeData(DuctPipeProperties nodeData, CompoundTag tagCompound) {
        tagCompound.m_128350_("Rate", nodeData.getTransferRate());
    }

    @Override
    protected DuctPipeProperties readNodeData(CompoundTag tagCompound) {
        return new DuctPipeProperties(tagCompound.m_128457_("Rate"));
    }
}

