/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.FluidTankProxyTrait;
import com.gregtechceu.gtceu.api.machine.trait.ItemHandlerProxyTrait;
import com.gregtechceu.gtceu.common.machine.multiblock.primitive.CokeOvenMachine;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CokeOvenHatch
extends MultiblockPartMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(CokeOvenHatch.class, MultiblockPartMachine.MANAGED_FIELD_HOLDER);
    public final ItemHandlerProxyTrait inputInventory = new ItemHandlerProxyTrait(this, IO.IN);
    public final ItemHandlerProxyTrait outputInventory = new ItemHandlerProxyTrait(this, IO.OUT);
    public final FluidTankProxyTrait tank = new FluidTankProxyTrait(this, IO.BOTH);
    @Nullable
    protected TickableSubscription autoIOSubs;
    @Nullable
    protected ISubscription outputInventorySubs;
    @Nullable
    protected ISubscription outputTankSubs;

    public CokeOvenHatch(IMachineBlockEntity holder, Object ... args) {
        super(holder);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.inputInventory.setProxy(null);
        this.outputInventory.setProxy(null);
        this.tank.setProxy(null);
        if (this.outputInventorySubs != null) {
            this.outputInventorySubs.unsubscribe();
            this.outputInventorySubs = null;
        }
        if (this.outputTankSubs != null) {
            this.outputTankSubs.unsubscribe();
            this.outputTankSubs = null;
        }
    }

    @Override
    public void addedToController(IMultiController controller) {
        super.addedToController(controller);
        if (controller instanceof CokeOvenMachine) {
            CokeOvenMachine cokeOven = (CokeOvenMachine)controller;
            this.outputInventorySubs = cokeOven.exportItems.addChangedListener(this::updateAutoIOSubscription);
            this.outputTankSubs = cokeOven.exportFluids.addChangedListener(this::updateAutoIOSubscription);
            this.inputInventory.setProxy(cokeOven.importItems);
            this.outputInventory.setProxy(cokeOven.exportItems);
            this.tank.setProxy(cokeOven.exportFluids);
            this.updateAutoIOSubscription();
        }
    }

    @Override
    public void removedFromController(IMultiController controller) {
        super.removedFromController(controller);
        this.inputInventory.setProxy(null);
        this.outputInventory.setProxy(null);
        this.tank.setProxy(null);
        if (this.outputInventorySubs != null) {
            this.outputInventorySubs.unsubscribe();
            this.outputInventorySubs = null;
        }
        if (this.outputTankSubs != null) {
            this.outputTankSubs.unsubscribe();
            this.outputTankSubs = null;
        }
    }

    @Override
    public boolean canShared() {
        return false;
    }

    @Override
    public boolean replacePartModelWhenFormed() {
        return false;
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoIOSubscription();
    }

    @Override
    public void onRotated(Direction oldFacing, Direction newFacing) {
        super.onRotated(oldFacing, newFacing);
        this.updateAutoIOSubscription();
    }

    protected void updateAutoIOSubscription() {
        if (!this.outputInventory.isEmpty() && GTTransferUtils.hasAdjacentItemHandler(this.getLevel(), this.getPos(), this.getFrontFacing()) || !this.tank.isEmpty() && GTTransferUtils.hasAdjacentFluidHandler(this.getLevel(), this.getPos(), this.getFrontFacing())) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, this::autoIO);
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    protected void autoIO() {
        if (this.getOffsetTimer() % 5L == 0L) {
            this.outputInventory.exportToNearby(this.getFrontFacing());
            this.tank.exportToNearby(this.getFrontFacing());
            this.updateAutoIOSubscription();
        }
    }

    @Override
    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return false;
    }
}

