/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.tool.behavior;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.item.tool.behavior.IToolBehavior;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.common.data.item.GTToolActions;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolModeSwitchBehavior
implements IToolBehavior {
    public static final ToolModeSwitchBehavior INSTANCE = new ToolModeSwitchBehavior();

    protected ToolModeSwitchBehavior() {
    }

    @Override
    public boolean canPerformAction(ItemStack stack, ToolAction action) {
        boolean bl;
        block9: {
            block8: {
                block7: {
                    boolean canWrenchConfigureAll;
                    WrenchModeType mode = WrenchModeType.values()[ToolHelper.getBehaviorsTag(stack).m_128445_("Mode")];
                    boolean bl2 = canWrenchConfigureAll = action == GTToolActions.WRENCH_CONFIGURE_ALL;
                    if (action == GTToolActions.WRENCH_CONFIGURE) break block7;
                    switch (mode) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case ITEM: {
                            if (canWrenchConfigureAll || action == GTToolActions.WRENCH_CONFIGURE_ITEMS) {
                                break;
                            }
                            break block8;
                        }
                        case FLUID: {
                            if (canWrenchConfigureAll || action == GTToolActions.WRENCH_CONFIGURE_FLUIDS) {
                                break;
                            }
                            break block8;
                        }
                        case BOTH: {
                            if (!GTToolActions.WRENCH_CONFIGURE_ACTIONS.contains(action)) break block8;
                        }
                    }
                }
                bl = true;
                break block9;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public void addBehaviorNBT(@NotNull ItemStack stack, @NotNull CompoundTag tag) {
        Set<GTToolType> toolTypes = ToolHelper.getToolTypes(stack);
        if (toolTypes.contains(GTToolType.WRENCH)) {
            tag.m_128344_("Mode", (byte)WrenchModeType.BOTH.ordinal());
        }
        IToolBehavior.super.addBehaviorNBT(stack, tag);
    }

    @Override
    @NotNull
    public InteractionResult onItemUse(UseOnContext context) {
        Level world = context.m_43725_();
        BlockHitResult blockHitResult = context.m_43718_();
        Player player = context.m_43723_();
        ItemStack itemStack = context.m_43722_();
        BlockState state = world.m_8055_(blockHitResult.m_82425_());
        BlockPos pos = blockHitResult.m_82425_();
        Set<GTToolType> toolTypes = ToolHelper.getToolTypes(itemStack);
        if (toolTypes.contains(GTToolType.WRENCH) && GTCEu.Mods.isCreateLoaded() && state.m_204336_(CustomTags.CREATE_WRENCH_PICKUP)) {
            if (!(world instanceof ServerLevel)) {
                return InteractionResult.SUCCESS;
            }
            ServerLevel serverLevel = (ServerLevel)world;
            if (player != null && !player.m_7500_()) {
                Block.m_49874_((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)itemStack).forEach(stack -> player.m_150109_().m_150079_(stack));
            }
            state.m_222967_(serverLevel, pos, ItemStack.f_41583_, true);
            world.m_46961_(pos, false);
            GTSoundEntries.WRENCH_TOOL.playOnServer((Level)serverLevel, (Vec3i)pos, 1.0f, GTValues.RNG.m_188501_() * 0.5f + 0.5f);
            return InteractionResult.SUCCESS;
        }
        if (player != null) {
            world.m_8055_(pos).m_60664_(world, player, context.m_43724_(), blockHitResult);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    @NotNull
    public InteractionResultHolder<ItemStack> onItemRightClick(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        CompoundTag tagCompound = ToolHelper.getBehaviorsTag(itemStack);
        if (player.m_6144_()) {
            Set<GTToolType> toolTypes = ToolHelper.getToolTypes(itemStack);
            if (toolTypes.contains(GTToolType.WRENCH)) {
                tagCompound.m_128344_("Mode", (byte)((tagCompound.m_128445_("Mode") + 1) % WrenchModeType.values().length));
                player.m_5661_((Component)Component.m_237110_((String)"metaitem.machine_configuration.mode", (Object[])new Object[]{WrenchModeType.values()[tagCompound.m_128445_("Mode")].getName()}), true);
            }
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return IToolBehavior.super.onItemRightClick(world, player, hand);
    }

    @Override
    public void addInformation(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        CompoundTag tagCompound = ToolHelper.getBehaviorsTag(stack);
        Set<GTToolType> toolTypes = ToolHelper.getToolTypes(stack);
        if (toolTypes.contains(GTToolType.WRENCH)) {
            tooltip.add((Component)Component.m_237110_((String)"metaitem.machine_configuration.mode", (Object[])new Object[]{WrenchModeType.values()[tagCompound.m_128445_("Mode")].getName()}));
        }
    }

    public static enum WrenchModeType {
        ITEM((Component)Component.m_237115_((String)"gtceu.mode.item")),
        FLUID((Component)Component.m_237115_((String)"gtceu.mode.fluid")),
        BOTH((Component)Component.m_237115_((String)"gtceu.mode.both"));

        private final Component name;

        private WrenchModeType(Component name) {
            this.name = name;
        }

        public boolean isItem() {
            return this == ITEM || this == BOTH;
        }

        public boolean isFluid() {
            return this == FLUID || this == BOTH;
        }

        @Generated
        public Component getName() {
            return this.name;
        }
    }
}

