/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.api.item.component.ICustomDescriptionId;
import com.gregtechceu.gtceu.api.item.component.ISubItemHandler;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.utils.memoization.GTMemoizer;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacadeItemBehaviour
implements ISubItemHandler,
ICustomDescriptionId {
    public static final Supplier<List<BlockState>> DEFAULT_FACADES = GTMemoizer.memoize(() -> {
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        states.add(Blocks.f_50069_.m_49966_());
        states.add(GTBlocks.COIL_CUPRONICKEL.getDefaultState());
        states.add(Blocks.f_50058_.m_49966_());
        return states;
    });

    @Override
    @Nullable
    public Component getItemName(ItemStack stack) {
        BlockState facadeState = FacadeItemBehaviour.getFacadeState(stack);
        return Component.m_237110_((String)stack.m_41778_(), (Object[])new Object[]{facadeState.m_60734_().m_49954_()});
    }

    @Override
    public void fillItemCategory(Item item, CreativeModeTab category, NonNullList<ItemStack> items) {
        for (BlockState facadeState : DEFAULT_FACADES.get()) {
            ItemStack resultStack = item.m_7968_();
            FacadeItemBehaviour.setFacadeState(resultStack, facadeState);
            items.add((Object)resultStack);
        }
    }

    public static void setFacadeState(ItemStack itemStack, BlockState facadeState) {
        if (!FacadeItemBehaviour.isValidFacade(facadeState)) {
            facadeState = Blocks.f_50069_.m_49966_();
        }
        CompoundTag tagCompound = itemStack.m_41784_();
        Tag stateTag = (Tag)BlockState.f_61039_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)facadeState).result().orElse(new CompoundTag());
        tagCompound.m_128365_("Facade", stateTag);
    }

    public static boolean isValidFacade(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem blockItem = (BlockItem)item;
        return FacadeItemBehaviour.isValidFacade(blockItem.m_40614_().m_49966_());
    }

    public static boolean isValidFacade(BlockState state) {
        return !state.m_155947_() && state.m_60799_() == RenderShape.MODEL;
    }

    public static BlockState getFacadeState(ItemStack itemStack) {
        BlockState nullableState = FacadeItemBehaviour.getFacadeStateNullable(itemStack);
        if (nullableState == null) {
            return Blocks.f_50069_.m_49966_();
        }
        return nullableState;
    }

    public static BlockState getFacadeStateNullable(ItemStack itemStack) {
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.m_40614_().m_49966_();
        }
        BlockState unsafeState = FacadeItemBehaviour.getFacadeStateUnsafe(itemStack);
        if (unsafeState == null) {
            ItemStack unsafeStack = FacadeItemBehaviour.getFacadeStackUnsafe(itemStack);
            Item item2 = unsafeStack.m_41720_();
            if (item2 instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item2;
                return blockItem.m_40614_().m_49966_();
            }
            return null;
        }
        return unsafeState;
    }

    @Nullable
    private static BlockState getFacadeStateUnsafe(ItemStack itemStack) {
        CompoundTag tagCompound = itemStack.m_41783_();
        if (tagCompound == null || !tagCompound.m_128425_("Facade", 10)) {
            return null;
        }
        return BlockState.f_61039_.parse((DynamicOps)NbtOps.f_128958_, (Object)tagCompound.m_128469_("Facade")).result().orElse(null);
    }

    @Deprecated
    @NotNull
    private static ItemStack getFacadeStackUnsafe(ItemStack itemStack) {
        CompoundTag tagCompound = itemStack.m_41783_();
        if (tagCompound == null || !tagCompound.m_128425_("Facade", 10)) {
            return ItemStack.f_41583_;
        }
        ItemStack facadeStack = ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_("Facade"));
        if (facadeStack.m_41619_() || !FacadeItemBehaviour.isValidFacade(facadeStack)) {
            return ItemStack.f_41583_;
        }
        return facadeStack;
    }
}

