/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.entity;

import com.gregtechceu.gtceu.core.mixins.PrimedTntAccessor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GTExplosiveEntity
extends PrimedTnt {
    public GTExplosiveEntity(EntityType<? extends GTExplosiveEntity> type, Level level, double x, double y, double z, @Nullable LivingEntity owner) {
        this(type, level);
        this.m_6034_(x, y, z);
        double d = level.f_46441_.m_188500_() * 6.2831854820251465;
        this.m_20334_(-Math.sin(d) * 0.02, 0.2f, -Math.cos(d) * 0.02);
        this.m_32085_(80);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        ((PrimedTntAccessor)((Object)this)).setOwner(owner);
    }

    public GTExplosiveEntity(EntityType<? extends GTExplosiveEntity> type, Level world) {
        super(type, world);
    }

    protected abstract float getStrength();

    public abstract boolean dropsAllBlocks();

    protected int getRange() {
        return 2;
    }

    @NotNull
    public abstract BlockState getExplosiveState();

    protected void m_32103_() {
        this.explode(this.m_9236_(), (Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), this.getStrength(), this.dropsAllBlocks());
    }

    protected void explode(Level level, @Nullable Entity source, double x, double y, double z, float radius, boolean dropBlocks) {
        Explosion explosion = new Explosion(level, source, x, y, z, radius, false, dropBlocks ? Explosion.BlockInteraction.DESTROY_WITH_DECAY : Explosion.BlockInteraction.DESTROY);
        if (!ForgeEventFactory.onExplosionStart((Level)level, (Explosion)explosion)) {
            explosion.m_46061_();
            explosion.m_46075_(false);
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (ServerPlayer serverplayer : serverLevel.m_6907_()) {
                if (!(serverplayer.m_20275_(x, y, z) < 4096.0)) continue;
                serverplayer.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(x, y, z, radius, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(serverplayer)));
            }
        }
    }
}

