/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.voiding;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.filter.FluidFilter;
import com.gregtechceu.gtceu.api.cover.filter.SimpleFluidFilter;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.NumberInputWidget;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.common.cover.PumpCover;
import com.gregtechceu.gtceu.common.cover.data.BucketMode;
import com.gregtechceu.gtceu.common.cover.data.VoidingMode;
import com.gregtechceu.gtceu.common.cover.voiding.FluidVoidingCover;
import com.gregtechceu.gtceu.utils.GTMath;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AdvancedFluidVoidingCover
extends FluidVoidingCover {
    @Persisted
    @DescSynced
    private VoidingMode voidingMode = VoidingMode.VOID_ANY;
    @Persisted
    @DescSynced
    protected int globalTransferSizeMillibuckets = 1;
    @Persisted
    @DescSynced
    private BucketMode transferBucketMode = BucketMode.MILLI_BUCKET;
    private NumberInputWidget<Integer> stackSizeInput;
    private EnumSelectorWidget<BucketMode> stackSizeBucketModeInput;
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(AdvancedFluidVoidingCover.class, FluidVoidingCover.MANAGED_FIELD_HOLDER);

    public AdvancedFluidVoidingCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    @Override
    protected void doVoidFluids() {
        IFluidHandlerModifiable fluidHandler = this.getOwnFluidHandler();
        if (fluidHandler == null) {
            return;
        }
        switch (this.voidingMode) {
            case VOID_ANY: {
                this.voidAny(fluidHandler);
                break;
            }
            case VOID_OVERFLOW: {
                this.voidOverflow(fluidHandler);
            }
        }
    }

    private void voidOverflow(IFluidHandlerModifiable fluidHandler) {
        Object2LongMap<FluidStack> fluidAmounts = this.enumerateDistinctFluids(fluidHandler, PumpCover.TransferDirection.EXTRACT);
        for (Object2LongMap.Entry entry : Object2LongMaps.fastIterable(fluidAmounts)) {
            FluidStack stack = (FluidStack)entry.getKey();
            long presentAmount = entry.getLongValue();
            int targetAmount = this.getFilteredFluidAmount(stack);
            if ((long)targetAmount <= 0L || (long)targetAmount > presentAmount) continue;
            long diff = presentAmount - (long)targetAmount;
            for (int op : GTMath.split(diff)) {
                FluidStack toDrain = new FluidStack(stack, op);
                fluidHandler.drain(toDrain, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    private int getFilteredFluidAmount(FluidStack fluidStack) {
        if (!this.filterHandler.isFilterPresent()) {
            return this.globalTransferSizeMillibuckets;
        }
        FluidFilter filter = (FluidFilter)this.filterHandler.getFilter();
        return filter.isBlackList() ? this.globalTransferSizeMillibuckets : filter.testFluidAmount(fluidStack);
    }

    public void setVoidingMode(VoidingMode voidingMode) {
        this.voidingMode = voidingMode;
        this.configureStackSizeInput();
        if (!this.isRemote()) {
            this.configureFilter();
        }
    }

    private void setTransferBucketMode(BucketMode transferBucketMode) {
        int oldMultiplier = this.transferBucketMode.multiplier;
        int newMultiplier = transferBucketMode.multiplier;
        this.transferBucketMode = transferBucketMode;
        if (this.stackSizeInput == null) {
            return;
        }
        this.stackSizeInput.setValue(this.getCurrentBucketModeTransferSize());
    }

    @Override
    @NotNull
    protected String getUITitle() {
        return "cover.fluid.voiding.advanced.title";
    }

    @Override
    protected void buildAdditionalUI(WidgetGroup group) {
        group.addWidget((Widget)new EnumSelectorWidget(146, 20, 20, 20, (Enum[])VoidingMode.values(), (Enum)this.voidingMode, this::setVoidingMode));
        this.stackSizeInput = new IntInputWidget(35, 20, 84, 20, this::getCurrentBucketModeTransferSize, this::setCurrentBucketModeTransferSize).setMin(1).setMax(Integer.MAX_VALUE);
        this.configureStackSizeInput();
        group.addWidget(this.stackSizeInput);
        this.stackSizeBucketModeInput = new EnumSelectorWidget(121, 20, 20, 20, (Enum[])BucketMode.values(), (Enum)this.transferBucketMode, this::setTransferBucketMode);
        group.addWidget(this.stackSizeBucketModeInput);
    }

    private int getCurrentBucketModeTransferSize() {
        return this.globalTransferSizeMillibuckets / this.transferBucketMode.multiplier;
    }

    private void setCurrentBucketModeTransferSize(int transferSize) {
        this.globalTransferSizeMillibuckets = Math.max(transferSize * this.transferBucketMode.multiplier, 0);
    }

    @Override
    protected void configureFilter() {
        Object f = this.filterHandler.getFilter();
        if (f instanceof SimpleFluidFilter) {
            SimpleFluidFilter filter = (SimpleFluidFilter)f;
            filter.setMaxStackSize(this.voidingMode == VoidingMode.VOID_ANY ? 1 : Integer.MAX_VALUE);
        }
        this.configureStackSizeInput();
    }

    private void configureStackSizeInput() {
        if (this.stackSizeInput == null || this.stackSizeBucketModeInput == null) {
            return;
        }
        this.stackSizeInput.setVisible(this.shouldShowStackSize());
        this.stackSizeBucketModeInput.setVisible(this.shouldShowStackSize());
    }

    private boolean shouldShowStackSize() {
        if (this.voidingMode == VoidingMode.VOID_ANY) {
            return false;
        }
        if (!this.filterHandler.isFilterPresent()) {
            return true;
        }
        return ((FluidFilter)this.filterHandler.getFilter()).isBlackList();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Generated
    public VoidingMode getVoidingMode() {
        return this.voidingMode;
    }

    @Generated
    public int getGlobalTransferSizeMillibuckets() {
        return this.globalTransferSizeMillibuckets;
    }

    @Generated
    public BucketMode getTransferBucketMode() {
        return this.transferBucketMode;
    }
}

