/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.ender;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandler;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandlers;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.gui.widget.SlotWidget;
import com.gregtechceu.gtceu.api.misc.virtualregistry.EntryTypes;
import com.gregtechceu.gtceu.api.misc.virtualregistry.VirtualEnderRegistry;
import com.gregtechceu.gtceu.api.misc.virtualregistry.VirtualEntry;
import com.gregtechceu.gtceu.api.misc.virtualregistry.entries.VirtualItemStorage;
import com.gregtechceu.gtceu.common.cover.ender.AbstractEnderLinkCover;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderItemLinkCover
extends AbstractEnderLinkCover<VirtualItemStorage> {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(EnderItemLinkCover.class, AbstractEnderLinkCover.MANAGED_FIELD_HOLDER);
    protected static final int TRANSFER_RATE = 8;
    @Persisted
    @DescSynced
    protected VirtualItemStorage storage;
    protected int itemsLeftToTransferLastSecond = 160;
    @Persisted
    @DescSynced
    protected FilterHandler<ItemStack, ItemFilter> filterHandler = FilterHandlers.item(this);

    public EnderItemLinkCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
        if (!this.isRemote()) {
            this.storage = VirtualEnderRegistry.getInstance().getOrCreateEntry(this.getOwner(), EntryTypes.ENDER_ITEM, this.getChannelName());
        }
    }

    @Override
    public boolean canAttach() {
        return true;
    }

    @Override
    protected String identifier() {
        return "EILink#";
    }

    @Override
    protected VirtualItemStorage getEntry() {
        return this.storage;
    }

    @Override
    protected void setEntry(VirtualEntry entry) {
        this.storage = (VirtualItemStorage)entry;
    }

    @Override
    protected EntryTypes<VirtualItemStorage> getEntryType() {
        return EntryTypes.ENDER_ITEM;
    }

    @Override
    protected void transfer() {
        long timer = this.coverHolder.getOffsetTimer();
        if (this.itemsLeftToTransferLastSecond > 0) {
            this.itemsLeftToTransferLastSecond -= this.doTransferItems(this.itemsLeftToTransferLastSecond);
        }
        if (timer % 20L == 0L) {
            this.itemsLeftToTransferLastSecond = 160;
        }
    }

    private int doTransferItems(int max) {
        IItemHandler ownHandler = this.getOwnItemHandler();
        if (ownHandler == null) {
            return 0;
        }
        return switch (this.io) {
            case IO.IN -> GTTransferUtils.transferItemsFiltered(ownHandler, (IItemHandler)this.storage.getHandler(), this.filterHandler.getFilter(), max);
            case IO.OUT -> GTTransferUtils.transferItemsFiltered((IItemHandler)this.storage.getHandler(), ownHandler, this.filterHandler.getFilter(), max);
            default -> 0;
        };
    }

    @Nullable
    public IItemHandler getOwnItemHandler() {
        return this.coverHolder.getItemHandlerCap(this.attachedSide, false);
    }

    @Override
    protected Widget addVirtualEntryWidget(VirtualEntry entry, int x, int y, int width, int height, boolean canClick) {
        WidgetGroup group = new WidgetGroup(x, y, width, height);
        for (int i = 0; i < ((VirtualItemStorage)entry).getHandler().getSlots(); ++i) {
            group.addWidget((Widget)new SlotWidget((IItemHandlerModifiable)((VirtualItemStorage)entry).getHandler(), i, 8 * i, 0, canClick, canClick));
        }
        return group;
    }

    @Override
    protected String getUITitle() {
        return "cover.ender_item_link.title";
    }

    @Override
    @NotNull
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    @Generated
    public FilterHandler<ItemStack, ItemFilter> getFilterHandler() {
        return this.filterHandler;
    }
}

