/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine.impl;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.client.renderer.GTRenderTypes;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRender;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRenderType;
import com.gregtechceu.gtceu.client.util.BloomUtils;
import com.gregtechceu.gtceu.client.util.RenderBufferHelper;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.FusionReactorMachine;
import com.lowdragmc.shimmer.client.shader.RenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.serialization.Codec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FusionRingRender
extends DynamicRender<FusionReactorMachine, FusionRingRender> {
    public static final Codec<FusionRingRender> CODEC = Codec.unit(FusionRingRender::new);
    public static final DynamicRenderType<FusionReactorMachine, FusionRingRender> TYPE = new DynamicRenderType(CODEC);
    public static final float FADEOUT = 60.0f;
    protected float delta = 0.0f;
    protected int lastColor = -1;

    @Override
    public DynamicRenderType<FusionReactorMachine, FusionRingRender> getType() {
        return TYPE;
    }

    @Override
    public boolean shouldRender(FusionReactorMachine machine, Vec3 cameraPos) {
        return machine.recipeLogic.isWorking() || this.delta > 0.0f;
    }

    @Override
    public void render(FusionReactorMachine machine, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (!machine.recipeLogic.isWorking() && this.delta <= 0.0f) {
            return;
        }
        if (GTCEu.Mods.isShimmerLoaded()) {
            PoseStack finalStack = RenderUtils.copyPoseStack((PoseStack)poseStack);
            BloomUtils.entityBloom(source -> this.renderLightRing(machine, partialTick, finalStack, source.m_6299_(GTRenderTypes.getLightRing())));
        } else {
            this.renderLightRing(machine, partialTick, poseStack, buffer.m_6299_(GTRenderTypes.getLightRing()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderLightRing(FusionReactorMachine machine, float partialTicks, PoseStack stack, VertexConsumer buffer) {
        Integer color = machine.getColor();
        float alpha = 1.0f;
        if (machine.recipeLogic.isWorking()) {
            this.lastColor = color;
            this.delta = 60.0f;
        } else {
            alpha = this.delta / 60.0f;
            this.lastColor = FastColor.ARGB32.m_13660_((int)Mth.m_14143_((float)(alpha * 255.0f)), (int)FastColor.ARGB32.m_13665_((int)this.lastColor), (int)FastColor.ARGB32.m_13667_((int)this.lastColor), (int)FastColor.ARGB32.m_13669_((int)this.lastColor));
            this.delta -= Minecraft.m_91087_().m_91297_();
        }
        float lerpFactor = Math.abs((float)Math.abs(machine.getOffsetTimer() % 50L) + partialTicks - 25.0f) / 25.0f;
        Direction front = machine.getFrontFacing();
        Direction upwards = machine.getUpwardsFacing();
        boolean flipped = machine.isFlipped();
        Direction back = RelativeDirection.BACK.getRelative(front, upwards, flipped);
        Direction.Axis axis = RelativeDirection.UP.getRelative(front, upwards, flipped).m_122434_();
        float r = Mth.m_14179_((float)lerpFactor, (float)FastColor.ARGB32.m_13665_((int)this.lastColor), (float)255.0f) / 255.0f;
        float g = Mth.m_14179_((float)lerpFactor, (float)FastColor.ARGB32.m_13667_((int)this.lastColor), (float)255.0f) / 255.0f;
        float b = Mth.m_14179_((float)lerpFactor, (float)FastColor.ARGB32.m_13669_((int)this.lastColor), (float)255.0f) / 255.0f;
        RenderBufferHelper.renderRing(stack, buffer, (float)(back.m_122429_() * 7) + 0.5f, (float)(back.m_122430_() * 7) + 0.5f, (float)(back.m_122431_() * 7) + 0.5f, 6.0f, 0.2f, 10, 20, r, g, b, alpha, axis);
    }

    @Override
    public boolean shouldRenderOffScreen(FusionReactorMachine machine) {
        return machine.recipeLogic.isWorking() || this.delta > 0.0f;
    }

    @Override
    public int getViewDistance() {
        return 32;
    }

    @Override
    public AABB getRenderBoundingBox(FusionReactorMachine machine) {
        return new AABB(machine.getPos()).m_82400_((double)this.getViewDistance() / 2.0);
    }
}

