/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.block;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.client.model.PipeModel;
import com.gregtechceu.gtceu.client.renderer.cover.ICoverableRenderer;
import com.gregtechceu.gtceu.client.util.GTQuadTransformers;
import com.gregtechceu.gtceu.common.data.GTMaterialBlocks;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.client.model.forge.LDLRendererModel;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class PipeBlockRenderer
implements IRenderer,
ICoverableRenderer {
    PipeModel pipeModel;

    public PipeBlockRenderer(PipeModel pipeModel) {
        this.pipeModel = pipeModel;
        if (GTCEu.isClientSide()) {
            this.registerEvent();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        this.pipeModel.renderItem(stack, transformType, leftHand, matrixStack, buffer, combinedLight, combinedOverlay, model);
    }

    public boolean useAO() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean useBlockLight(ItemStack stack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> renderModel(BlockAndTintGetter level, BlockPos pos, BlockState state, Direction side, RandomSource rand) {
        if (level == null) {
            return this.pipeModel.bakeQuads(side, 12, 0);
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof IPipeNode)) {
            return this.pipeModel.bakeQuads(side, 0, 0);
        }
        IPipeNode pipeNode = (IPipeNode)blockEntity;
        RenderType renderType = (RenderType)LDLRendererModel.RendererBakedModel.CURRENT_RENDER_TYPE.get();
        ModelData modelData = (ModelData)((ModelData)LDLRendererModel.RendererBakedModel.CURRENT_MODEL_DATA.get()).get(LDLRendererModel.RendererBakedModel.MODEL_DATA);
        if (modelData == null) {
            modelData = ModelData.EMPTY;
        }
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        if (renderType == null || renderType == RenderType.m_110457_()) {
            quads.addAll(this.pipeModel.bakeQuads(side, pipeNode.getVisualConnections(), pipeNode.getBlockedConnections()));
        }
        ICoverableRenderer.super.renderCovers(quads, pipeNode.getCoverContainer(), pos, level, side, rand, modelData, renderType);
        if (pipeNode.getFrameMaterial().isNull() || renderType != null && renderType != RenderType.m_110466_()) {
            return quads;
        }
        BlockState frameState = ((BlockEntry)GTMaterialBlocks.MATERIAL_BLOCKS.get((Object)TagPrefix.frameGt, (Object)pipeNode.getFrameMaterial())).getDefaultState();
        BakedModel frameModel = Minecraft.m_91087_().m_91289_().m_110910_(frameState);
        modelData = frameModel.getModelData(level, pos, frameState, modelData);
        LinkedList frameQuads = new LinkedList();
        if (side == null || pipeNode.getCoverContainer().getCoverAtSide(side) == null) {
            frameQuads.addAll(frameModel.getQuads(state, side, rand, modelData, renderType));
        }
        if (side == null) {
            for (Direction face : GTUtil.DIRECTIONS) {
                if (pipeNode.getCoverContainer().getCoverAtSide(face) != null) continue;
                frameQuads.addAll(frameModel.getQuads(state, face, rand, modelData, renderType));
            }
        }
        BlockColors blockColors = Minecraft.m_91087_().m_91298_();
        for (BakedQuad frameQuad : frameQuads) {
            if (frameQuad.m_111304_()) {
                int color = blockColors.m_92577_(frameState, level, pos, frameQuad.m_111305_());
                frameQuad = GTQuadTransformers.setColor(frameQuad, color, true);
            }
            quads.add(frameQuad);
        }
        return quads;
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public TextureAtlasSprite getParticleTexture() {
        return this.pipeModel.getParticleTexture();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        if (atlasName.equals((Object)TextureAtlas.f_118259_)) {
            this.pipeModel.registerTextureAtlas(register);
        }
    }

    @Generated
    public PipeModel getPipeModel() {
        return this.pipeModel;
    }
}

