/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model.machine;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.client.model.BasicUnbakedModel;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.gregtechceu.gtceu.client.model.machine.UnbakedMachineModel;
import com.gregtechceu.gtceu.client.model.machine.multipart.MultiPartSelector;
import com.gregtechceu.gtceu.client.model.machine.multipart.MultiPartUnbakedModel;
import com.gregtechceu.gtceu.client.model.machine.variant.MultiVariantModel;
import com.gregtechceu.gtceu.client.model.machine.variant.VariantState;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRender;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Transformation;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverride;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.ExtendedBlockModelDeserializer;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.common.util.TransformationHelper;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="gtceu", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class MachineModelLoader
implements IGeometryLoader<UnbakedMachineModel> {
    public static final MachineModelLoader INSTANCE = new MachineModelLoader();
    public static final ResourceLocation ID = GTCEu.id("machine");
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(BlockModel.class, (Object)new ExtendedBlockModelDeserializer()).registerTypeAdapter(BlockElement.class, (Object)new BlockElement.Deserializer()).registerTypeAdapter(BlockElementFace.class, (Object)new BlockElementFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(ItemTransform.class, (Object)new ItemTransform.Deserializer()).registerTypeAdapter(ItemTransforms.class, (Object)new ItemTransforms.Deserializer()).registerTypeAdapter(ItemOverride.class, (Object)new ItemOverride.Deserializer()).registerTypeAdapter(Transformation.class, (Object)new TransformationHelper.Deserializer()).registerTypeAdapter(MultiVariantModel.class, (Object)new MultiVariantModel.Deserializer()).registerTypeAdapter(VariantState.class, (Object)new VariantState.Deserializer()).registerTypeAdapter(MultiPartSelector.class, (Object)new MultiPartSelector.Deserializer()).create();
    private static final Logger LOGGER = LogManager.getLogger((String)"GT MACHINE MODEL LOADER");
    private static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    private static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);
    private static final UnbakedModel MISSING_MARKER = new BasicUnbakedModel();

    private MachineModelLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public UnbakedMachineModel read(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
        MultiPartUnbakedModel multiPart;
        ResourceLocation machineId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"machine"));
        MachineDefinition definition = (MachineDefinition)GTRegistries.MACHINES.get(machineId);
        if (definition == null) {
            return null;
        }
        HashMap<String, UnbakedModel> variants = new HashMap<String, UnbakedModel>();
        if (json.has("variants")) {
            JsonObject variantsJson = GsonHelper.m_13930_((JsonObject)json, (String)"variants");
            for (Map.Entry entry : variantsJson.entrySet()) {
                variants.put((String)entry.getKey(), (UnbakedModel)GSON.fromJson((JsonElement)entry.getValue(), MultiVariantModel.class));
            }
        }
        if (json.has("multipart")) {
            JsonArray multipartJson = GsonHelper.m_13933_((JsonObject)json, (String)"multipart");
            multiPart = MultiPartUnbakedModel.deserialize(definition, multipartJson);
        } else {
            multiPart = null;
        }
        if (variants.isEmpty() && (multiPart == null || multiPart.getModels().isEmpty())) {
            throw new JsonParseException("Model for machine %s doesn't have 'variants' or 'multipart' defined".formatted(machineId));
        }
        StateDefinition<MachineDefinition, MachineRenderState> stateDefinition = definition.getStateDefinition();
        ImmutableList possibleStates = stateDefinition.m_61056_();
        IdentityHashMap<MachineRenderState, UnbakedModel> statesToModels = new IdentityHashMap<MachineRenderState, UnbakedModel>();
        if (multiPart != null) {
            possibleStates.forEach(state -> statesToModels.put((MachineRenderState)((Object)state), multiPart));
        }
        HashMap<ModelResourceLocation, MachineRenderState> modelsToStates = new HashMap<ModelResourceLocation, MachineRenderState>();
        possibleStates.forEach(state -> modelsToStates.put(MachineModelLoader.stateToModelLocation(machineId, state), (MachineRenderState)((Object)state)));
        try {
            variants.forEach((key, curModel) -> {
                try {
                    possibleStates.stream().filter(MachineModelLoader.predicate(stateDefinition, key)).forEach(state -> {
                        UnbakedModel prevModel = statesToModels.put((MachineRenderState)((Object)state), (UnbakedModel)curModel);
                        if (prevModel != null && prevModel != multiPart) {
                            statesToModels.put((MachineRenderState)((Object)state), MISSING_MARKER);
                            throw new IllegalStateException("Overlapping definition with: " + variants.entrySet().stream().filter(entry -> entry.getValue() == prevModel).findFirst().map(Map.Entry::getKey).orElse("Invalid key? This shouldn't happen"));
                        }
                    });
                }
                catch (Exception e) {
                    LOGGER.warn("Exception loading model for machine: '{}' for variant: '{}': {}", (Object)machineId, key, (Object)e);
                }
            });
        }
        finally {
            modelsToStates.forEach((modelLoc, state) -> {
                UnbakedModel unbaked = (UnbakedModel)statesToModels.get(state);
                if (unbaked == null) {
                    LOGGER.warn("Exception loading model for machine: '{}' missing model for variant: '{}'", (Object)machineId, modelLoc);
                    statesToModels.put((MachineRenderState)((Object)state), MISSING_MARKER);
                }
            });
        }
        ArrayList dynamicRenders = new ArrayList();
        JsonArray array = GsonHelper.m_13832_((JsonObject)json, (String)"dynamic_renders", null);
        if (array != null) {
            for (JsonElement entry : array) {
                DynamicRender render = (DynamicRender)DynamicRender.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry).getOrThrow(true, arg_0 -> ((Logger)LOGGER).error(arg_0));
                dynamicRenders.add(render);
            }
        }
        HashSet<String> replaceableTextures = new HashSet<String>();
        array = GsonHelper.m_13832_((JsonObject)json, (String)"replaceable_textures", null);
        if (array != null) {
            for (int i = 0; i < array.size(); ++i) {
                String entry = GsonHelper.m_13805_((JsonElement)array.get(i), (String)"replaceable_textures[%s]".formatted(i));
                replaceableTextures.add(entry);
            }
        }
        HashMap<String, ResourceLocation> textureOverrides = new HashMap<String, ResourceLocation>();
        JsonObject overrideJson = GsonHelper.m_13841_((JsonObject)json, (String)"texture_overrides", null);
        if (overrideJson != null) {
            for (Map.Entry entry : overrideJson.asMap().entrySet()) {
                String value = GsonHelper.m_13805_((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                textureOverrides.put((String)entry.getKey(), new ResourceLocation(value));
            }
        }
        return new UnbakedMachineModel(definition, statesToModels, multiPart, dynamicRenders, replaceableTextures, textureOverrides);
    }

    protected static void resolveStateModels(UnbakedMachineModel model, Function<ResourceLocation, UnbakedModel> resolver) {
        UnbakedModel missingModel = resolver.apply((ResourceLocation)ModelBakery.f_119230_);
        MultiPartUnbakedModel multiPart = model.getMultiPart();
        if (multiPart != null) {
            multiPart.m_5500_(resolver);
        }
        IdentityHashMap<MachineRenderState, UnbakedModel> modelsCopy = new IdentityHashMap<MachineRenderState, UnbakedModel>(model.getModels());
        modelsCopy.forEach((state, variant) -> {
            if (variant == null || variant == MISSING_MARKER) {
                model.getModels().put((MachineRenderState)((Object)state), missingModel);
            } else {
                variant.m_5500_(resolver);
                model.getModels().put((MachineRenderState)((Object)state), (UnbakedModel)variant);
            }
        });
    }

    private static Predicate<MachineRenderState> predicate(StateDefinition<MachineDefinition, MachineRenderState> container, String variant) {
        HashMap properties = Maps.newHashMap();
        for (String propertyEntry : COMMA_SPLITTER.split((CharSequence)variant)) {
            Iterator keyValue = EQUAL_SPLITTER.split((CharSequence)propertyEntry).iterator();
            if (!keyValue.hasNext()) continue;
            String key = (String)keyValue.next();
            Property property = container.m_61081_(key);
            if (property != null && keyValue.hasNext()) {
                String value = (String)keyValue.next();
                Object comparable = MachineModelLoader.getValueHelper(property, value);
                if (comparable == null) {
                    throw new RuntimeException("Unknown value: '" + value + "' for machine model state property: '" + key + "' " + String.valueOf(property.m_6908_()));
                }
                properties.put(property, comparable);
                continue;
            }
            if (key.isEmpty()) continue;
            throw new RuntimeException("Unknown machine model state property: '" + key + "'");
        }
        MachineDefinition machine = (MachineDefinition)container.m_61091_();
        return state -> {
            if (state == null || !state.is(machine)) {
                return false;
            }
            for (Map.Entry entry : properties.entrySet()) {
                if (Objects.equals(state.m_61143_((Property)entry.getKey()), entry.getValue())) continue;
                return false;
            }
            return true;
        };
    }

    @Nullable
    static <T extends Comparable<T>> T getValueHelper(Property<T> property, String value) {
        return (T)((Comparable)property.m_6215_(value).orElse(null));
    }

    public static ModelResourceLocation stateToModelLocation(ResourceLocation location, MachineRenderState state) {
        return new ModelResourceLocation(location, BlockModelShaper.m_110887_((Map)state.m_61148_()));
    }

    public static Either<ResourceLocation, UnbakedModel> parseVariant(JsonElement value, JsonDeserializationContext context) throws JsonParseException {
        if (value.isJsonPrimitive() && value.getAsJsonPrimitive().isString()) {
            String modelName = value.getAsString();
            return Either.left((Object)new ResourceLocation(modelName));
        }
        return Either.right((Object)((UnbakedModel)context.deserialize(value, BlockModel.class)));
    }
}

