/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ingredient;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderFluidIngredient;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class FluidIngredient
implements Predicate<FluidStack> {
    public static final Codec<FluidIngredient> CODEC = ExtraCodecs.f_252400_.xmap(FluidIngredient::fromJson, FluidIngredient::toJson);
    public static final FluidIngredient EMPTY = new FluidIngredient(new Value[0], 0, null);
    public static final FluidStack[] EMPTY_STACK_ARRAY = new FluidStack[0];
    public Value[] values;
    @Nullable
    public FluidStack[] stacks;
    protected int amount;
    protected CompoundTag nbt;
    protected boolean changed = true;
    public static final Comparator<Fluid> FLUID_COMPARATOR = Comparator.comparing(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257020_).m_7981_(arg_0));
    public static final Comparator<Value> VALUE_COMPARATOR = new Comparator<Value>(){

        @Override
        public int compare(Value value1, Value value2) {
            if (value1 instanceof TagValue) {
                TagValue first = (TagValue)value1;
                if (!(value2 instanceof TagValue)) {
                    return 1;
                }
                TagValue second = (TagValue)value2;
                if (first.tag() != second.tag()) {
                    return 1;
                }
            } else if (value1 instanceof FluidValue) {
                FluidValue first = (FluidValue)value1;
                if (!(value2 instanceof FluidValue)) {
                    return 1;
                }
                FluidValue second = (FluidValue)value2;
                return FLUID_COMPARATOR.compare(first.fluid, second.fluid);
            }
            return 0;
        }
    };

    protected FluidIngredient(Value[] values, int amount, @Nullable CompoundTag nbt) {
        this.values = values;
        this.amount = amount;
        this.nbt = nbt;
    }

    public static FluidIngredient fromValues(Value[] values, int amount, @Nullable CompoundTag nbt) {
        if (values.length == 0) {
            return EMPTY;
        }
        return new FluidIngredient(values, amount, nbt);
    }

    public static FluidIngredient fromValues(List<? extends Value> values, int amount, @Nullable CompoundTag nbt) {
        return FluidIngredient.fromValues((Value[])values.toArray(Value[]::new), amount, nbt);
    }

    public static FluidIngredient fromValue(Value value, int amount, @Nullable CompoundTag nbt) {
        return FluidIngredient.fromValues(new Value[]{value}, amount, nbt);
    }

    private List<Fluid> getFluids() {
        ArrayList<Fluid> fluids = new ArrayList<Fluid>(1);
        for (Value value : this.values) {
            fluids.addAll(value.getFluids());
        }
        return fluids;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_236828_(this.getFluids(), (buf, fluid) -> buf.m_236818_((IdMap)BuiltInRegistries.f_257020_, fluid));
        buffer.m_130130_(this.amount);
        buffer.m_130079_(this.nbt);
    }

    public JsonElement toJson() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("amount", (Number)this.amount);
        if (this.nbt != null) {
            jsonObject.addProperty("nbt", this.nbt.m_7916_());
        }
        if (this.values.length == 1) {
            jsonObject.add("value", (JsonElement)this.values[0].serialize());
        }
        JsonArray jsonArray = new JsonArray();
        for (Value value : this.values) {
            jsonArray.add((JsonElement)value.serialize());
        }
        jsonObject.add("value", (JsonElement)jsonArray);
        return jsonObject;
    }

    public FluidIngredient copy() {
        return new FluidIngredient(this.values, this.amount, this.nbt == null ? null : this.nbt.m_6426_());
    }

    @Override
    public boolean test(@Nullable FluidStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.isEmpty()) {
            return stack.isEmpty();
        }
        if (this.nbt != null && !this.nbt.equals((Object)stack.getTag())) {
            return false;
        }
        for (FluidStack fluidStack : this.getStacks()) {
            if (fluidStack.getFluid() != stack.getFluid()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FluidIngredient)) {
            return false;
        }
        FluidIngredient other = (FluidIngredient)obj;
        if (!Objects.equals(this.nbt, other.nbt)) {
            return false;
        }
        if (this.values.length != other.values.length) {
            return false;
        }
        Value[] myValues = (Value[])this.values.clone();
        Value[] otherValues = (Value[])other.values.clone();
        Arrays.parallelSort(myValues, VALUE_COMPARATOR);
        Arrays.parallelSort(otherValues, VALUE_COMPARATOR);
        for (Value value1 : myValues) {
            for (Value value2 : otherValues) {
                Record second;
                if (value1 instanceof TagValue) {
                    TagValue first = (TagValue)value1;
                    if (!(value2 instanceof TagValue)) {
                        return false;
                    }
                    second = (TagValue)value2;
                    if (first.tag == second.tag) continue;
                    return false;
                }
                if (!(value1 instanceof FluidValue)) continue;
                FluidValue first = (FluidValue)value1;
                if (!(value2 instanceof FluidValue)) {
                    return false;
                }
                second = (FluidValue)value2;
                if (first.fluid == ((FluidValue)second).fluid) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.values);
        result = 31 * result + Integer.hashCode(this.amount);
        result = 31 * result + Objects.hashCode(this.nbt);
        return result;
    }

    public boolean isEmpty() {
        return this.values.length == 0;
    }

    public FluidStack[] getStacks() {
        if (this.changed || this.stacks == null) {
            ObjectArrayList fluidStacks = new ObjectArrayList(1);
            ObjectArrayList found = new ObjectArrayList(1);
            for (Value value : this.values) {
                for (Fluid fluid : value.getFluids()) {
                    if (found.contains(fluid)) continue;
                    found.add(fluid);
                    fluidStacks.add(new FluidStack(fluid, this.amount, this.nbt));
                }
            }
            this.stacks = (FluidStack[])fluidStacks.toArray(FluidStack[]::new);
            this.changed = false;
        }
        return this.stacks;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.changed = true;
    }

    public void shrink(int amount) {
        this.setAmount(this.amount - amount);
    }

    public void setNbt(CompoundTag nbt) {
        this.nbt = nbt;
        this.changed = true;
    }

    public static FluidIngredient of() {
        return EMPTY;
    }

    public static FluidIngredient of(Fluid fluid, int amount) {
        return FluidIngredient.of(fluid, amount, null);
    }

    public static FluidIngredient of(Fluid fluid, int amount, @Nullable CompoundTag nbt) {
        return FluidIngredient.fromValue(new FluidValue(fluid), amount, nbt);
    }

    public static FluidIngredient of(List<Fluid> fluids, int amount, @Nullable CompoundTag nbt) {
        if (fluids.isEmpty()) {
            return EMPTY;
        }
        if (fluids.size() == 1) {
            return FluidIngredient.of(fluids.get(0), amount, nbt);
        }
        ArrayList<FluidValue> values = new ArrayList<FluidValue>();
        for (Fluid fluid : fluids) {
            values.add(new FluidValue(fluid));
        }
        return FluidIngredient.fromValues(values, amount, nbt);
    }

    public static FluidIngredient of(FluidStack stack) {
        if (stack.isEmpty()) {
            return EMPTY;
        }
        return FluidIngredient.fromValue(new FluidValue(stack.getFluid()), stack.getAmount(), stack.getTag());
    }

    public static FluidIngredient of(List<FluidStack> stacks) {
        if (stacks.isEmpty()) {
            return EMPTY;
        }
        if (stacks.size() == 1) {
            return FluidIngredient.of(stacks.get(0));
        }
        ArrayList<FluidValue> values = new ArrayList<FluidValue>();
        CompoundTag tag = null;
        for (FluidStack stack : stacks) {
            if (stack.isEmpty()) continue;
            values.add(new FluidValue(stack.getFluid()));
            if (tag != null) continue;
            tag = stack.getTag();
        }
        return FluidIngredient.fromValues(values, stacks.get(0).getAmount(), tag);
    }

    public static FluidIngredient of(TagKey<Fluid> tag, int amount) {
        return FluidIngredient.fromValue(new TagValue(tag), amount, null);
    }

    public static FluidIngredient of(TagKey<Fluid> tag, int amount, @Nullable CompoundTag nbt) {
        return FluidIngredient.fromValue(new TagValue(tag), amount, nbt);
    }

    public static FluidIngredient fromNetwork(FriendlyByteBuf buffer) {
        List fluids = buffer.m_236845_(buf -> (Fluid)buf.m_236816_((IdMap)BuiltInRegistries.f_257020_));
        return FluidIngredient.of(fluids, buffer.m_130242_(), buffer.m_130260_());
    }

    public static FluidIngredient fromJson(@Nullable JsonElement json) {
        return FluidIngredient.fromJson(json, true);
    }

    public static FluidIngredient fromJson(@Nullable JsonElement json, boolean allowEmpty) {
        CompoundTag nbt;
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Fluid ingredient cannot be null");
        }
        JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)json, (String)"ingredient");
        if (GsonHelper.m_144772_((JsonObject)jsonObject, (String)"count_provider")) {
            return IntProviderFluidIngredient.fromJson(json);
        }
        int amount = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"amount", (int)0);
        CompoundTag compoundTag = nbt = jsonObject.has("nbt") ? CraftingHelper.getNBT((JsonElement)jsonObject.get("nbt")) : null;
        if (GsonHelper.m_144772_((JsonObject)jsonObject, (String)"value")) {
            Value value = FluidIngredient.valueFromJson(GsonHelper.m_13930_((JsonObject)jsonObject, (String)"value"));
            return FluidIngredient.fromValue(value, amount, nbt);
        }
        if (GsonHelper.m_13885_((JsonObject)jsonObject, (String)"value")) {
            JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"value");
            if (jsonArray.isEmpty() && !allowEmpty) {
                throw new JsonSyntaxException("Fluid array cannot be empty, at least one fluid must be defined");
            }
            ArrayList<Value> values = new ArrayList<Value>();
            for (JsonElement e : jsonArray) {
                values.add(FluidIngredient.valueFromJson(GsonHelper.m_13918_((JsonElement)e, (String)"fluid")));
            }
            return FluidIngredient.fromValues(values, amount, nbt);
        }
        if (GsonHelper.m_13813_((JsonObject)jsonObject, (String)"value")) {
            String value = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"value");
            if (value.startsWith("#")) {
                ResourceLocation resourceLocation = new ResourceLocation(value.substring(1));
                TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)resourceLocation);
                return FluidIngredient.fromValue(new TagValue((TagKey<Fluid>)tagKey), amount, nbt);
            }
            Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(value));
            return FluidIngredient.fromValue(new FluidValue(fluid), amount, nbt);
        }
        throw new JsonSyntaxException("expected 'value' to be an object, an array or a string.");
    }

    private static Value valueFromJson(JsonObject json) {
        if (json.has("fluid") && json.has("tag")) {
            throw new JsonParseException("A fluid ingredient entry is either a tag or a fluid, not both");
        }
        if (json.has("fluid")) {
            Fluid fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"fluid")));
            return new FluidValue(fluid);
        }
        if (json.has("tag")) {
            ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"tag"));
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256808_, (ResourceLocation)resourceLocation);
            return new TagValue((TagKey<Fluid>)tagKey);
        }
        throw new JsonParseException("A fluid ingredient entry needs either a tag or a fluid");
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }

    @Generated
    public CompoundTag getNbt() {
        return this.nbt;
    }

    public static interface Value {
        public Collection<Fluid> getFluids();

        public JsonObject serialize();
    }

    public record TagValue(TagKey<Fluid> tag) implements Value
    {
        @Override
        public Collection<Fluid> getFluids() {
            ArrayList list = Lists.newArrayList();
            for (Holder holder : BuiltInRegistries.f_257020_.m_206058_(this.tag)) {
                list.add((Fluid)holder.m_203334_());
            }
            return list;
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("tag", this.tag.f_203868_().toString());
            return jsonObject;
        }
    }

    public record FluidValue(Fluid fluid) implements Value
    {
        @Override
        public Collection<Fluid> getFluids() {
            return Collections.singleton(this.fluid);
        }

        @Override
        public JsonObject serialize() {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("fluid", BuiltInRegistries.f_257020_.m_7981_((Object)this.fluid).toString());
            return jsonObject;
        }
    }
}

