/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.content;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.logging.log4j.Logger;

public interface IContentSerializer<T> {
    default public void toNetwork(FriendlyByteBuf buf, T content) {
        buf.m_272073_(this.codec(), content);
    }

    default public T fromNetwork(FriendlyByteBuf buf) {
        return (T)buf.m_271872_(this.codec());
    }

    default public T fromJson(JsonElement json) {
        return (T)this.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
    }

    default public JsonElement toJson(T content) {
        return (JsonElement)this.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, content).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
    }

    public T of(Object var1);

    public T defaultValue();

    default public void toNetworkContent(FriendlyByteBuf buf, Content content) {
        Object inner = content.getContent();
        this.toNetwork(buf, inner);
        buf.m_130130_(content.chance);
        buf.m_130130_(content.maxChance);
        buf.m_130130_(content.tierChanceBoost);
    }

    default public Content fromNetworkContent(FriendlyByteBuf buf) {
        T inner = this.fromNetwork(buf);
        int chance = buf.m_130242_();
        int maxChance = buf.m_130242_();
        int tierChanceBoost = buf.m_130242_();
        return new Content(inner, chance, maxChance, tierChanceBoost);
    }

    public Class<T> contentClass();

    public Codec<T> codec();

    default public JsonElement toJsonContent(Content content) {
        JsonObject json = new JsonObject();
        json.add("content", this.toJson(content.getContent()));
        json.addProperty("chance", (Number)content.chance);
        json.addProperty("maxChance", (Number)content.maxChance);
        json.addProperty("tierChanceBoost", (Number)content.tierChanceBoost);
        return json;
    }

    default public Content fromJsonContent(JsonElement json) {
        JsonObject jsonObject = json.getAsJsonObject();
        T inner = this.fromJson(jsonObject.get("content"));
        int chance = jsonObject.has("chance") ? jsonObject.get("chance").getAsInt() : ChanceLogic.getMaxChancedValue();
        int maxChance = jsonObject.has("maxChance") ? jsonObject.get("maxChance").getAsInt() : ChanceLogic.getMaxChancedValue();
        int tierChanceBoost = jsonObject.has("tierChanceBoost") ? jsonObject.get("tierChanceBoost").getAsInt() : 0;
        return new Content(inner, chance, maxChance, tierChanceBoost);
    }

    default public Tag toNbt(T content) {
        return (Tag)this.codec().encodeStart((DynamicOps)NbtOps.f_128958_, content).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
    }

    default public T fromNbt(Tag tag) {
        return (T)this.codec().parse((DynamicOps)NbtOps.f_128958_, (Object)tag).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
    }
}

