/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.condition;

import com.gregtechceu.gtceu.api.registry.GTRegistries;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluids;

public class ConditionSerializeUtils {
    public static <T> String encodeHolderSets(List<HolderSet<T>> items) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (HolderSet<T> holderSet : items) {
            if (!first) {
                sb.append("|");
            }
            sb.append(ConditionSerializeUtils.encodeHolderSet(holderSet));
            first = false;
        }
        return sb.toString();
    }

    public static <T> String encodeHolderSet(HolderSet<T> holderSet) {
        return (String)holderSet.m_203440_().map(tagKey -> "#" + String.valueOf(tagKey.f_203868_()), holders -> holders.stream().map(holder -> ConditionSerializeUtils.getStringFromHolder(holder)).collect(Collectors.joining(",")));
    }

    public static <T> String getStringFromHolder(Holder<T> holder) {
        Optional keyOpt = holder.m_203543_();
        if (keyOpt.isPresent()) {
            return ((ResourceKey)keyOpt.get()).m_135782_().toString();
        }
        Optional tagOpt = holder.m_203616_().findFirst();
        if (tagOpt.isPresent()) {
            return "#" + String.valueOf(((TagKey)tagOpt.get()).f_203868_());
        }
        throw new RuntimeException("Could not serialize holder: " + String.valueOf(holder));
    }

    public static <T> List<HolderSet<T>> decodeHolderSets(String encodedString, ResourceKey<? extends Registry<T>> registryKey) {
        ArrayList<HolderSet<T>> result = new ArrayList<HolderSet<T>>();
        for (String token : encodedString.split("\\|")) {
            if (token.isBlank()) continue;
            result.add(ConditionSerializeUtils.decodeSingleHolderSet(token, registryKey));
        }
        return result;
    }

    public static <T> HolderSet<T> decodeSingleHolderSet(String encodedSet, ResourceKey<? extends Registry<T>> registryKey) {
        if ((encodedSet = encodedSet.trim()).isEmpty()) {
            return HolderSet.m_205800_(List.of());
        }
        Registry registry = (Registry)GTRegistries.builtinRegistry().m_6632_(registryKey).get();
        if (encodedSet.startsWith("#")) {
            ResourceLocation tagId = new ResourceLocation(encodedSet.substring(1));
            TagKey tagKey = TagKey.m_203882_(registryKey, (ResourceLocation)tagId);
            return registry.m_203561_(tagKey);
        }
        String[] parts = encodedSet.split(",");
        ArrayList<Holder> holders = new ArrayList<Holder>();
        for (String part : parts) {
            ResourceLocation rl = new ResourceLocation(part.trim());
            Object item = registry.m_7745_(rl);
            if (item == null || item == ConditionSerializeUtils.getDefaultEmptyValue(registryKey)) {
                throw new RuntimeException("Unknown ID for registry " + String.valueOf(registryKey.m_135782_()) + ": " + String.valueOf(rl));
            }
            holders.add(registry.m_263177_(item));
        }
        return HolderSet.m_205800_(holders);
    }

    private static <T> T getDefaultEmptyValue(ResourceKey<? extends Registry<T>> registryKey) {
        if (registryKey.m_135782_().equals((Object)Registries.f_256808_.m_135782_())) {
            return (T)Fluids.f_76191_;
        }
        if (registryKey.m_135782_().equals((Object)Registries.f_256747_.m_135782_())) {
            return (T)Blocks.f_50016_;
        }
        throw new IllegalArgumentException("Unsupported registry type for default value lookup: " + String.valueOf(registryKey.m_135782_()));
    }
}

