/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.item.FacadeItemBehaviour;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class FacadeCoverRecipe
implements CraftingRecipe {
    public static final FacadeCoverRecipe INSTANCE = new FacadeCoverRecipe();
    public static final RecipeSerializer<FacadeCoverRecipe> SERIALIZER = new RecipeSerializer<FacadeCoverRecipe>(){

        public FacadeCoverRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            return INSTANCE;
        }

        public FacadeCoverRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return INSTANCE;
        }

        public void toNetwork(FriendlyByteBuf buffer, FacadeCoverRecipe recipe) {
        }
    };
    public static ResourceLocation ID = GTCEu.id("crafting/facade_cover");

    public boolean matches(CraftingContainer container, Level level) {
        int platesCount = 0;
        boolean foundBlockItem = false;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack item = container.m_8020_(i);
            if (item.m_41619_()) continue;
            if (FacadeItemBehaviour.isValidFacade(item)) {
                if (foundBlockItem) {
                    return false;
                }
                foundBlockItem = true;
                continue;
            }
            if (item.m_204117_(ChemicalHelper.getTag(TagPrefix.plate, GTMaterials.Iron))) {
                if (platesCount > 3) {
                    return false;
                }
                ++platesCount;
                continue;
            }
            return false;
        }
        return foundBlockItem && platesCount == 3;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryManager) {
        ItemStack itemStack = GTItems.COVER_FACADE.asStack();
        BlockState facadeState = null;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack item = container.m_8020_(i);
            if (item.m_41619_() || !FacadeItemBehaviour.isValidFacade(item)) continue;
            facadeState = FacadeItemBehaviour.getFacadeState(item);
            break;
        }
        if (facadeState != null) {
            FacadeItemBehaviour.setFacadeState(itemStack, facadeState);
            itemStack.m_41764_(6);
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_204132_(ChemicalHelper.getTag(TagPrefix.plate, GTMaterials.Iron)), Ingredient.m_204132_(ChemicalHelper.getTag(TagPrefix.plate, GTMaterials.Iron)), Ingredient.m_204132_(ChemicalHelper.getTag(TagPrefix.plate, GTMaterials.Iron)), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50069_})});
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 4;
    }

    public ItemStack m_8043_(RegistryAccess registryManager) {
        ItemStack result = GTItems.COVER_FACADE.asStack();
        FacadeItemBehaviour.setFacadeState(result, Blocks.f_50069_.m_49966_());
        return result;
    }

    public ResourceLocation m_6423_() {
        return ID;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public CraftingBookCategory m_245232_() {
        return CraftingBookCategory.MISC;
    }
}

