/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.steam;

import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.EnergyStack;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.GTMath;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class SteamEnergyRecipeHandler
implements IRecipeHandler<EnergyStack> {
    private final NotifiableFluidTank steamTank;
    private final double conversionRate;

    public SteamEnergyRecipeHandler(NotifiableFluidTank steamTank, double conversionRate) {
        this.steamTank = steamTank;
        this.conversionRate = conversionRate;
    }

    @Override
    public List<EnergyStack> handleRecipeInner(IO io, GTRecipe recipe, List<EnergyStack> left, boolean simulate) {
        ListIterator<EnergyStack> it = left.listIterator();
        while (it.hasNext()) {
            EnergyStack stack = it.next();
            if (stack.isEmpty()) {
                it.remove();
                continue;
            }
            long totalEU = stack.getTotalEU();
            int totalSteam = GTMath.saturatedCast((long)Math.ceil((double)totalEU * this.conversionRate));
            if (totalSteam <= 0) continue;
            FluidIngredient steam = io == IO.IN ? FluidIngredient.of(GTMaterials.Steam.getFluidTag(), totalSteam) : FluidIngredient.of(GTMaterials.Steam.getFluid(totalSteam));
            ArrayList<FluidIngredient> list = new ArrayList<FluidIngredient>();
            list.add(steam);
            List<FluidIngredient> leftSteam = this.steamTank.handleRecipeInner(io, recipe, (List<FluidIngredient>)list, simulate);
            if (leftSteam == null || leftSteam.isEmpty()) {
                it.remove();
                continue;
            }
            totalEU = (long)((double)leftSteam.get(0).getAmount() / this.conversionRate);
            it.set(new EnergyStack(totalEU));
        }
        return left.isEmpty() ? null : left;
    }

    @Override
    @NotNull
    public List<Object> getContents() {
        ArrayList<FluidStack> tankContents = new ArrayList<FluidStack>();
        for (int i = 0; i < this.steamTank.getTanks(); ++i) {
            FluidStack stack = this.steamTank.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            tankContents.add(stack);
        }
        long sum = tankContents.stream().mapToLong(FluidStack::getAmount).sum();
        long realSum = (long)Math.ceil((double)sum * this.conversionRate);
        return List.of(Long.valueOf(realSum));
    }

    @Override
    public double getTotalContentAmount() {
        ArrayList<FluidStack> tankContents = new ArrayList<FluidStack>();
        for (int i = 0; i < this.steamTank.getTanks(); ++i) {
            FluidStack stack = this.steamTank.getFluidInTank(i);
            if (stack.isEmpty()) continue;
            tankContents.add(stack);
        }
        long sum = tankContents.stream().mapToLong(FluidStack::getAmount).sum();
        return (long)Math.ceil((double)sum * this.conversionRate);
    }

    @Override
    public RecipeCapability<EnergyStack> getCapability() {
        return EURecipeCapability.CAP;
    }

    public long getCapacity() {
        return this.steamTank.getTankCapacity(0);
    }

    public long getStored() {
        FluidStack stack = this.steamTank.getFluidInTank(0);
        if (stack != FluidStack.EMPTY) {
            return stack.getAmount();
        }
        return 0L;
    }
}

